/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.stats.Stats;
import com.sun.identity.sm.ServiceManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SubjectEvaluationCache {
    public static Map subjectEvaluationCache = new HashMap();
    public static long subjectEvalCacheTTL = 0L;
    private static final long DEFAULT_SUBJECT_EVAL_CACHE_TTL = 600000L;
    private static final Debug DEBUG = PolicyManager.debug;

    static void initSubjectEvalTTLFromPolicyConfig() {
        if (subjectEvalCacheTTL == 0L) {
            block6: {
                String orgName = ServiceManager.getBaseDN();
                try {
                    Map pConfigValues = PolicyConfig.getPolicyConfig(orgName);
                    subjectEvalCacheTTL = PolicyConfig.getSubjectsResultTtl(pConfigValues);
                    if (subjectEvalCacheTTL <= 0L) {
                        subjectEvalCacheTTL = 600000L;
                        if (DEBUG.warningEnabled()) {
                            DEBUG.warning("Invalid Subject TTL got from configuration. Set TTL to default:" + subjectEvalCacheTTL);
                        }
                    }
                }
                catch (PolicyException pe) {
                    if (!DEBUG.warningEnabled()) break block6;
                    DEBUG.warning("Could not read Policy Config data. Set TTL to default:" + subjectEvalCacheTTL, pe);
                }
            }
            if (DEBUG.messageEnabled()) {
                DEBUG.message("subjectEvalCacheTTL=" + subjectEvalCacheTTL);
            }
        }
    }

    public static long getSubjectEvalTTL() {
        SubjectEvaluationCache.initSubjectEvalTTLFromPolicyConfig();
        return subjectEvalCacheTTL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntry(String tokenID, String ldapServer, String valueDN, boolean member) {
        String subjectId = ldapServer + ":" + valueDN;
        Map<String, long[]> subjectEntries = null;
        long[] elem = new long[2];
        Map map = subjectEvaluationCache;
        synchronized (map) {
            elem[0] = System.currentTimeMillis() + SubjectEvaluationCache.getSubjectEvalTTL();
            elem[1] = member ? 1L : 0L;
            subjectEntries = (Map<String, long[]>)subjectEvaluationCache.get(tokenID);
            if (subjectEntries != null) {
                subjectEntries.put(subjectId, elem);
            } else {
                subjectEntries = Collections.synchronizedMap(new HashMap());
                subjectEntries.put(subjectId, elem);
                subjectEvaluationCache.put(tokenID, subjectEntries);
            }
        }
    }

    public static Boolean isMember(String tokenID, String ldapServer, String valueDN) {
        Boolean member = null;
        String subjectId = ldapServer + ":" + valueDN;
        Map subjectEntries = null;
        subjectEntries = (Map)subjectEvaluationCache.get(tokenID);
        if (subjectEntries != null) {
            long currentTime;
            long[] element = (long[])subjectEntries.get(subjectId);
            long timeToLive = 0L;
            if (element != null && (timeToLive = element[0]) > (currentTime = System.currentTimeMillis())) {
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("SubjectEvaluationCache.isMember(): get the membership result from cache.\n");
                }
                member = element[1] == 1L ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printStats(Stats policyStats) {
        int cacheSize = 0;
        Map map = subjectEvaluationCache;
        synchronized (map) {
            cacheSize = subjectEvaluationCache.size();
        }
        policyStats.record("SubjectEvaluationCache: Number of entries in cache : " + cacheSize);
    }
}

