/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.assertion.impl;

import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.AuthnContext;
import com.sun.identity.saml2.assertion.AuthnStatement;
import com.sun.identity.saml2.assertion.SubjectLocality;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.Date;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthnStatementImpl
implements AuthnStatement {
    private AuthnContext authnContext = null;
    private SubjectLocality subjectLocality = null;
    private Date authnInstant = null;
    private String sessionIndex = null;
    private Date sessionNotOnOrAfter = null;
    private boolean mutable = true;

    private void validateData() throws SAML2Exception {
        if (this.authnContext == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AuthnStatementImpl.validateData: missing Element AuthnContext.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingElement"));
        }
        if (this.authnInstant == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AuthnStatementImpl.validateData: missing attribute AuthnInstant.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingAttribute"));
        }
    }

    private void parseElement(Element element) throws SAML2Exception {
        if (element == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AuthnStatementImpl.parseElement: Input is null.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        if (!SAML2SDKUtils.checkStatement(element, "AuthnStatement")) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AuthnStatementImpl.parseElement: not AuthnStatement.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        NamedNodeMap atts = element.getAttributes();
        if (atts != null) {
            Node att = atts.getNamedItem("AuthnInstant");
            if (att != null) {
                try {
                    this.authnInstant = DateUtils.stringToDate(((Attr)att).getValue().trim());
                }
                catch (ParseException pe) {
                    throw new SAML2Exception(pe.getMessage());
                }
            }
            if ((att = atts.getNamedItem("SessionIndex")) != null) {
                this.sessionIndex = ((Attr)att).getValue().trim();
            }
            if ((att = atts.getNamedItem("SessionNotOnOrAfter")) != null) {
                try {
                    this.sessionNotOnOrAfter = DateUtils.stringToDate(((Attr)att).getValue().trim());
                }
                catch (ParseException pe) {
                    throw new SAML2Exception(pe.getMessage());
                }
            }
        }
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("SubjectLocality")) {
                if (this.subjectLocality != null) {
                    if (SAML2SDKUtils.debug.messageEnabled()) {
                        SAML2SDKUtils.debug.message("AuthnStatementImpl.parseElement: included more than one SubjectLocality.");
                    }
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("moreElement"));
                }
                if (this.authnContext != null) {
                    if (SAML2SDKUtils.debug.messageEnabled()) {
                        SAML2SDKUtils.debug.message("AuthnStatementImpl.parseElement: SubjectLocality is out of sequence.");
                    }
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("schemaViolation"));
                }
                this.subjectLocality = AssertionFactory.getInstance().createSubjectLocality((Element)child);
                continue;
            }
            if (childName.equals("AuthnContext")) {
                if (this.authnContext != null) {
                    if (SAML2SDKUtils.debug.messageEnabled()) {
                        SAML2SDKUtils.debug.message("AuthnStatementImpl.parseElement: included more than one AuthnContext.");
                    }
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("moreElement"));
                }
                this.authnContext = AssertionFactory.getInstance().createAuthnContext((Element)child);
                continue;
            }
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("AuthnStatementImpl.parseElement: Invalid element:" + childName);
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalidElement"));
        }
        this.validateData();
        this.mutable = false;
    }

    public AuthnStatementImpl() {
    }

    public AuthnStatementImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
    }

    public AuthnStatementImpl(String xmlString) throws SAML2Exception {
        Document doc = XMLUtils.toDOMDocument(xmlString, SAML2SDKUtils.debug);
        if (doc == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(doc.getDocumentElement());
    }

    public AuthnContext getAuthnContext() {
        return this.authnContext;
    }

    public void setAuthnContext(AuthnContext value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.authnContext = value;
    }

    public Date getAuthnInstant() {
        return this.authnInstant;
    }

    public void setAuthnInstant(Date value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.authnInstant = value;
    }

    public SubjectLocality getSubjectLocality() {
        return this.subjectLocality;
    }

    public void setSubjectLocality(SubjectLocality value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.subjectLocality = value;
    }

    public String getSessionIndex() {
        return this.sessionIndex;
    }

    public void setSessionIndex(String value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.sessionIndex = value;
    }

    public Date getSessionNotOnOrAfter() {
        return this.sessionNotOnOrAfter;
    }

    public void setSessionNotOnOrAfter(Date value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.sessionNotOnOrAfter = value;
    }

    public void makeImmutable() {
        if (this.mutable) {
            if (this.subjectLocality != null) {
                this.subjectLocality.makeImmutable();
            }
            if (this.authnContext != null) {
                this.authnContext.makeImmutable();
            }
            this.mutable = false;
        }
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws SAML2Exception {
        this.validateData();
        StringBuffer result = new StringBuffer(1000);
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "saml:";
        }
        if (declareNS) {
            uri = " xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"";
        }
        result.append("<").append(prefix).append("AuthnStatement").append(uri).append(" AuthnInstant=\"").append(DateUtils.toUTCDateFormat(this.authnInstant)).append("\"");
        if (this.sessionIndex != null && this.sessionIndex.trim().length() != 0) {
            result.append(" SessionIndex=\"").append(this.sessionIndex).append("\"");
        }
        if (this.sessionNotOnOrAfter != null) {
            result.append(" SessionNotOnOrAfter=\"").append(DateUtils.toUTCDateFormat(this.sessionNotOnOrAfter)).append("\"");
        }
        result.append(">");
        if (this.subjectLocality != null) {
            result.append(this.subjectLocality.toXMLString(includeNS, declareNS));
        }
        result.append(this.authnContext.toXMLString(includeNS, declareNS));
        result.append("</").append(prefix).append("AuthnStatement>");
        return result.toString();
    }
}

