/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.sts;

import com.sun.identity.classloader.FAMClassLoader;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.provider.ProviderConfig;
import com.sun.identity.wss.provider.STSConfig;
import com.sun.identity.wss.provider.TrustAuthorityConfig;
import com.sun.identity.wss.security.AssertionToken;
import com.sun.identity.wss.security.SAML2Token;
import com.sun.identity.wss.security.SecurityToken;
import com.sun.identity.wss.sts.FAMSTSException;
import com.sun.identity.wss.sts.STSConstants;
import com.sun.identity.wss.sts.STSUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.ServletContext;
import org.w3c.dom.Element;

public class TrustAuthorityClient {
    private static Debug debug = STSUtils.debug;
    public static String[] jars = new String[]{"webservices-api.jar", "webservices-rt.jar", "webservices-tools.jar", "webservices-extra-api.jar", "webservices-extra.jar", "openssoclientsdk.jar", "openssowssproviders.jar", "xalan.jar", "xercesImpl.jar"};

    public SecurityToken getSecurityToken(ProviderConfig pc, Object ssoToken) throws FAMSTSException {
        return this.getSecurityToken(pc, null, null, null, ssoToken, null, null);
    }

    public SecurityToken getSecurityToken(ProviderConfig pc, Object ssoToken, ServletContext context) throws FAMSTSException {
        return this.getSecurityToken(pc, null, null, null, ssoToken, null, context);
    }

    public SecurityToken getSecurityToken(String wspEndPoint, String stsEndPoint, String stsMexEndPoint, Object ssoToken, String securityMech, ServletContext context) throws FAMSTSException {
        return this.getSecurityToken(null, wspEndPoint, stsEndPoint, stsMexEndPoint, ssoToken, securityMech, context);
    }

    private SecurityToken getSecurityToken(ProviderConfig pc, String wspEndPoint, String stsEndPoint, String stsMexEndPoint, Object ssoToken, String securityMech, ServletContext context) throws FAMSTSException {
        if (pc != null) {
            List securityMechanisms = pc.getSecurityMechanisms();
            if (securityMechanisms == null || securityMechanisms.isEmpty()) {
                if (debug.messageEnabled()) {
                    debug.message("TrustAuthorityClient.getSecurityToken::Security Mechanisms are not configured");
                }
                return null;
            }
            securityMech = (String)securityMechanisms.get(0);
            STSConfig stsConfig = null;
            TrustAuthorityConfig taconfig = pc.getTrustAuthorityConfig();
            if (!(taconfig instanceof STSConfig)) {
                throw new FAMSTSException("invalid trust authority config");
            }
            stsConfig = (STSConfig)taconfig;
            stsEndPoint = stsConfig.getEndpoint();
            stsMexEndPoint = stsConfig.getMexEndpoint();
            wspEndPoint = pc.getWSPEndpoint();
        }
        if (securityMech.equals("urn:sun:wss:sts:security")) {
            return this.getSTSToken(wspEndPoint, stsEndPoint, stsMexEndPoint, ssoToken, context);
        }
        if (securityMech.equals("urn:sun:liberty:discovery:security")) {
            return this.getLibertyToken(pc, ssoToken);
        }
        debug.error("TrustAuthorityClient.getSecurityTokenInvalid security mechanism to get token from TA");
        return null;
    }

    public SecurityToken renewIssuedToken(SecurityToken securityToken, ProviderConfig pc, Object ssoToken) throws FAMSTSException {
        return null;
    }

    public boolean cancelIssuedToken(SecurityToken securityToken, ProviderConfig pc) throws FAMSTSException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SecurityToken getSTSToken(String wspEndPoint, String stsEndpoint, String stsMexAddress, Object ssoToken, ServletContext context) throws FAMSTSException {
        if (debug.messageEnabled()) {
            debug.message("TrustAuthorityClient.getSTSToken:: stsEndpoint : " + stsEndpoint);
            debug.message("TrustAuthorityClient.getSTSToken:: stsMexAddress : " + stsMexAddress);
            debug.message("TrustAuthorityClient.getSTSToken:: wsp end point : " + wspEndPoint);
        }
        ClassLoader oldcc = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cls = FAMClassLoader.getFAMClassLoader(context, jars);
            Thread.currentThread().setContextClassLoader(cls);
            Class<?> _handlerTrustAuthorityClient = cls.loadClass("com.sun.identity.wss.sts.TrustAuthorityClientImpl");
            Constructor<?> taClientCon = _handlerTrustAuthorityClient.getConstructor(new Class[0]);
            Object stsClient = taClientCon.newInstance(new Object[0]);
            Class[] clsa = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.Object")};
            Method getSTSTokenElement = stsClient.getClass().getDeclaredMethod("getSTSTokenElement", clsa);
            Object[] args = new Object[]{wspEndPoint, stsEndpoint, stsMexAddress, ssoToken};
            Element element = (Element)getSTSTokenElement.invoke(stsClient, args);
            String type = this.getTokenType(element);
            if (debug.messageEnabled()) {
                debug.message("TrustAuthorityClient.getSTSToken:: Token type : " + type);
                debug.message("TrustAuthorityClient.getSTSToken:: Assertion obtained from STS : " + XMLUtils.print(element));
            }
            if (type == null) throw new FAMSTSException("Token type is NULL.");
            if (type.equals("urn:oasis:names:tc:SAML:2.0:assertion")) {
                SAML2Token sAML2Token = new SAML2Token(element);
                return sAML2Token;
            }
            if (type.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1")) {
                AssertionToken assertionToken = new AssertionToken(element);
                return assertionToken;
            }
            try {
                throw new FAMSTSException("Token type not supported.");
            }
            catch (Exception ex) {
                debug.error("TrustAuthorityClient.getSTSToken:: Failed inobtainining STS Token : ", ex);
                throw new FAMSTSException("TrustAuthorityClient:ws trust exception");
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                SecurityToken securityToken = null;
                return securityToken;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldcc);
        }
    }

    private SecurityToken getLibertyToken(ProviderConfig pc, Object ssoToken) throws FAMSTSException {
        return null;
    }

    private String getTokenType(Element element) throws FAMSTSException {
        String elemName = element.getLocalName();
        if (elemName == null) {
            throw new FAMSTSException("getTokenType:missing_local_name");
        }
        if (elemName.equals(STSConstants.ASSERTION_ELEMENT)) {
            String attrValue = element.getAttribute("xmlns:saml2");
            if (attrValue != null && attrValue.length() != 0 && attrValue.equals("urn:oasis:names:tc:SAML:2.0:assertion")) {
                return "urn:oasis:names:tc:SAML:2.0:assertion";
            }
            attrValue = element.getAttribute("xmlns:saml");
            if (attrValue != null && attrValue.length() != 0 && attrValue.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                return "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
            }
        } else {
            return "getTokenType:NOT IMPLEMENTED TOKEN TYPE";
        }
        return null;
    }
}

