/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.instantiation;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Branch;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.instantiation.BeanInstantiator;
import org.jbpm.instantiation.ConfigurationPropertyInstantiator;
import org.jbpm.instantiation.ConstructorInstantiator;
import org.jbpm.instantiation.FieldInstantiator;
import org.jbpm.instantiation.Instantiator;
import org.jbpm.instantiation.XmlInstantiator;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;
import org.jbpm.util.EqualsUtil;

public class Delegation
implements Parsable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static Map instantiatorCache = Delegation.createInstantiatorCache();
    long id;
    protected String className;
    protected String configuration;
    protected String configType;
    protected ProcessDefinition processDefinition;
    transient Object instance;
    private static final Log log = LogFactory.getLog((Class)Delegation.class);

    private static Map createInstantiatorCache() {
        HashMap<String, Instantiator> instantiators = new HashMap<String, Instantiator>();
        instantiators.put(null, new FieldInstantiator());
        instantiators.put("field", new FieldInstantiator());
        instantiators.put("bean", new BeanInstantiator());
        instantiators.put("constructor", new ConstructorInstantiator());
        instantiators.put("configuration-property", new ConfigurationPropertyInstantiator());
        instantiators.put("xml", new XmlInstantiator());
        return instantiators;
    }

    public Delegation() {
    }

    public Delegation(Object instance) {
        this.instance = instance;
    }

    public Delegation(String className) {
        this.className = className;
    }

    public void read(Element delegateElement, JpdlXmlReader jpdlReader) {
        this.processDefinition = jpdlReader.getProcessDefinition();
        this.className = delegateElement.attributeValue("class");
        if (this.className == null) {
            jpdlReader.addWarning("no class specified in " + delegateElement.asXML());
        }
        this.configType = delegateElement.attributeValue("config-type");
        if (delegateElement.hasContent()) {
            try {
                StringWriter stringWriter = new StringWriter();
                XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, OutputFormat.createCompactFormat());
                Iterator iter = delegateElement.content().iterator();
                while (iter.hasNext()) {
                    Object node = iter.next();
                    xmlWriter.write(node);
                }
                xmlWriter.flush();
                this.configuration = stringWriter.toString();
            }
            catch (IOException e) {
                jpdlReader.addWarning("io problem while parsing the configuration of " + delegateElement.asXML());
            }
        }
    }

    public void write(Element element) {
        element.addAttribute("class", this.className);
        element.addAttribute("config-type", this.configType);
        String configuration = this.configuration;
        if (configuration != null) {
            try {
                Element actionElement = DocumentHelper.parseText((String)("<action>" + configuration + "</action>")).getRootElement();
                element.appendContent((Branch)actionElement);
            }
            catch (DocumentException e) {
                log.error((Object)("couldn't create dom-tree for action configuration '" + configuration + "'"), (Throwable)e);
            }
        }
    }

    public Object getInstance() {
        if (this.instance == null) {
            this.instance = this.instantiate();
        }
        return this.instance;
    }

    public Object instantiate() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Instantiator instantiator = (Instantiator)instantiatorCache.get(this.configType);
        if (instantiator == null) {
            try {
                Class<?> instantiatorClass = Class.forName(this.configType, false, classLoader);
                instantiator = (Instantiator)instantiatorClass.newInstance();
                instantiatorCache.put(this.configType, instantiator);
            }
            catch (ClassNotFoundException e) {
                throw new JbpmException("could not load instantiator class '" + this.configType + "'", e);
            }
            catch (InstantiationException e) {
                throw new JbpmException("could not instantiate " + this.configType, e);
            }
            catch (IllegalAccessException e) {
                throw new JbpmException("could not access " + this.configType, e);
            }
        }
        try {
            Class<?> delegationClass = Class.forName(this.className, false, classLoader);
            return instantiator.instantiate(delegationClass, this.configuration);
        }
        catch (ClassNotFoundException e) {
            throw new DelegationException("could not load delegation class '" + this.className + "'", e);
        }
    }

    public boolean equals(Object o) {
        return EqualsUtil.equals(this, o);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getConfigType() {
        return this.configType;
    }

    public void setConfigType(String instantiatorType) {
        this.configType = instantiatorType;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }
}

