/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerable;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"Enumerable::Enumerator"}, include={"Enumerable"})
public class RubyEnumerator
extends RubyObject {
    private IRubyObject object;
    private IRubyObject method;
    private IRubyObject[] methodArgs;
    private static ObjectAllocator ENUMERATOR_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyEnumerator(runtime, klass);
        }
    };

    public static void defineEnumerator(Ruby runtime) {
        RubyModule kernel = runtime.getKernel();
        kernel.defineAnnotatedMethod(RubyEnumerator.class, "obj_to_enum");
        RubyModule enm = runtime.getClassFromPath("Enumerable");
        enm.defineAnnotatedMethod(RubyEnumerator.class, "each_with_index");
        enm.defineAnnotatedMethod(RubyEnumerator.class, "each_slice");
        enm.defineAnnotatedMethod(RubyEnumerator.class, "enum_slice");
        enm.defineAnnotatedMethod(RubyEnumerator.class, "each_cons");
        enm.defineAnnotatedMethod(RubyEnumerator.class, "enum_cons");
        RubyClass enmr = enm.defineClassUnder("Enumerator", runtime.getObject(), ENUMERATOR_ALLOCATOR);
        enmr.includeModule(enm);
        enmr.defineAnnotatedMethod(RubyEnumerator.class, "initialize");
        enmr.defineAnnotatedMethod(RubyEnumerator.class, "each");
    }

    @JRubyMethod(name={"to_enum", "enum_for"}, optional=1, rest=true, frame=true)
    public static IRubyObject obj_to_enum(ThreadContext context, IRubyObject self, IRubyObject[] args, Block block) {
        IRubyObject[] newArgs = new IRubyObject[args.length + 1];
        newArgs[0] = self;
        System.arraycopy(args, 0, newArgs, 1, args.length);
        return self.getRuntime().getEnumerable().fastGetConstant("Enumerator").callMethod(context, "new", newArgs);
    }

    private RubyEnumerator(Ruby runtime, RubyClass type) {
        super(runtime, type);
        this.object = this.method = runtime.getNil();
    }

    @JRubyMethod(name={"initialize"}, required=1, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args) {
        this.object = args[0];
        IRubyObject iRubyObject = this.method = args.length > 1 ? args[1] : this.getRuntime().fastNewSymbol("each");
        if (args.length > 2) {
            this.methodArgs = new IRubyObject[Math.max(0, args.length - 2)];
            System.arraycopy(args, 2, this.methodArgs, 0, args.length - 2);
        } else {
            this.methodArgs = new IRubyObject[0];
        }
        return this;
    }

    @JRubyMethod(name={"each"}, frame=true)
    public IRubyObject each(ThreadContext context, Block block) {
        return this.object.callMethod(context, this.method.asJavaString(), this.methodArgs, block);
    }

    @JRubyMethod(name={"enum_with_index"})
    public static IRubyObject each_with_index(ThreadContext context, IRubyObject self) {
        return self.getRuntime().getEnumerable().fastGetConstant("Enumerator").callMethod(context, "new", new IRubyObject[]{self, self.getRuntime().fastNewSymbol("each_with_index")});
    }

    @JRubyMethod(name={"each_slice"}, required=1, frame=true)
    public static IRubyObject each_slice(ThreadContext context, IRubyObject self, IRubyObject arg, final Block block) {
        final int size = (int)RubyNumeric.num2long(arg);
        if (size <= 0) {
            throw self.getRuntime().newArgumentError("invalid slice size");
        }
        final Ruby runtime = self.getRuntime();
        final RubyArray[] result = new RubyArray[]{runtime.newArray(size)};
        RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){

            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                result[0].append(largs[0]);
                if (result[0].size() == size) {
                    block.yield(ctx, result[0]);
                    result[0] = runtime.newArray(size);
                }
                return runtime.getNil();
            }
        });
        if (result[0].size() > 0) {
            block.yield(context, result[0]);
        }
        return self.getRuntime().getNil();
    }

    @JRubyMethod(name={"each_cons"}, required=1, frame=true)
    public static IRubyObject each_cons(ThreadContext context, IRubyObject self, IRubyObject arg, final Block block) {
        final int size = (int)RubyNumeric.num2long(arg);
        if (size <= 0) {
            throw self.getRuntime().newArgumentError("invalid size");
        }
        final Ruby runtime = self.getRuntime();
        final RubyArray result = runtime.newArray(size);
        RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){

            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                if (result.size() == size) {
                    result.shift();
                }
                result.append(largs[0]);
                if (result.size() == size) {
                    block.yield(ctx, result.aryDup());
                }
                return runtime.getNil();
            }
        });
        return runtime.getNil();
    }

    @JRubyMethod(name={"enum_slice"}, required=1)
    public static IRubyObject enum_slice(ThreadContext context, IRubyObject self, IRubyObject arg) {
        return self.getRuntime().getEnumerable().fastGetConstant("Enumerator").callMethod(context, "new", new IRubyObject[]{self, self.getRuntime().fastNewSymbol("each_slice"), arg});
    }

    @JRubyMethod(name={"enum_cons"}, required=1)
    public static IRubyObject enum_cons(ThreadContext context, IRubyObject self, IRubyObject arg) {
        return self.getRuntime().getEnumerable().fastGetConstant("Enumerator").callMethod(context, "new", new IRubyObject[]{self, self.getRuntime().fastNewSymbol("each_cons"), arg});
    }
}

