/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Main;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.ext.posix.util.FieldAccess;
import org.jruby.ext.posix.util.Platform;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ModeFlags;

public class ShellLauncher {
    private static final boolean DEBUG = false;

    private static String[] getCurrentEnv(Ruby runtime) {
        RubyHash hash = (RubyHash)runtime.getObject().fastGetConstant("ENV");
        String[] ret = new String[hash.size()];
        int i = 0;
        for (Map.Entry e : hash.directEntrySet()) {
            ret[i] = e.getKey().toString() + "=" + e.getValue().toString();
            ++i;
        }
        return ret;
    }

    public static int runAndWait(Ruby runtime, IRubyObject[] rawArgs) {
        return ShellLauncher.runAndWait(runtime, rawArgs, runtime.getOutputStream());
    }

    public static int execAndWait(Ruby runtime, IRubyObject[] rawArgs) {
        String[] args = ShellLauncher.parseCommandLine(runtime, rawArgs);
        if (ShellLauncher.shouldRunInProcess(runtime, args)) {
            try {
                int startIndex;
                File pwd = new File(runtime.getCurrentDirectory());
                String command = args[0];
                int n = startIndex = command.endsWith(".rb") ? 0 : 1;
                if (command.trim().endsWith("irb")) {
                    startIndex = 0;
                    args[0] = runtime.getJRubyHome() + File.separator + "bin" + File.separator + "jirb";
                }
                String[] newargs = new String[args.length - startIndex];
                System.arraycopy(args, startIndex, newargs, 0, newargs.length);
                ScriptThreadProcess ipScript = new ScriptThreadProcess(newargs, ShellLauncher.getCurrentEnv(runtime), pwd, false);
                ipScript.start();
                return ipScript.waitFor();
            }
            catch (IOException e) {
                throw runtime.newIOErrorFromException(e);
            }
            catch (InterruptedException e) {
                throw runtime.newThreadError("unexpected interrupt");
            }
        }
        return ShellLauncher.runAndWait(runtime, rawArgs);
    }

    public static int runAndWait(Ruby runtime, IRubyObject[] rawArgs, OutputStream output) {
        PrintStream error = runtime.getErrorStream();
        InputStream input = runtime.getInputStream();
        try {
            Process aProcess = ShellLauncher.run(runtime, rawArgs);
            ShellLauncher.handleStreams(aProcess, input, output, error);
            return aProcess.waitFor();
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
        catch (InterruptedException e) {
            throw runtime.newThreadError("unexpected interrupt");
        }
    }

    public static Process run(Ruby runtime, IRubyObject string) throws IOException {
        return ShellLauncher.run(runtime, new IRubyObject[]{string});
    }

    public static POpenProcess popen(Ruby runtime, IRubyObject string, ModeFlags modes) throws IOException {
        String shell = ShellLauncher.getShell(runtime);
        POpenProcess aProcess = null;
        Process childProcess = null;
        File pwd = new File(runtime.getCurrentDirectory());
        String[] args = ShellLauncher.parseCommandLine(runtime, new IRubyObject[]{string});
        if (ShellLauncher.shouldRunInShell(shell, args)) {
            String[] argArray = new String[3];
            String cmdline = string.toString();
            argArray[0] = shell;
            argArray[1] = shell.endsWith("sh") ? "-c" : "/c";
            argArray[2] = cmdline;
            childProcess = Runtime.getRuntime().exec(argArray, ShellLauncher.getCurrentEnv(runtime), pwd);
        } else {
            childProcess = Runtime.getRuntime().exec(args, ShellLauncher.getCurrentEnv(runtime), pwd);
        }
        aProcess = new POpenProcess(childProcess, runtime, modes);
        return aProcess;
    }

    public static OutputStream unwrapBufferedStream(OutputStream filteredStream) {
        while (filteredStream instanceof FilterOutputStream) {
            try {
                filteredStream = (OutputStream)FieldAccess.getProtectedFieldValue(FilterOutputStream.class, "out", filteredStream);
            }
            catch (Exception e) {
                break;
            }
        }
        return filteredStream;
    }

    public static InputStream unwrapBufferedStream(InputStream filteredStream) {
        while (filteredStream instanceof FilterInputStream) {
            try {
                filteredStream = (InputStream)FieldAccess.getProtectedFieldValue(FilterInputStream.class, "in", filteredStream);
            }
            catch (Exception e) {
                break;
            }
        }
        return filteredStream;
    }

    public static Process run(Ruby runtime, IRubyObject[] rawArgs) throws IOException {
        String shell = ShellLauncher.getShell(runtime);
        Process aProcess = null;
        File pwd = new File(runtime.getCurrentDirectory());
        String[] args = ShellLauncher.parseCommandLine(runtime, rawArgs);
        if (ShellLauncher.shouldRunInProcess(runtime, args)) {
            int startIndex;
            String command = args[0];
            int n = startIndex = command.endsWith(".rb") ? 0 : 1;
            if (command.trim().endsWith("irb")) {
                startIndex = 0;
                args[0] = runtime.getJRubyHome() + File.separator + "bin" + File.separator + "jirb";
            }
            String[] newargs = new String[args.length - startIndex];
            System.arraycopy(args, startIndex, newargs, 0, newargs.length);
            ScriptThreadProcess ipScript = new ScriptThreadProcess(newargs, ShellLauncher.getCurrentEnv(runtime), pwd);
            ipScript.start();
            aProcess = ipScript;
        } else if (rawArgs.length == 1 && ShellLauncher.shouldRunInShell(shell, args)) {
            String[] argArray = new String[3];
            String cmdline = rawArgs[0].toString();
            argArray[0] = shell;
            argArray[1] = shell.endsWith("sh") ? "-c" : "/c";
            argArray[2] = cmdline;
            aProcess = Runtime.getRuntime().exec(argArray, ShellLauncher.getCurrentEnv(runtime), pwd);
        } else {
            aProcess = Runtime.getRuntime().exec(args, ShellLauncher.getCurrentEnv(runtime), pwd);
        }
        return aProcess;
    }

    private static void handleStreams(Process p, InputStream in, OutputStream out, OutputStream err) throws IOException {
        InputStream pOut = p.getInputStream();
        InputStream pErr = p.getErrorStream();
        OutputStream pIn = p.getOutputStream();
        StreamPumper t1 = new StreamPumper(pOut, out, false, Pumper.Slave.IN);
        StreamPumper t2 = new StreamPumper(pErr, err, false, Pumper.Slave.IN);
        StreamPumper t3 = new StreamPumper(in, pIn, true, Pumper.Slave.OUT);
        t1.start();
        t2.start();
        t3.start();
        try {
            t1.join();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        try {
            t2.join();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        t3.quit();
        try {
            err.flush();
        }
        catch (IOException io2) {
            // empty catch block
        }
        try {
            out.flush();
        }
        catch (IOException io3) {
            // empty catch block
        }
        try {
            pIn.close();
        }
        catch (IOException io4) {
            // empty catch block
        }
        try {
            pOut.close();
        }
        catch (IOException io5) {
            // empty catch block
        }
        try {
            pErr.close();
        }
        catch (IOException io6) {
            // empty catch block
        }
        try {
            t3.interrupt();
        }
        catch (SecurityException se) {
            // empty catch block
        }
    }

    private static String[] parseCommandLine(Ruby runtime, IRubyObject[] rawArgs) {
        String[] args;
        if (rawArgs.length == 1) {
            RubyArray parts = (RubyArray)runtime.evalScriptlet("require 'jruby/path_helper'; JRuby::PathHelper").callMethod(runtime.getCurrentContext(), "smart_split_command", rawArgs);
            args = new String[parts.getLength()];
            for (int i = 0; i < parts.getLength(); ++i) {
                args[i] = parts.entry(i).toString();
            }
        } else {
            args = new String[rawArgs.length];
            for (int i = 0; i < rawArgs.length; ++i) {
                args[i] = rawArgs[i].toString();
            }
        }
        return args;
    }

    private static boolean shouldRunInProcess(Ruby runtime, String[] commands) {
        if (!runtime.getInstanceConfig().isRunRubyInProcess()) {
            return false;
        }
        for (int i = 0; i < commands.length; ++i) {
            String c = commands[i];
            if (c.trim().length() == 0) continue;
            char[] firstLast = new char[]{c.charAt(0), c.charAt(c.length() - 1)};
            for (int j = 0; j < firstLast.length; ++j) {
                switch (firstLast[j]) {
                    case '<': 
                    case '>': 
                    case '|': {
                        return false;
                    }
                }
            }
        }
        String command = commands[0];
        String[] slashDelimitedTokens = command.split("/");
        String finalToken = slashDelimitedTokens[slashDelimitedTokens.length - 1];
        int indexOfRuby = finalToken.indexOf("ruby");
        return indexOfRuby != -1 && indexOfRuby == finalToken.length() - 4 || finalToken.endsWith(".rb") || finalToken.endsWith("irb");
    }

    private static boolean shouldRunInShell(String shell, String[] args) {
        return !Platform.IS_WINDOWS || shell != null && args.length > 1 && !new File(args[0]).exists();
    }

    private static String getShell(Ruby runtime) {
        return runtime.evalScriptlet("require 'rbconfig'; Config::CONFIG['SHELL']").toString();
    }

    private static class ChannelPumper
    extends Thread
    implements Pumper {
        private FileChannel inChannel;
        private FileChannel outChannel;
        private volatile boolean quit;
        private final Pumper.Slave slave;

        ChannelPumper(FileChannel inChannel, FileChannel outChannel, Pumper.Slave slave) {
            this.inChannel = inChannel;
            this.outChannel = outChannel;
            this.slave = slave;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            ByteBuffer buf = ByteBuffer.allocateDirect(1024);
            buf.clear();
            try {
                int read;
                while (!this.quit && this.inChannel.isOpen() && this.outChannel.isOpen() && (read = this.inChannel.read(buf)) != -1) {
                    buf.flip();
                    this.outChannel.write(buf);
                    buf.clear();
                }
            }
            catch (Exception e) {
                switch (this.slave) {
                    case OUT: {
                        try {
                            this.outChannel.close();
                        }
                        catch (IOException ioe) {}
                        break;
                    }
                    case IN: {
                        try {
                            this.inChannel.close();
                            break;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable throwable) {
                    switch (this.slave) {
                        case OUT: {
                            try {
                                this.outChannel.close();
                            }
                            catch (IOException ioe) {}
                            break;
                        }
                        case IN: {
                            try {
                                this.inChannel.close();
                                break;
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                        }
                    }
                    throw throwable;
                }
            }
            switch (this.slave) {
                case OUT: {
                    try {
                        this.outChannel.close();
                    }
                    catch (IOException ioe) {}
                    break;
                }
                case IN: {
                    try {
                        this.inChannel.close();
                        break;
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
        }

        public void quit() {
            this.interrupt();
            this.quit = true;
        }
    }

    private static class StreamPumper
    extends Thread
    implements Pumper {
        private InputStream in;
        private OutputStream out;
        private boolean onlyIfAvailable;
        private volatile boolean quit;
        private final Object waitLock = new Object();
        private final Pumper.Slave slave;

        StreamPumper(InputStream in, OutputStream out, boolean avail, Pumper.Slave slave) {
            this.in = in;
            this.out = out;
            this.onlyIfAvailable = avail;
            this.slave = slave;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] buf = new byte[1024];
            boolean hasReadSomething = false;
            try {
                while (!this.quit) {
                    int numRead;
                    if (this.onlyIfAvailable && !hasReadSomething) {
                        if (this.in.available() == 0) {
                            Object object = this.waitLock;
                            synchronized (object) {
                                this.waitLock.wait(10L);
                                continue;
                            }
                        }
                        hasReadSomething = true;
                    }
                    if ((numRead = this.in.read(buf)) == -1) {
                        break;
                    }
                    this.out.write(buf, 0, numRead);
                }
            }
            catch (Exception e) {
            }
            finally {
                if (this.onlyIfAvailable && this.slave == Pumper.Slave.OUT) {
                    try {
                        this.out.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            this.quit = true;
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notify();
            }
        }
    }

    private static interface Pumper
    extends Runnable {
        public void start();

        public void quit();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Slave {
            IN,
            OUT;

        }
    }

    public static class POpenProcess
    extends Process {
        private Process child;
        private Ruby runtime;
        private ModeFlags modes;
        private InputStream in;
        private OutputStream out;
        private FileChannel outChannel;
        private FileChannel inChannel;
        private Pumper readPumper;
        private Pumper writePumper;

        public POpenProcess(Process child, Ruby runtime, ModeFlags modes) {
            this.child = child;
            this.runtime = runtime;
            this.modes = modes;
            if (modes.isWritable()) {
                this.out = ShellLauncher.unwrapBufferedStream(child.getOutputStream());
                if (this.out instanceof FileOutputStream) {
                    this.outChannel = ((FileOutputStream)this.out).getChannel();
                }
            } else {
                OutputStream childOut = ShellLauncher.unwrapBufferedStream(child.getOutputStream());
                FileChannel childOutChannel = null;
                if (childOut instanceof FileOutputStream) {
                    childOutChannel = ((FileOutputStream)childOut).getChannel();
                }
                InputStream parentIn = ShellLauncher.unwrapBufferedStream(runtime.getIn());
                FileChannel parentInChannel = null;
                if (parentIn instanceof FileInputStream) {
                    parentInChannel = ((FileInputStream)parentIn).getChannel();
                }
                this.writePumper = parentInChannel != null && childOutChannel != null ? new ChannelPumper(parentInChannel, childOutChannel, Pumper.Slave.OUT) : new StreamPumper(parentIn, childOut, false, Pumper.Slave.OUT);
                this.writePumper.start();
            }
            if (modes.isReadable()) {
                this.in = ShellLauncher.unwrapBufferedStream(child.getInputStream());
                if (this.in instanceof FileInputStream) {
                    this.inChannel = ((FileInputStream)this.in).getChannel();
                }
            } else {
                InputStream childIn = ShellLauncher.unwrapBufferedStream(child.getInputStream());
                FileChannel childInChannel = null;
                if (childIn instanceof FileInputStream) {
                    childInChannel = ((FileInputStream)childIn).getChannel();
                }
                OutputStream parentOut = ShellLauncher.unwrapBufferedStream(runtime.getOut());
                FileChannel parentOutChannel = null;
                if (parentOut instanceof FileOutputStream) {
                    parentOutChannel = ((FileOutputStream)parentOut).getChannel();
                }
                this.readPumper = childInChannel != null && parentOutChannel != null ? new ChannelPumper(childInChannel, parentOutChannel, Pumper.Slave.IN) : new StreamPumper(childIn, parentOut, false, Pumper.Slave.IN);
                this.readPumper.start();
            }
        }

        public OutputStream getOutputStream() {
            return this.out;
        }

        public InputStream getInputStream() {
            return this.in;
        }

        public InputStream getErrorStream() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FileChannel getInput() {
            return this.inChannel;
        }

        public FileChannel getOutput() {
            return this.outChannel;
        }

        public int waitFor() throws InterruptedException {
            if (this.writePumper == null) {
                try {
                    this.out.close();
                }
                catch (IOException ioe) {}
            } else {
                this.writePumper.quit();
            }
            int result = this.child.waitFor();
            return result;
        }

        public int exitValue() {
            return this.child.exitValue();
        }

        public void destroy() {
            try {
                this.in.close();
                this.out.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            this.child.destroy();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScriptThreadProcess
    extends Process
    implements Runnable {
        private String[] argArray;
        private int result;
        private RubyInstanceConfig config;
        private Thread processThread;
        private PipedInputStream processOutput;
        private PipedInputStream processError;
        private PipedOutputStream processInput;
        private final String[] env;
        private final File pwd;
        private final boolean pipedStreams;

        public ScriptThreadProcess(String[] argArray, String[] env, File dir) {
            this(argArray, env, dir, true);
        }

        public ScriptThreadProcess(String[] argArray, String[] env, File dir, boolean pipedStreams) {
            this.argArray = argArray;
            this.env = env;
            this.pwd = dir;
            this.pipedStreams = pipedStreams;
            if (pipedStreams) {
                this.processOutput = new PipedInputStream();
                this.processError = new PipedInputStream();
                this.processInput = new PipedOutputStream();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.result = new Main(this.config).run(this.argArray);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(this.config.getError());
                this.result = -1;
            }
            finally {
                this.config.getOutput().close();
                this.config.getError().close();
            }
        }

        private Map<String, String> environmentMap(String[] env) {
            HashMap<String, String> m = new HashMap<String, String>();
            for (int i = 0; i < env.length; ++i) {
                String[] kv = env[i].split("=", 2);
                m.put(kv[0], kv[1]);
            }
            return m;
        }

        public void start() throws IOException {
            this.config = new RubyInstanceConfig(){
                {
                    this.setEnvironment(ScriptThreadProcess.this.environmentMap(ScriptThreadProcess.this.env));
                    this.setCurrentDirectory(ScriptThreadProcess.this.pwd.toString());
                }
            };
            if (this.pipedStreams) {
                this.config.setInput(new PipedInputStream(this.processInput));
                this.config.setOutput(new PrintStream(new PipedOutputStream(this.processOutput)));
                this.config.setError(new PrintStream(new PipedOutputStream(this.processError)));
            }
            String procName = "piped";
            if (this.argArray.length > 0) {
                procName = this.argArray[0];
            }
            this.processThread = new Thread((Runnable)this, "ScriptThreadProcess: " + procName);
            this.processThread.setDaemon(true);
            this.processThread.start();
        }

        @Override
        public OutputStream getOutputStream() {
            return this.processInput;
        }

        @Override
        public InputStream getInputStream() {
            return this.processOutput;
        }

        @Override
        public InputStream getErrorStream() {
            return this.processError;
        }

        @Override
        public int waitFor() throws InterruptedException {
            this.processThread.join();
            return this.result;
        }

        @Override
        public int exitValue() {
            return this.result;
        }

        @Override
        public void destroy() {
            if (this.pipedStreams) {
                this.closeStreams();
            }
            this.processThread.interrupt();
        }

        private void closeStreams() {
            try {
                this.processInput.close();
            }
            catch (IOException io2) {
                // empty catch block
            }
            try {
                this.processOutput.close();
            }
            catch (IOException io3) {
                // empty catch block
            }
            try {
                this.processError.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

