/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.ConfigurationException;

public class ESBProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ESBProperties.class);

    public ESBProperties(String propertiesResource) throws ConfigurationException {
        InputStream config = StreamUtils.getResource(propertiesResource);
        try {
            this.load(config);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading '" + propertiesResource + "'.", e);
        }
        finally {
            try {
                config.close();
            }
            catch (IOException e) {
                logger.warn((Object)("Failed to close stream to '" + propertiesResource + "'."));
            }
        }
    }

    public int getIntProperty(String key, int defaultVal) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Invalid property value format for property '" + key + "'.  Integer value expected.  Actual value '" + value + "'."));
            return defaultVal;
        }
    }
}

