/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.webservice;

import com.ibm.wsdl.extensions.schema.SchemaImpl;
import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import com.ibm.wsdl.extensions.soap.SOAPFaultImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.internal.soa.esb.webservice.ESBServiceEndpointInfo;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.WebserviceInfo;
import org.jboss.soa.esb.util.ClassUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESBContractGenerator {
    private static final QName XSD_QN = new QName("http://www.w3.org/2001/XMLSchema", "schema");
    private static final String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";
    private static final String WSDL_REQUIRED = "required";
    private static final String WSAW_NAMESPACE = "http://www.w3.org/2006/05/addressing/wsdl";
    private static final String WSAW_PREFIX = "wsaw";
    private static final QName WSAW_ACTION_QN = new QName("http://www.w3.org/2006/05/addressing/wsdl", "Action", "wsaw");
    private static final QName WSAW_USING_ADDRESSING_QN = new QName("http://www.w3.org/2006/05/addressing/wsdl", "UsingAddressing", "wsaw");
    private static WSDLFactory wsdlFactory;

    public static String generateWSDL(WebserviceInfo serviceConfig, ESBServiceEndpointInfo serviceInfo) throws ConfigurationException {
        return ESBContractGenerator.generateWSDL(serviceConfig, serviceInfo, null);
    }

    public static String generateWSDL(WebserviceInfo serviceConfig, ESBServiceEndpointInfo serviceInfo, ClassLoader classLoader) throws ConfigurationException {
        Document doc;
        Definition def = ESBContractGenerator.getWSDLFactory().newDefinition();
        String namespace = serviceInfo.getNamespace();
        def.setTargetNamespace(namespace);
        def.addNamespace("tns", namespace);
        def.addNamespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
        if (serviceInfo.isAddressing()) {
            def.getExtensionRegistry().registerSerializer(Binding.class, WSAW_USING_ADDRESSING_QN, (ExtensionSerializer)new UsingAddressingSerializer());
            def.addNamespace(WSAW_PREFIX, WSAW_NAMESPACE);
        }
        Types types = def.createTypes();
        def.setTypes(types);
        HashSet<String> schemasAdded = new HashSet<String>();
        Message reqMessage = null;
        Message resMessage = null;
        ArrayList<Message> faultMessages = null;
        String inXsd = serviceConfig.getInXsd();
        String outXsd = serviceConfig.getOutXsd();
        String faultXsd = serviceConfig.getFaultXsd();
        int nsSuffixCounter = 0;
        if (inXsd != null) {
            try {
                doc = YADOMUtil.parseStream(ESBContractGenerator.getResourceAsStream(inXsd, classLoader), false, false);
                if (doc != null) {
                    reqMessage = ESBContractGenerator.addMessage(def, doc.getDocumentElement(), serviceInfo.getRequestName(), "in", ++nsSuffixCounter, schemasAdded);
                }
            }
            catch (Exception e) {
                throw new ConfigurationException("File defined in inXsd attribute '" + inXsd + "' not found in classpath.", e);
            }
        }
        if (outXsd != null) {
            try {
                doc = YADOMUtil.parseStream(ESBContractGenerator.getResourceAsStream(outXsd, classLoader), false, false);
                if (doc != null) {
                    resMessage = ESBContractGenerator.addMessage(def, doc.getDocumentElement(), serviceInfo.getResponseName(), "out", ++nsSuffixCounter, schemasAdded);
                }
            }
            catch (Exception e) {
                throw new ConfigurationException("File defined in outXsd attribute '" + outXsd + "' not found in classpath.", e);
            }
        }
        if (faultXsd != null && !serviceInfo.isOneWay()) {
            try {
                String[] xsds = faultXsd.split(",");
                faultMessages = new ArrayList<Message>();
                for (String xsd : xsds) {
                    Document doc2 = YADOMUtil.parseStream(ESBContractGenerator.getResourceAsStream(xsd, classLoader), false, false);
                    if (doc2 == null) continue;
                    ESBContractGenerator.addFaultMessage(faultMessages, def, doc2.getDocumentElement(), serviceInfo.getFaultName(), "fault", ++nsSuffixCounter, schemasAdded);
                }
            }
            catch (Exception e) {
                throw new ConfigurationException("File defined in faultXsd attribute '" + faultXsd + "' not found in classpath.", e);
            }
        }
        PortType portType = ESBContractGenerator.addPortType(def, serviceInfo, reqMessage, resMessage, faultMessages);
        Binding binding = ESBContractGenerator.addBinding(def, serviceInfo, portType);
        ESBContractGenerator.addService(def, serviceInfo, binding);
        StringWriter sw = new StringWriter();
        try {
            ESBContractGenerator.getWSDLFactory().newWSDLWriter().writeWSDL(def, (Writer)sw);
        }
        catch (WSDLException e) {
            Service service = serviceConfig.getService();
            throw new ConfigurationException("Failed to generate wsdl for service:" + service.getCategory() + "/" + service.getName(), e);
        }
        return sw.toString();
    }

    private static void addSchema(Types types, Element xsdElement, Set<String> schemasAdded) throws SAXException, IOException, TransformerException, ParserConfigurationException {
        if (ESBContractGenerator.add(xsdElement, schemasAdded)) {
            SchemaImpl schemaImpl = new SchemaImpl();
            schemaImpl.setElement(xsdElement);
            schemaImpl.setElementType(XSD_QN);
            types.addExtensibilityElement((ExtensibilityElement)schemaImpl);
        }
    }

    private static InputStream getResourceAsStream(String resource, ClassLoader classLoader) {
        InputStream in;
        if (classLoader != null && (in = classLoader.getResourceAsStream(resource)) != null) {
            return in;
        }
        return ClassUtil.getResourceAsStream(resource, ESBContractGenerator.class);
    }

    private static boolean add(Element schemaElement, Set<String> schemasAdded) throws SAXException, IOException, TransformerException, ParserConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(new DOMSource(schemaElement), result);
        String newType = writer.toString();
        if (schemasAdded.size() == 0) {
            return schemasAdded.add(newType);
        }
        boolean addSchema = true;
        for (String existingType : schemasAdded) {
            if (!XMLHelper.compareXMLContent(existingType, newType)) continue;
            addSchema = false;
            break;
        }
        if (addSchema) {
            return schemasAdded.add(newType);
        }
        return false;
    }

    private static Message addMessage(Definition def, Element element, String msgName, String partName, int nsSuffixCounter, Set<String> schemasAdded) throws SAXException, IOException, TransformerException, ParserConfigurationException {
        String schemaNs = YADOMUtil.getAttribute(element, "targetNamespace", "");
        ESBContractGenerator.addSchema(def.getTypes(), element, schemasAdded);
        if (def.getNamespace(schemaNs) == null) {
            def.addNamespace("ns" + nsSuffixCounter, schemaNs);
        }
        Node node = YADOMUtil.getNode(element, "/schema/element");
        Message msg = def.createMessage();
        msg.setQName(new QName(def.getTargetNamespace(), msgName));
        msg.setUndefined(false);
        Part part = def.createPart();
        part.setName(partName);
        part.setElementName(new QName(schemaNs, YADOMUtil.getAttribute((Element)node, "name", "")));
        msg.addPart(part);
        def.addMessage(msg);
        return msg;
    }

    private static void addFaultMessage(List<Message> faultMessages, Definition def, Element element, String msgName, String partName, int nsSuffixCounter, Set<String> schemasAdded) throws SAXException, IOException, TransformerException, ParserConfigurationException {
        String schemaNs = YADOMUtil.getAttribute(element, "targetNamespace", "");
        ESBContractGenerator.addSchema(def.getTypes(), element, schemasAdded);
        if (def.getNamespace(schemaNs) == null) {
            def.addNamespace("ns" + nsSuffixCounter, schemaNs);
        }
        NodeList nodes = YADOMUtil.getNodeList(element, "/schema/element");
        for (int i = 0; i < nodes.getLength(); ++i) {
            int nameIndex = i + 1;
            Node node = nodes.item(0);
            Message msg = def.createMessage();
            msg.setQName(new QName(def.getTargetNamespace(), msgName + nameIndex));
            msg.setUndefined(false);
            Part part = def.createPart();
            part.setName(partName + nameIndex);
            part.setElementName(new QName(schemaNs, YADOMUtil.getAttribute((Element)node, "name", "")));
            msg.addPart(part);
            def.addMessage(msg);
            faultMessages.add(msg);
        }
    }

    private static PortType addPortType(Definition def, ESBServiceEndpointInfo serviceInfo, Message inMessage, Message outMessage, List<Message> faultMessages) {
        PortType portType = def.createPortType();
        portType.setQName(new QName(def.getTargetNamespace(), serviceInfo.getPortName()));
        Operation op = def.createOperation();
        op.setUndefined(false);
        op.setName(serviceInfo.getOperationName());
        if (inMessage != null) {
            Input in = def.createInput();
            in.setMessage(inMessage);
            in.setName(inMessage.getQName().getLocalPart());
            if (serviceInfo.isAddressing()) {
                in.setExtensionAttribute(WSAW_ACTION_QN, (Object)serviceInfo.getRequestAction());
            }
            op.setInput(in);
        }
        if (outMessage != null) {
            Output out = def.createOutput();
            out.setMessage(outMessage);
            out.setName(outMessage.getQName().getLocalPart());
            if (serviceInfo.isAddressing()) {
                out.setExtensionAttribute(WSAW_ACTION_QN, (Object)serviceInfo.getResponseAction());
            }
            op.setOutput(out);
        }
        int count = 1;
        if (faultMessages != null) {
            for (Message message : faultMessages) {
                Fault fault = def.createFault();
                fault.setMessage(message);
                fault.setName("fault" + count++);
                op.addFault(fault);
            }
        }
        portType.addOperation(op);
        portType.setUndefined(false);
        def.addPortType(portType);
        return portType;
    }

    private static Binding addBinding(Definition def, ESBServiceEndpointInfo serviceInfo, PortType portType) {
        Map faults;
        SOAPBodyImpl soapBody;
        Binding binding = def.createBinding();
        binding.setUndefined(false);
        binding.setPortType(portType);
        binding.setQName(new QName(def.getTargetNamespace(), serviceInfo.getBindingName()));
        SOAPBindingImpl soapBinding = new SOAPBindingImpl();
        soapBinding.setStyle("document");
        soapBinding.setTransportURI("http://schemas.xmlsoap.org/soap/http");
        binding.addExtensibilityElement((ExtensibilityElement)soapBinding);
        if (serviceInfo.isAddressing()) {
            binding.addExtensibilityElement((ExtensibilityElement)new UsingAddressingExtension());
        }
        BindingOperation bop = def.createBindingOperation();
        bop.setName(serviceInfo.getOperationName());
        Operation op = (Operation)portType.getOperations().get(0);
        bop.setOperation(op);
        SOAPOperationImpl soapOperation = new SOAPOperationImpl();
        soapOperation.setSoapActionURI(serviceInfo.getResponseAction());
        bop.addExtensibilityElement((ExtensibilityElement)soapOperation);
        if (op.getInput() != null) {
            BindingInput binput = def.createBindingInput();
            bop.setBindingInput(binput);
            soapBody = new SOAPBodyImpl();
            soapBody.setUse("literal");
            binput.setName(serviceInfo.getRequestName());
            binput.addExtensibilityElement((ExtensibilityElement)soapBody);
        }
        if (op.getOutput() != null) {
            BindingOutput boutput = def.createBindingOutput();
            bop.setBindingOutput(boutput);
            soapBody = new SOAPBodyImpl();
            soapBody.setUse("literal");
            boutput.setName(serviceInfo.getResponseName());
            boutput.addExtensibilityElement((ExtensibilityElement)soapBody);
        }
        if ((faults = op.getFaults()) != null) {
            for (Fault fault : op.getFaults().values()) {
                BindingFault bfault = def.createBindingFault();
                bfault.setName(fault.getName());
                bop.addBindingFault(bfault);
                SOAPFaultImpl soapFault = new SOAPFaultImpl();
                soapFault.setName(fault.getName());
                soapFault.setUse("literal");
                bfault.addExtensibilityElement((ExtensibilityElement)soapFault);
            }
        }
        binding.addBindingOperation(bop);
        def.addBinding(binding);
        return binding;
    }

    private static void addService(Definition def, ESBServiceEndpointInfo serviceInfo, Binding binding) {
        javax.wsdl.Service service = def.createService();
        service.setQName(new QName(def.getTargetNamespace(), serviceInfo.getServiceName()));
        Port port = def.createPort();
        port.setBinding(binding);
        port.setName(serviceInfo.getPortName());
        SOAPAddressImpl soapAddress = new SOAPAddressImpl();
        soapAddress.setLocationURI("http://change_this_URI/" + serviceInfo.getServletPath());
        port.addExtensibilityElement((ExtensibilityElement)soapAddress);
        service.addPort(port);
        def.addService(service);
    }

    private static synchronized WSDLFactory getWSDLFactory() throws ConfigurationException {
        if (wsdlFactory == null) {
            try {
                wsdlFactory = AccessController.doPrivileged(new PrivilegedExceptionAction<WSDLFactory>(){

                    @Override
                    public WSDLFactory run() throws WSDLException {
                        return WSDLFactory.newInstance();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw new ConfigurationException("Failed to instantiate the WSDL factory", pae.getCause());
            }
        }
        return wsdlFactory;
    }

    private static class UsingAddressingSerializer
    implements ExtensionSerializer {
        private UsingAddressingSerializer() {
        }

        public void marshall(Class parentType, QName elementType, ExtensibilityElement extension, PrintWriter pw, Definition definition, ExtensionRegistry registry) throws WSDLException {
            if (extension != null) {
                String prefix = definition.getPrefix(elementType.getNamespaceURI());
                pw.print("    <" + prefix + ":" + elementType.getLocalPart());
                if (extension.getRequired().booleanValue()) {
                    String wsdlPrefix = definition.getPrefix(ESBContractGenerator.WSDL_NAMESPACE);
                    pw.print(" " + wsdlPrefix + ":" + ESBContractGenerator.WSDL_REQUIRED + "=\"true\"");
                }
                pw.println("/>");
            }
        }
    }

    private static class UsingAddressingExtension
    implements ExtensibilityElement {
        private UsingAddressingExtension() {
        }

        public QName getElementType() {
            return WSAW_USING_ADDRESSING_QN;
        }

        public Boolean getRequired() {
            return Boolean.TRUE;
        }

        public void setElementType(QName qname) {
        }

        public void setRequired(Boolean required) {
        }
    }
}

