/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.jca;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.jboss.soa.esb.Configurable;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.jca.ActivationBridge;
import org.jboss.soa.esb.listeners.jca.EndpointContainer;
import org.jboss.soa.esb.listeners.jca.EndpointFactory;
import org.jboss.soa.esb.listeners.jca.JBoss42ActivationBridge;
import org.jboss.soa.esb.listeners.lifecycle.AbstractManagedLifecycle;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseJcaInflow<T>
extends AbstractManagedLifecycle {
    private HashMap<String, String> activationSpec = new HashMap();
    private ClassLoader classLoader;
    private Class<T> inflowInterface;
    private Class<T> beanClass;
    private Class<?> messagingType;
    private ActivationBridge bridge;
    private String adapter;
    private boolean isTransacted = true;
    protected T bean;

    public BaseJcaInflow(ConfigTree config, Class<T> inflowInterface) throws ConfigurationException {
        super(config);
        Class<?> beanClass;
        this.inflowInterface = inflowInterface;
        ConfigTree spec = config.getFirstChild("activation-config");
        for (ConfigTree configProperty : spec.getChildren("property")) {
            String name = configProperty.getAttribute("name");
            String value = configProperty.getAttribute("value");
            this.activationSpec.put(name, value);
        }
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.adapter = config.getAttribute("adapter");
        String bc = config.getAttribute("endpointClass");
        if (bc == null) {
            throw new ConfigurationException("endpointClass attribute is required for Jca Gateway");
        }
        try {
            beanClass = this.classLoader.loadClass(bc);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Unable to load Jca Gateway endpointClass: " + bc, e);
        }
        if (!inflowInterface.isAssignableFrom(beanClass)) {
            throw new ConfigurationException("endpointClass must implement " + inflowInterface.getSimpleName() + " interface");
        }
        this.beanClass = beanClass;
        String mt = config.getAttribute("messagingType");
        if (mt != null) {
            try {
                this.messagingType = this.classLoader.loadClass(mt);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Unable to load Jca Gateway messagingType: " + mt, e);
            }
        } else {
            this.messagingType = this.findMessagingType(beanClass);
        }
        String brdg = config.getAttribute("jcaBridge");
        if (brdg != null) {
            try {
                this.bridge = (ActivationBridge)this.classLoader.loadClass(brdg).newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to load jcaBridge: " + brdg, e);
            }
        } else {
            this.bridge = new JBoss42ActivationBridge();
        }
        String transacted = config.getAttribute("transacted");
        if (transacted != null) {
            this.isTransacted = Boolean.parseBoolean(transacted.trim());
        }
    }

    private Class<?> findMessagingType(Class<?> clazz) throws ConfigurationException {
        if (clazz.equals(Object.class)) {
            return null;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        Class<?> type = null;
        for (Class<?> intf : interfaces) {
            if (intf.equals(this.inflowInterface) || intf.equals(Configurable.class)) continue;
            if (type != null) {
                throw new ConfigurationException("Unable to guess messagingType interface from endpointClass as the base class implements too many interfaces, specify this explicity");
            }
            type = intf;
        }
        if (type == null) {
            return this.findMessagingType(clazz.getSuperclass());
        }
        return type;
    }

    protected abstract String getDescription();

    @Override
    protected void doInitialise() throws ManagedLifecycleException {
        try {
            Constructor<T> beanClassConstructor = this.beanClass.getConstructor(ConfigTree.class);
            try {
                this.bean = beanClassConstructor.newInstance(this.getConfig());
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Unable to create endpoint bean", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to create endpoint bean", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Unable to create endpoint bean", e.getTargetException());
            }
        }
        catch (NoSuchMethodException e) {
            try {
                this.bean = this.beanClass.newInstance();
            }
            catch (Exception e1) {
                throw new RuntimeException("Unable to create endpoint bean", e1);
            }
        }
        if (this.bean instanceof Configurable) {
            try {
                ((Configurable)this.bean).setConfiguration(this.getConfig());
            }
            catch (ConfigurationException ce) {
                throw new RuntimeException("Unable to configure endpoint bean", ce);
            }
        }
        final T theBean = this.bean;
        final String description = this.getDescription();
        EndpointContainer container = new EndpointContainer(){

            public String getDescription() {
                return description + " jca adapter: " + BaseJcaInflow.this.adapter;
            }

            public Object invoke(Method method, Object[] args) throws Throwable {
                try {
                    return method.invoke(theBean, args);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }

            public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
                return BaseJcaInflow.this.isTransacted;
            }
        };
        EndpointFactory mef = new EndpointFactory();
        mef.setContainer(container);
        mef.setLoader(this.classLoader);
        mef.setMessagingType(this.messagingType);
        mef.start();
        this.bridge.setActivationProperties(this.activationSpec);
        this.bridge.setAdapter(this.adapter);
        this.bridge.setMessageEndpointFactory(mef);
        this.bridge.setMessagingTypeClass(this.messagingType);
    }

    @Override
    protected void doStart() {
        this.bridge.activate();
    }

    @Override
    protected void doStop() throws ManagedLifecycleException {
        this.bridge.deactivate();
    }

    @Override
    protected void doDestroy() throws ManagedLifecycleException {
    }

    protected boolean isTransactional() {
        return this.isTransacted;
    }
}

