/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.listeners.jca;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ListenerUtil;
import org.jboss.soa.esb.listeners.jca.BaseJcaInflow;
import org.jboss.soa.esb.listeners.jca.InflowGateway;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcaInflowGateway
extends BaseJcaInflow<InflowGateway> {
    private String serviceName;
    private String serviceCategory;

    public JcaInflowGateway(ConfigTree config) throws ConfigurationException {
        super(config, InflowGateway.class);
        this.serviceCategory = ListenerUtil.getValue(config, "target-service-category", null);
        this.serviceName = ListenerUtil.getValue(config, "target-service-name", null);
        if (this.serviceCategory == null) {
            throw new ConfigurationException("No service category defined!");
        }
        if (this.serviceName == null) {
            throw new ConfigurationException("No service name defined!");
        }
    }

    @Override
    protected String getDescription() {
        return "category: " + this.serviceCategory + " service: " + this.serviceName;
    }

    @Override
    protected void doInitialise() throws ManagedLifecycleException {
        super.doInitialise();
        try {
            ServiceInvoker invoker = new ServiceInvoker(this.serviceCategory, this.serviceName);
            ((InflowGateway)this.bean).setServiceInvoker(invoker);
        }
        catch (MessageDeliverException mde) {
            throw new ManagedLifecycleException("Failed to activate JCA Inflow Gateway. Service '" + this.serviceCategory + ":" + this.serviceName + "'", mde);
        }
    }
}

