/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.notification;

import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.internal.soa.esb.rosetta.pooling.ConnectionException;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPool;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.NamingContextException;
import org.jboss.soa.esb.helpers.NamingContextPool;
import org.jboss.soa.esb.notification.NotifyJMS;

public class NotifyTopics
extends NotifyJMS {
    public static final String CHILD_TOPIC = "topic";

    public NotifyTopics(ConfigTree p_oP) throws ConfigurationException, JMSException, ConnectionException {
        super(p_oP);
        this.setUpProducers(p_oP.getChildren(CHILD_TOPIC));
    }

    protected void send(Message p_oMsg, MessageProducer msgProducer) throws JMSException {
        msgProducer.send(p_oMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageProducer createProducer(JmsConnectionPool pool, String destinationName, Session session, Properties environment) throws NamingException, JMSException, ConnectionException {
        MessageProducer messageProducer;
        Context context = NamingContextPool.getNamingContext(environment);
        try {
            Destination destination = null;
            try {
                destination = (Destination)context.lookup(destinationName);
            }
            catch (NamingException ne) {
                context = NamingContextPool.replaceNamingContext(context, environment);
                try {
                    destination = (Destination)context.lookup(destinationName);
                }
                catch (NamingException nex) {
                    session.createTopic(destinationName);
                }
            }
            messageProducer = session.createProducer(destination);
        }
        catch (Throwable throwable) {
            try {
                NamingContextPool.releaseNamingContext(context);
                throw throwable;
            }
            catch (NamingContextException nce) {
                throw new ConnectionException("Unexpected exception while accessing naming context pool", nce);
            }
        }
        NamingContextPool.releaseNamingContext(context);
        return messageProducer;
    }
}

