/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.security.PasswordUtil;
import org.jboss.soa.esb.services.security.SecurityServiceException;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.services.security.util.CryptoUtil;
import org.jboss.soa.esb.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PublicCryptoUtil {
    INSTANCE;

    private static final Logger logger;
    private Logger log;
    private Key key;
    private PublicKey publicKey;
    private String transformation;
    private boolean isSecurityConfigured;

    private PublicCryptoUtil() {
        try {
            this.log = PublicCryptoUtil.getLogger();
            this.init();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unknown algorithm:", e);
        }
    }

    public byte[] encrypt(Serializable object) throws SecurityServiceException {
        ByteArrayInputStream plainInStream;
        if (!this.isSecurityConfigured) {
            return null;
        }
        try {
            plainInStream = new ByteArrayInputStream(PublicCryptoUtil.getBytes(object));
        }
        catch (IOException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        ByteArrayOutputStream encryptedOutStream = new ByteArrayOutputStream();
        try {
            int bufLength;
            byte[] buf = new byte[100];
            while ((bufLength = plainInStream.read(buf)) != -1) {
                byte[] tmp = CryptoUtil.encrypt(PublicCryptoUtil.copyBytes(buf, bufLength), this.publicKey, this.transformation);
                encryptedOutStream.write(tmp);
                encryptedOutStream.flush();
            }
            return encryptedOutStream.toByteArray();
        }
        catch (IOException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
    }

    public Serializable decrypt(byte[] bytes) throws SecurityServiceException {
        if (!this.isSecurityConfigured) {
            return null;
        }
        ByteArrayInputStream encryptedBytesInStream = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream decryptedBytesOutStream = new ByteArrayOutputStream();
        byte[] decryptBytes = null;
        try {
            int bufLenth;
            byte[] buf = new byte[128];
            while ((bufLenth = encryptedBytesInStream.read(buf)) != -1) {
                byte[] tmp = CryptoUtil.decrypt(PublicCryptoUtil.copyBytes(buf, bufLenth), (PrivateKey)this.key, this.transformation);
                decryptedBytesOutStream.write(tmp);
                decryptedBytesOutStream.flush();
                decryptBytes = decryptedBytesOutStream.toByteArray();
            }
        }
        catch (IOException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        finally {
            try {
                decryptedBytesOutStream.close();
            }
            catch (IOException ignore) {
                this.log.error((Object)ignore.getMessage(), (Throwable)ignore);
            }
        }
        return this.toSerializable(decryptBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws SecurityServiceException {
        String keystorePath = Configuration.getSecurityServicePublicKeystore();
        if (keystorePath == null) {
            this.log.info((Object)"No public keystore was specified in jbossesb-properites.xml. Add 'org.jboss.soa.esb.services.security.publicKeystore'");
        } else {
            this.isSecurityConfigured = true;
            try {
                String keystoreType = Configuration.getSecurityServicePublicKeystoreType();
                if (keystoreType == null) {
                    keystoreType = KeyStore.getDefaultType();
                }
                String keystorePassword = Configuration.getSecurityServicePublicKeystorePassword();
                String privateKeyPass = Configuration.getSecurityServicePublicKeyPassword();
                String privateKeyAlias = Configuration.getSecurityServicePublicKeyAlias();
                keystorePassword = this.getPasswordFromFile(keystorePassword);
                privateKeyPass = this.getPasswordFromFile(privateKeyPass);
                try {
                    KeyStore keystore = KeyStore.getInstance(keystoreType);
                    InputStream in = ClassUtil.getResourceAsStream(keystorePath, ((Object)((Object)this)).getClass());
                    if (in == null) {
                        throw new SecurityServiceException("Could not locate public keystore using '" + keystorePath + "'");
                    }
                    keystore.load(in, keystorePassword.toCharArray());
                    this.key = keystore.getKey(privateKeyAlias, privateKeyPass.toCharArray());
                    Certificate certificate = keystore.getCertificate(privateKeyAlias);
                    this.publicKey = certificate.getPublicKey();
                    this.transformation = Configuration.getSecurityServicePublicKeyTransformation();
                    if (this.transformation == null) {
                        this.transformation = this.key.getAlgorithm();
                    }
                }
                finally {
                    keystorePassword = null;
                    privateKeyAlias = null;
                    privateKeyPass = null;
                }
            }
            catch (KeyStoreException e) {
                throw new SecurityServiceException(e.getMessage(), e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecurityServiceException(e.getMessage(), e);
            }
            catch (CertificateException e) {
                throw new SecurityServiceException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new SecurityServiceException(e.getMessage(), e);
            }
            catch (UnrecoverableKeyException e) {
                throw new SecurityServiceException(e.getMessage(), e);
            }
        }
    }

    private String getPasswordFromFile(String password) {
        if (PasswordUtil.isPasswordFile(password)) {
            try {
                return new PasswordUtil(password).getPasswordAsString();
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        return password;
    }

    private static byte[] getBytes(Serializable ser) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        oout.writeObject(ser);
        return bout.toByteArray();
    }

    private Serializable toSerializable(byte[] decryptBytes) throws SecurityServiceException {
        ObjectInputStream inputStream = null;
        try {
            inputStream = new ObjectInputStream(new ByteArrayInputStream(decryptBytes));
            Serializable serializable = (Serializable)inputStream.readObject();
            return serializable;
        }
        catch (IOException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ignore) {
                this.log.error((Object)ignore.getMessage(), (Throwable)ignore);
            }
        }
    }

    private static byte[] copyBytes(byte[] bytes, int length) {
        if (bytes.length == length) {
            return bytes;
        }
        byte[] newBytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            newBytes[i] = bytes[i];
        }
        return newBytes;
    }

    private static Logger getLogger() {
        return Logger.getLogger(PublicCryptoUtil.class);
    }

    public boolean addAuthRequestToMessage(AuthenticationRequest authRequest, Message message) throws MessageDeliverException {
        if (authRequest != null) {
            try {
                byte[] encrypted = INSTANCE.encrypt((Serializable)((Object)authRequest));
                if (encrypted != null) {
                    message.getContext().setContext("org.jboss.soa.esb.services.security.authRequest", encrypted);
                    return true;
                }
                logger.warn((Object)"No public keystore has been configured which means that the authentication request cannot be encrypted. Please configure jbossesb-properties.xml with a publickey store.");
            }
            catch (SecurityServiceException e) {
                throw new MessageDeliverException(e.getMessage(), e);
            }
        }
        return false;
    }

    public boolean isAuthRequestOnMessage(Message message) {
        return message.getContext().getContext("org.jboss.soa.esb.services.security.authRequest") != null;
    }

    static {
        logger = Logger.getLogger(PublicCryptoUtil.class);
    }
}

