/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workflow.instance.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.process.core.timer.Timer;
import org.drools.process.instance.timer.TimerInstance;
import org.drools.process.instance.timer.TimerManager;
import org.drools.runtime.process.EventListener;
import org.drools.runtime.process.NodeInstance;
import org.drools.spi.KnowledgeHelper;
import org.drools.workflow.core.DroolsAction;
import org.drools.workflow.core.node.EventBasedNode;
import org.drools.workflow.instance.impl.ExtendedNodeInstanceImpl;
import org.drools.workflow.instance.node.EventBasedNodeInstanceInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventBasedNodeInstance
extends ExtendedNodeInstanceImpl
implements EventBasedNodeInstanceInterface,
EventListener {
    private static final long serialVersionUID = 4L;
    private List<Long> timerInstances;

    public EventBasedNode getEventBasedNode() {
        return (EventBasedNode)this.getNode();
    }

    @Override
    public void internalTrigger(NodeInstance from, String type) {
        super.internalTrigger(from, type);
        Map<Timer, DroolsAction> timers = this.getEventBasedNode().getTimers();
        if (timers != null) {
            this.addTimerListener();
            this.timerInstances = new ArrayList<Long>(timers.size());
            TimerManager timerManager = this.getProcessInstance().getWorkingMemory().getTimerManager();
            for (Timer timer : timers.keySet()) {
                TimerInstance timerInstance = this.createTimerInstance(timer);
                timerManager.registerTimer(timerInstance, this.getProcessInstance());
                this.timerInstances.add(timerInstance.getId());
            }
        }
    }

    protected TimerInstance createTimerInstance(Timer timer) {
        TimerInstance timerInstance = new TimerInstance();
        timerInstance.setDelay(timer.getDelay());
        timerInstance.setPeriod(timer.getPeriod());
        timerInstance.setTimerId(timer.getId());
        return timerInstance;
    }

    public void signalEvent(String type, Object event) {
        TimerInstance timerInstance;
        if ("timerTriggered".equals(type) && this.timerInstances.contains((timerInstance = (TimerInstance)event).getId())) {
            this.triggerTimer(timerInstance);
        }
    }

    private void triggerTimer(TimerInstance timerInstance) {
        for (Map.Entry<Timer, DroolsAction> entry : this.getEventBasedNode().getTimers().entrySet()) {
            if (entry.getKey().getId() != timerInstance.getTimerId()) continue;
            KnowledgeHelper knowledgeHelper = this.createKnowledgeHelper();
            this.executeAction(entry.getValue(), knowledgeHelper);
            return;
        }
    }

    public String[] getEventTypes() {
        return new String[]{"timerTriggered"};
    }

    public void triggerCompleted() {
        this.triggerCompleted("DROOLS_DEFAULT", true);
    }

    @Override
    public void addEventListeners() {
        if (this.timerInstances != null && this.timerInstances.size() > 0) {
            this.addTimerListener();
        }
    }

    protected void addTimerListener() {
        this.getProcessInstance().addEventListener("timerTriggered", this, false);
    }

    @Override
    public void removeEventListeners() {
        this.getProcessInstance().removeEventListener("timerTriggered", this, false);
    }

    @Override
    protected void triggerCompleted(String type, boolean remove) {
        this.cancelTimers();
        super.triggerCompleted(type, remove);
    }

    public List<Long> getTimerInstances() {
        return this.timerInstances;
    }

    public void internalSetTimerInstances(List<Long> timerInstances) {
        this.timerInstances = timerInstances;
    }

    @Override
    public void cancel() {
        this.cancelTimers();
        this.removeEventListeners();
        super.cancel();
    }

    private void cancelTimers() {
        if (this.timerInstances != null) {
            TimerManager timerManager = this.getProcessInstance().getWorkingMemory().getTimerManager();
            for (Long id : this.timerInstances) {
                timerManager.cancelTimer(id);
            }
        }
    }
}

