/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.testcase;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class RemoveTestCaseAction
extends AbstractAction {
    private final WsdlTestCase testCase;

    public RemoveTestCaseAction(WsdlTestCase testCase) {
        super("Remove");
        this.testCase = testCase;
        this.putValue("ShortDescription", "Removes this TestCase from the TestSuite");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("DELETE"));
    }

    public void actionPerformed(ActionEvent e) {
        if (SoapUI.getTestMonitor().hasRunningTest(this.testCase)) {
            UISupport.showErrorMessage("Cannot remove RestCase while tests are running");
            return;
        }
        if (UISupport.confirm("Remove TestCase [" + this.testCase.getName() + "] from TestSuite", "Remove TestCase")) {
            this.testCase.getTestSuite().removeTestCase(this.testCase);
        }
    }
}

