/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.ui.desktop.standalone;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.PanelBuilder;
import com.eviware.soapui.model.util.PanelBuilderRegistry;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.support.action.DefaultActionList;
import com.eviware.soapui.ui.desktop.AbstractSoapUIDesktop;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.eviware.soapui.ui.desktop.SoapUIDesktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class StandaloneDesktop
extends AbstractSoapUIDesktop {
    private JDesktopPane desktopPane;
    private Map<ModelItem, JInternalFrame> modelItemToInternalFrameMap = new HashMap<ModelItem, JInternalFrame>();
    private Map<JInternalFrame, DesktopPanel> internalFrameToDesktopPanelMap = new HashMap<JInternalFrame, DesktopPanel>();
    private DesktopPanelPropertyChangeListener desktopPanelPropertyChangeListener = new DesktopPanelPropertyChangeListener();
    private InternalDesktopFrameListener internalFrameListener = new InternalDesktopFrameListener();
    private ActionList actions;
    private DesktopPanel currentPanel;
    private CloseCurrentAction closeCurrentAction = new CloseCurrentAction();
    private CloseOtherAction closeOtherAction = new CloseOtherAction();
    private CloseAllAction closeAllAction = new CloseAllAction();
    private static int openFrameCount = 0;
    private static final int xOffset = 30;
    private static final int yOffset = 30;
    private JPanel desktopPanel = new JPanel(new BorderLayout());
    private boolean transferring;

    public StandaloneDesktop(Workspace workspace) {
        super(workspace);
        this.buildUI();
        this.actions = new DefaultActionList("Desktop");
        this.actions.addAction(this.closeCurrentAction);
        this.actions.addAction(this.closeOtherAction);
        this.actions.addAction(this.closeAllAction);
        this.enableWindowActions();
    }

    private void enableWindowActions() {
        this.closeCurrentAction.setEnabled(this.currentPanel != null && this.internalFrameToDesktopPanelMap.size() > 0);
        this.closeOtherAction.setEnabled(this.currentPanel != null && this.internalFrameToDesktopPanelMap.size() > 1);
        this.closeAllAction.setEnabled(this.internalFrameToDesktopPanelMap.size() > 0);
    }

    private void buildUI() {
        this.desktopPane = new SoapUIDesktopPane();
        JScrollPane scrollPane = new JScrollPane(this.desktopPane);
        this.desktopPanel.add((Component)scrollPane, "Center");
    }

    public JComponent getDesktopComponent() {
        return this.desktopPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeDesktopPanel(DesktopPanel desktopPanel) {
        try {
            if (desktopPanel.getModelItem() != null) {
                boolean bl = this.closeDesktopPanel(desktopPanel.getModelItem());
                return bl;
            }
            JInternalFrame frame = this.getFrameForDesktopPanel(desktopPanel);
            if (frame != null) {
                frame.doDefaultCloseAction();
                boolean bl = frame.isClosed();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.enableWindowActions();
        }
    }

    private JInternalFrame getFrameForDesktopPanel(DesktopPanel desktopPanel) {
        for (JInternalFrame frame : this.internalFrameToDesktopPanelMap.keySet()) {
            if (this.internalFrameToDesktopPanelMap.get(frame) != desktopPanel) continue;
            return frame;
        }
        return null;
    }

    public boolean hasDesktopPanel(ModelItem modelItem) {
        return this.modelItemToInternalFrameMap.containsKey(modelItem);
    }

    public DesktopPanel showDesktopPanel(ModelItem modelItem) {
        PanelBuilder<ModelItem> panelBuilder = PanelBuilderRegistry.getPanelBuilder(modelItem);
        if (this.modelItemToInternalFrameMap.containsKey(modelItem)) {
            JInternalFrame frame = this.modelItemToInternalFrameMap.get(modelItem);
            try {
                this.desktopPane.getDesktopManager().deiconifyFrame(frame);
                frame.setSelected(true);
                frame.moveToFront();
                this.currentPanel = this.internalFrameToDesktopPanelMap.get(frame);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
        } else if (panelBuilder != null && panelBuilder.hasDesktopPanel()) {
            DesktopPanel desktopPanel = panelBuilder.buildDesktopPanel(modelItem);
            if (desktopPanel == null) {
                return null;
            }
            JInternalFrame frame = this.createContentFrame(desktopPanel);
            this.desktopPane.add(frame);
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            this.modelItemToInternalFrameMap.put(modelItem, frame);
            this.internalFrameToDesktopPanelMap.put(frame, desktopPanel);
            this.fireDesktopPanelCreated(desktopPanel);
            this.currentPanel = desktopPanel;
            desktopPanel.getComponent().requestFocusInWindow();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        this.enableWindowActions();
        return this.currentPanel;
    }

    private JInternalFrame createContentFrame(DesktopPanel desktopPanel) {
        desktopPanel.addPropertyChangeListener(this.desktopPanelPropertyChangeListener);
        JComponent panel = desktopPanel.getComponent();
        panel.setOpaque(true);
        String title = desktopPanel.getTitle();
        JInternalFrame frame = new JInternalFrame(title, true, true, true, true);
        frame.addInternalFrameListener(this.internalFrameListener);
        frame.setContentPane(panel);
        frame.setSize(panel.getPreferredSize());
        frame.setVisible(true);
        frame.setFrameIcon(desktopPanel.getIcon());
        frame.setToolTipText(desktopPanel.getDescription());
        frame.setDefaultCloseOperation(0);
        frame.setLocation(30 * (openFrameCount % 10), 30 * (openFrameCount % 10));
        frame.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        ++openFrameCount;
        return frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeDesktopPanel(ModelItem modelItem) {
        try {
            if (this.modelItemToInternalFrameMap.containsKey(modelItem)) {
                JInternalFrame frame = this.modelItemToInternalFrameMap.get(modelItem);
                frame.doDefaultCloseAction();
                boolean bl = frame.isClosed();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.enableWindowActions();
        }
    }

    public ActionList getActions() {
        return this.actions;
    }

    public DesktopPanel[] getDesktopPanels() {
        return this.internalFrameToDesktopPanelMap.values().toArray(new DesktopPanel[this.internalFrameToDesktopPanelMap.size()]);
    }

    public DesktopPanel getDesktopPanel(ModelItem modelItem) {
        return this.internalFrameToDesktopPanelMap.get(modelItem);
    }

    public DesktopPanel showDesktopPanel(DesktopPanel desktopPanel) {
        JInternalFrame frame = this.getFrameForDesktopPanel(desktopPanel);
        if (frame != null) {
            try {
                this.desktopPane.getDesktopManager().deiconifyFrame(frame);
                frame.setSelected(true);
                frame.moveToFront();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            frame = this.createContentFrame(desktopPanel);
            this.desktopPane.add(frame);
            if (desktopPanel.getModelItem() != null) {
                this.modelItemToInternalFrameMap.put(desktopPanel.getModelItem(), frame);
            }
            this.internalFrameToDesktopPanelMap.put(frame, desktopPanel);
            this.fireDesktopPanelCreated(desktopPanel);
            frame.moveToFront();
            desktopPanel.getComponent().requestFocusInWindow();
        }
        this.currentPanel = desktopPanel;
        this.enableWindowActions();
        return desktopPanel;
    }

    public void transferTo(SoapUIDesktop newDesktop) {
        this.transferring = true;
        ArrayList<DesktopPanel> values = new ArrayList<DesktopPanel>(this.internalFrameToDesktopPanelMap.values());
        for (DesktopPanel desktopPanel : values) {
            this.closeDesktopPanel(desktopPanel);
            newDesktop.showDesktopPanel(desktopPanel);
        }
        this.transferring = false;
    }

    class SoapUIDesktopPane
    extends JDesktopPane {
        Image img;
        private int imageWidth;
        private int imageHeight;

        public SoapUIDesktopPane() {
            try {
                File file = new File("soapui-background.gif");
                if (!file.exists()) {
                    file = new File("soapui-background.jpg");
                }
                if (!file.exists()) {
                    file = new File("soapui-background.png");
                }
                if (file.exists()) {
                    this.img = ImageIO.read(file);
                    this.imageWidth = this.img.getWidth(this);
                    this.imageHeight = this.img.getHeight(this);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.img == null) {
                return;
            }
            int x = (this.getWidth() - this.imageWidth) / 2;
            int y = (this.getHeight() - this.imageHeight) / 2;
            g.drawImage(this.img, x, y, this.imageWidth, this.imageHeight, this);
        }
    }

    private class DesktopPanelPropertyChangeListener
    implements PropertyChangeListener {
        private DesktopPanelPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            DesktopPanel desktopPanel = (DesktopPanel)evt.getSource();
            JInternalFrame frame = StandaloneDesktop.this.getFrameForDesktopPanel(desktopPanel);
            if (frame != null) {
                if (evt.getPropertyName().equals(DesktopPanel.TITLE_PROPERTY)) {
                    frame.setTitle(desktopPanel.getTitle());
                } else if (evt.getPropertyName().equals(DesktopPanel.ICON_PROPERTY)) {
                    frame.setFrameIcon(desktopPanel.getIcon());
                }
            }
        }
    }

    public class CloseAllAction
    extends AbstractAction {
        public CloseAllAction() {
            super("Close All");
            this.putValue("ShortDescription", "Closes all windows");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu alt L"));
        }

        public void actionPerformed(ActionEvent e) {
            JInternalFrame[] allFrames;
            while (StandaloneDesktop.this.internalFrameToDesktopPanelMap.size() > 0) {
                Iterator i = StandaloneDesktop.this.internalFrameToDesktopPanelMap.keySet().iterator();
                try {
                    ((JInternalFrame)i.next()).setClosed(true);
                }
                catch (PropertyVetoException e1) {
                    e1.printStackTrace();
                }
            }
            StandaloneDesktop.this.internalFrameToDesktopPanelMap.clear();
            StandaloneDesktop.this.modelItemToInternalFrameMap.clear();
            for (JInternalFrame frame : allFrames = StandaloneDesktop.this.desktopPane.getAllFrames()) {
                frame.doDefaultCloseAction();
            }
            StandaloneDesktop.this.enableWindowActions();
        }
    }

    public class CloseOtherAction
    extends AbstractAction {
        public CloseOtherAction() {
            super("Close Others");
            this.putValue("ShortDescription", "Closes all windows except the current one");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu alt O"));
        }

        public void actionPerformed(ActionEvent e) {
            JInternalFrame frame = StandaloneDesktop.this.desktopPane.getSelectedFrame();
            if (frame == null) {
                return;
            }
            Iterator i = StandaloneDesktop.this.internalFrameToDesktopPanelMap.keySet().iterator();
            while (i.hasNext()) {
                JInternalFrame f = (JInternalFrame)i.next();
                if (f == frame) continue;
                StandaloneDesktop.this.closeDesktopPanel((DesktopPanel)StandaloneDesktop.this.internalFrameToDesktopPanelMap.get(f));
                i = StandaloneDesktop.this.internalFrameToDesktopPanelMap.keySet().iterator();
            }
        }
    }

    public class CloseCurrentAction
    extends AbstractAction {
        public CloseCurrentAction() {
            super("Close Current");
            this.putValue("ShortDescription", "Closes the current window");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu F4"));
        }

        public void actionPerformed(ActionEvent e) {
            JInternalFrame frame = StandaloneDesktop.this.desktopPane.getSelectedFrame();
            if (frame != null) {
                StandaloneDesktop.this.closeDesktopPanel((DesktopPanel)StandaloneDesktop.this.internalFrameToDesktopPanelMap.get(frame));
            }
        }
    }

    private class InternalDesktopFrameListener
    extends InternalFrameAdapter {
        private InternalDesktopFrameListener() {
        }

        public void internalFrameClosing(InternalFrameEvent e) {
            DesktopPanel desktopPanel = (DesktopPanel)StandaloneDesktop.this.internalFrameToDesktopPanelMap.get(e.getInternalFrame());
            if (!StandaloneDesktop.this.transferring && !desktopPanel.onClose(true)) {
                return;
            }
            desktopPanel.removePropertyChangeListener(StandaloneDesktop.this.desktopPanelPropertyChangeListener);
            StandaloneDesktop.this.modelItemToInternalFrameMap.remove(desktopPanel.getModelItem());
            StandaloneDesktop.this.internalFrameToDesktopPanelMap.remove(e.getInternalFrame());
            e.getInternalFrame().dispose();
            if (!StandaloneDesktop.this.transferring) {
                StandaloneDesktop.this.fireDesktopPanelClosed(desktopPanel);
            }
        }

        public void internalFrameActivated(InternalFrameEvent e) {
            StandaloneDesktop.this.currentPanel = (DesktopPanel)StandaloneDesktop.this.internalFrameToDesktopPanelMap.get(e.getInternalFrame());
            if (StandaloneDesktop.this.currentPanel != null) {
                StandaloneDesktop.this.fireDesktopPanelSelected(StandaloneDesktop.this.currentPanel);
            }
            StandaloneDesktop.this.enableWindowActions();
        }

        public void internalFrameDeactivated(InternalFrameEvent e) {
            StandaloneDesktop.this.currentPanel = null;
            StandaloneDesktop.this.enableWindowActions();
        }
    }
}

