/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap;

import com.sun.xml.jaxws.JAXWSMessage;
import com.sun.xml.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType;
import com.sun.xml.messaging.saaj.packaging.mime.internet.ParseException;
import com.sun.xml.messaging.saaj.soap.MessageImpl;
import com.sun.xml.messaging.saaj.soap.ver1_1.ExpressMessage1_1Impl;
import com.sun.xml.messaging.saaj.soap.ver1_1.Message1_1Impl;
import com.sun.xml.messaging.saaj.soap.ver1_2.ExpressMessage1_2Impl;
import com.sun.xml.messaging.saaj.soap.ver1_2.Message1_2Impl;
import com.sun.xml.messaging.saaj.util.TeeInputStream;
import com.sun.xml.ws.spi.runtime.SOAPMessageContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;

public class ExpressMessageFactoryImpl
extends MessageFactory {
    private static boolean debug = false;
    protected static final Logger log = Logger.getLogger("javax.xml.messaging.saaj.soap", "com.sun.xml.messaging.saaj.soap.LocalStrings");
    protected static OutputStream listener;
    private static XMLOutputFactory staxOF;

    public static OutputStream listen(OutputStream newListener) {
        OutputStream oldListener = listener;
        listener = newListener;
        return oldListener;
    }

    public SOAPMessage createMessage() throws SOAPException {
        throw new UnsupportedOperationException();
    }

    public SOAPMessage createMessage(boolean isFastInfoset, boolean acceptFastInfoset) throws SOAPException {
        throw new UnsupportedOperationException();
    }

    public SOAPMessage createMessage(MimeHeaders headers, InputStream in) throws SOAPException, IOException {
        String contentTypeString = MessageImpl.getContentType(headers);
        if (listener != null) {
            in = new TeeInputStream(in, listener);
        }
        try {
            ContentType contentType = new ContentType(contentTypeString);
            int stat = MessageImpl.identifyContentType(contentType);
            if (MessageImpl.isSoap1_1Content(stat)) {
                return new ExpressMessage1_1Impl(headers, in);
            }
            if (MessageImpl.isSoap1_2Content(stat)) {
                return new ExpressMessage1_2Impl(headers, in);
            }
            log.severe("SAAJ0530.soap.unknown.Content-Type");
            throw new SOAPExceptionImpl("Unrecognized Content-Type");
        }
        catch (ParseException e) {
            log.severe("SAAJ0531.soap.cannot.parse.Content-Type");
            throw new SOAPExceptionImpl("Unable to parse content type: " + e.getMessage());
        }
    }

    public static SOAPMessage createMessage(SOAPMessageContext messageContext) throws SOAPException, IOException {
        MimeHeaders headers = ExpressMessageFactoryImpl.getMimeHeader(messageContext);
        return ExpressMessageFactoryImpl.createMessage(headers, messageContext, true);
    }

    public static SOAPMessage createMessage(SOAPMessageContext messageContext, boolean optimized) throws SOAPException, IOException {
        MimeHeaders headers = ExpressMessageFactoryImpl.getMimeHeader(messageContext);
        return ExpressMessageFactoryImpl.createMessage(headers, messageContext, optimized);
    }

    public static SOAPMessage createMessage(MimeHeaders headers, SOAPMessageContext messageContext, boolean optimized) throws SOAPException, IOException {
        JAXWSMessage jxMessage = null;
        try {
            String fiValue = (String)messageContext.get((Object)"com.sun.xml.ws.client.ContentNegotiation");
            if (fiValue != null && fiValue.length() > 0 && "optimistic".equals(fiValue)) {
                SOAPMessage msg = ExpressMessageFactoryImpl.constructSOAPMessage(messageContext);
                if (debug) {
                    System.out.println("CONSTRUCT SOAP");
                }
                return msg;
            }
            if (!optimized) {
                return ExpressMessageFactoryImpl.constructSOAPMessage(messageContext);
            }
            SOAPMessageContext mc = messageContext;
            jxMessage = new JAXWSMessage();
            jxMessage.setEncoder(mc.getEncoder());
            jxMessage.setMessageInfo(mc.getMessageInfo());
            jxMessage.setHeaders(mc.getHeaders());
            jxMessage.setBody(mc.getBody());
            String soapVersion = messageContext.getBindingId();
            String contentTypeString = MessageImpl.getContentType(headers);
            ContentType contentType = new ContentType(contentTypeString);
            int stat = MessageImpl.identifyContentType(contentType);
            MessageImpl sm = null;
            if (soapVersion == "http://schemas.xmlsoap.org/wsdl/soap/http") {
                sm = new ExpressMessage1_1Impl(headers, jxMessage);
                jxMessage.setSoapMessage(sm);
                ExpressMessageFactoryImpl.addAttachments(mc, sm);
            } else if (soapVersion == "http://www.w3.org/2003/05/soap/bindings/HTTP/") {
                sm = new ExpressMessage1_2Impl(headers, jxMessage);
                jxMessage.setSoapMessage(sm);
                ExpressMessageFactoryImpl.addAttachments(mc, sm);
            } else {
                log.severe("SAAJ0530.soap.unknown.Content-Type");
                throw new SOAPExceptionImpl("Unrecognized Content-Type");
            }
            if (fiValue == "optimistic") {
                ((MessageImpl)sm).setIsFastInfoset(true);
            }
            return sm;
        }
        catch (ParseException e) {
            log.severe("SAAJ0531.soap.cannot.parse.Content-Type");
            throw new SOAPExceptionImpl("Unable to parse content type: " + e.getMessage());
        }
        catch (Exception ex) {
            throw new SOAPException(ex);
        }
    }

    private static void addAttachments(SOAPMessageContext msgContext, SOAPMessage sm) {
        Map attachments = (Map)msgContext.get((Object)"javax.xml.ws.binding.attachments.outbound");
        if (attachments != null) {
            Set keys = attachments.keySet();
            for (String cid : keys) {
                DataHandler dh = (DataHandler)attachments.get(cid);
                AttachmentPart attachmentPart = sm.createAttachmentPart();
                attachmentPart.setDataHandler(dh);
                attachmentPart.setContentId(cid);
                attachmentPart.setMimeHeader("Content-transfer-encoding", "binary");
                sm.addAttachmentPart(attachmentPart);
            }
        }
    }

    protected static final String getContentType(MimeHeaders headers) {
        String[] values = headers.getHeader("Content-Type");
        if (values == null) {
            return null;
        }
        return values[0];
    }

    private static SOAPMessage constructSOAPMessage(SOAPMessageContext msgContext) throws SOAPException {
        String soapVersion = "http://schemas.xmlsoap.org/wsdl/soap/http";
        soapVersion = msgContext.getBindingId();
        if (debug) {
            System.out.println("SOAP Version" + soapVersion);
        }
        Object sm = null;
        if (soapVersion == null || soapVersion == "http://schemas.xmlsoap.org/wsdl/soap/http") {
            return JAXWSMessage.constructSOAPMessage(new Message1_1Impl(), msgContext);
        }
        return JAXWSMessage.constructSOAPMessage(new Message1_2Impl(), msgContext);
    }

    private static MimeHeaders getMimeHeader(SOAPMessageContext msgContext) {
        String fiValue = (String)msgContext.get((Object)"com.sun.xml.ws.client.ContentNegotiation");
        String soapVersion = msgContext.getBindingId();
        Object sm = null;
        MimeHeaders mh = new MimeHeaders();
        if (soapVersion == "http://schemas.xmlsoap.org/wsdl/soap/http") {
            if ("optimistic" == fiValue) {
                if (debug) {
                    System.out.println("FI ON");
                }
                mh.addHeader("Content-Type", "application/fastinfoset");
                return mh;
            }
            if (msgContext.isMtomEnabled()) {
                mh.addHeader("Content-Type", "application/xop+xml;type=\"text/xml\"");
                return mh;
            }
            mh.addHeader("Content-Type", "text/xml");
            return mh;
        }
        if ("optimistic" == fiValue) {
            mh.addHeader("Content-Type", "application/soap+fastinfoset");
            return mh;
        }
        if (msgContext.isMtomEnabled()) {
            mh.addHeader("Content-Type", "application/xop+xml;type=\"application/soap+xml\"");
            return mh;
        }
        mh.addHeader("Content-Type", "application/soap+xml");
        return mh;
    }

    static {
        staxOF = null;
    }
}

