/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.policy.sourcemodel.PolicyModelGenerator;
import com.sun.xml.ws.policy.sourcemodel.PolicySourceModel;
import com.sun.xml.ws.policy.sourcemodel.XmlPolicyModelMarshaller;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Claims
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.Claims,
SecurityAssertionValidator {
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private boolean populated = false;
    private byte[] claimsBytes;

    public Claims() {
    }

    public Claims(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
    }

    @Override
    public byte[] getClaimsAsBytes() {
        this.populate();
        return this.claimsBytes;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean b) {
        if (!this.populated) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                XMLOutputFactory xof = XMLOutputFactory.newInstance();
                XMLStreamWriter writer = xof.createXMLStreamWriter(baos);
                AssertionSet set = AssertionSet.createAssertionSet(Arrays.asList(this));
                Policy policy = Policy.createPolicy(Arrays.asList(set));
                PolicySourceModel sourceModel = PolicyModelGenerator.getGenerator().translate(policy);
                XmlPolicyModelMarshaller pm = (XmlPolicyModelMarshaller)XmlPolicyModelMarshaller.getXmlMarshaller(true);
                pm.marshal(sourceModel, (Object)writer);
                this.claimsBytes = baos.toByteArray();
                this.populated = true;
            }
            catch (PolicyException ex) {
                Logger.getLogger(Claims.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(Claims.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.fitness;
    }
}

