/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.server;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.server.Adapter;
import com.sun.xml.ws.api.server.TransportBackChannel;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.DeploymentDescriptorParser;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.server.TCPAdapterList;
import com.sun.xml.ws.transport.tcp.server.TCPConnectionImpl;
import com.sun.xml.ws.transport.tcp.util.ChannelContext;
import com.sun.xml.ws.transport.tcp.util.WSTCPError;
import com.sun.xml.ws.transport.tcp.util.WSTCPException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCPAdapter
extends Adapter<TCPToolkit> {
    private static final Logger logger = Logger.getLogger("com.sun.xml.ws.transport.tcp.server");
    final String name;
    final String urlPattern;
    public static final DeploymentDescriptorParser.AdapterFactory<TCPAdapter> FACTORY = new TCPAdapterList();

    public TCPAdapter(@NotNull String name, @NotNull String urlPattern, @NotNull WSEndpoint endpoint) {
        super(endpoint);
        this.name = name;
        this.urlPattern = urlPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(@NotNull ChannelContext channelContext) throws IOException, WSTCPException {
        TCPConnectionImpl connection = new TCPConnectionImpl(channelContext);
        TCPToolkit tk = (TCPToolkit)this.pool.take();
        try {
            tk.handle(connection);
            connection.flush();
        }
        finally {
            this.pool.recycle(tk);
            connection.close();
        }
    }

    @Override
    protected TCPToolkit createToolkit() {
        return new TCPToolkit();
    }

    public String getValidPath() {
        if (this.urlPattern.endsWith("/*")) {
            return this.urlPattern.substring(0, this.urlPattern.length() - 2);
        }
        return this.urlPattern;
    }

    public static void sendErrorResponse(@NotNull ChannelContext channelContext, WSTCPError message) throws IOException, WSTCPException {
        TCPConnectionImpl connection = new TCPConnectionImpl(channelContext);
        connection.sendErrorMessage(message);
    }

    public class TCPToolkit
    extends Adapter.Toolkit
    implements TransportBackChannel {
        protected TCPConnectionImpl connection;
        private boolean isClosed;

        protected void handle(@NotNull TCPConnectionImpl con) throws IOException, WSTCPException {
            this.connection = con;
            this.isClosed = false;
            InputStream in = this.connection.openInput();
            Codec codec = this.getCodec(this.connection.getChannelContext());
            String ct = this.connection.getContentType();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, MessagesMessages.WSTCP_1090_TCP_ADAPTER_REQ_CONTENT_TYPE(ct));
            }
            Packet packet = new Packet();
            codec.decode(in, ct, packet);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, MessagesMessages.WSTCP_1091_TCP_ADAPTER_DECODED());
            }
            this.addCustomPacketSattellites(packet);
            packet = this.head.process(packet, this.connection, this);
            if (this.isClosed) {
                return;
            }
            ct = codec.getStaticContentType(packet).getContentType();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, MessagesMessages.WSTCP_1092_TCP_ADAPTER_RPL_CONTENT_TYPE(ct));
            }
            if (ct == null) {
                throw new UnsupportedOperationException(MessagesMessages.WSTCP_0021_TCP_ADAPTER_UNSUPPORTER_OPERATION());
            }
            this.connection.setContentType(ct);
            if (packet.getMessage() == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, MessagesMessages.WSTCP_1093_TCP_ADAPTER_ONE_WAY());
                }
                this.connection.setStatus(1);
            } else {
                codec.encode(packet, this.connection.openOutput());
            }
        }

        @NotNull
        protected Codec getCodec(@NotNull ChannelContext context) {
            return context.getCodec();
        }

        public void addCustomPacketSattellites(@NotNull Packet packet) {
        }

        public void close() {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, MessagesMessages.WSTCP_1094_TCP_ADAPTER_CLOSE());
            }
            this.connection.setStatus(1);
            this.isClosed = true;
        }
    }
}

