/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import org.jcp.xml.dsig.internal.SignerOutputStream;
import org.jcp.xml.dsig.internal.dom.DOMSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.w3c.dom.Element;

public final class DOMRSASignatureMethod
extends DOMSignatureMethod {
    private static Logger log = Logger.getLogger("org.jcp.xml.dsig.internal.dom");
    private Signature signature;

    public DOMRSASignatureMethod(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        super("http://www.w3.org/2000/09/xmldsig#rsa-sha1", algorithmParameterSpec);
    }

    public DOMRSASignatureMethod(Element element) throws MarshalException {
        super(element);
    }

    protected void checkParams(SignatureMethodParameterSpec signatureMethodParameterSpec) throws InvalidAlgorithmParameterException {
        if (signatureMethodParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("no parameters should be specified for RSA signature algorithm");
        }
    }

    protected SignatureMethodParameterSpec unmarshalParams(Element element) throws MarshalException {
        throw new MarshalException("no parameters should be specified for RSA signature algorithm");
    }

    protected void marshalParams(Element element, String string2) throws MarshalException {
        throw new MarshalException("no parameters should be specified for RSA signature algorithm");
    }

    protected boolean paramsEqual(AlgorithmParameterSpec algorithmParameterSpec) {
        return this.getParameterSpec() == algorithmParameterSpec;
    }

    public boolean verify(Key key, DOMSignedInfo dOMSignedInfo, byte[] byArray, XMLValidateContext xMLValidateContext) throws InvalidKeyException, SignatureException, XMLSignatureException {
        if (key == null || dOMSignedInfo == null || byArray == null) {
            throw new NullPointerException("key, signed info or signature cannot be null");
        }
        if (!(key instanceof PublicKey)) {
            throw new InvalidKeyException("key must be PublicKey");
        }
        if (this.signature == null) {
            try {
                this.signature = Signature.getInstance("SHA1withRSA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SignatureException("SHA1withRSA Signature not found");
            }
        }
        this.signature.initVerify((PublicKey)key);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Signature provider:" + this.signature.getProvider());
            log.log(Level.FINE, "verifying with key: " + key);
        }
        dOMSignedInfo.canonicalize(xMLValidateContext, new SignerOutputStream(this.signature));
        return this.signature.verify(byArray);
    }

    public byte[] sign(Key key, DOMSignedInfo dOMSignedInfo, XMLSignContext xMLSignContext) throws InvalidKeyException, XMLSignatureException {
        if (key == null || dOMSignedInfo == null) {
            throw new NullPointerException();
        }
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("key must be PrivateKey");
        }
        if (this.signature == null) {
            try {
                this.signature = Signature.getInstance("SHA1withRSA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidKeyException("SHA1withRSA Signature not found");
            }
        }
        this.signature.initSign((PrivateKey)key);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Signature provider:" + this.signature.getProvider());
            log.log(Level.FINE, "Signing with key: " + key);
        }
        dOMSignedInfo.canonicalize(xMLSignContext, new SignerOutputStream(this.signature));
        try {
            return this.signature.sign();
        }
        catch (SignatureException signatureException) {
            throw new RuntimeException(signatureException.getMessage());
        }
    }
}

