/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.util;

import com.iplanet.security.util.BigInt;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import sun.security.util.BitArray;

class DerInputBuffer
extends ByteArrayInputStream
implements Cloneable {
    DerInputBuffer(byte[] buf) {
        super(buf);
    }

    DerInputBuffer(byte[] buf, int offset, int len) {
        super(buf, offset, len);
    }

    DerInputBuffer dup() {
        try {
            DerInputBuffer retval = (DerInputBuffer)this.clone();
            retval.mark(Integer.MAX_VALUE);
            return retval;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    byte[] toByteArray() {
        int len = this.available();
        if (len <= 0) {
            return null;
        }
        byte[] retval = new byte[len];
        System.arraycopy(this.buf, this.pos, retval, 0, len);
        return retval;
    }

    int peek() throws IOException {
        if (this.pos >= this.count) {
            throw new IOException("out of data");
        }
        return this.buf[this.pos];
    }

    public boolean equals(Object other) {
        if (other instanceof DerInputBuffer) {
            return this.equals((DerInputBuffer)other);
        }
        return false;
    }

    boolean equals(DerInputBuffer other) {
        if (this == other) {
            return true;
        }
        int max = this.available();
        if (other.available() != max) {
            return false;
        }
        for (int i = 0; i < max; ++i) {
            if (this.buf[this.pos + i] == other.buf[other.pos + i]) continue;
            return false;
        }
        return true;
    }

    void truncate(int len) throws IOException {
        if (len > this.available()) {
            throw new IOException("insufficient data");
        }
        this.count = this.pos + len;
    }

    BigInt getUnsigned(int len) throws IOException {
        if (len > this.available()) {
            throw new IOException("short read, getInteger");
        }
        if (len > 1 && this.buf[this.pos] == 0) {
            --len;
            this.skip(1L);
        }
        byte[] bytes = new byte[len];
        System.arraycopy(this.buf, this.pos, bytes, 0, len);
        this.skip(len);
        return new BigInt(bytes);
    }

    byte[] getBitString() {
        if (this.pos >= this.count || this.buf[this.pos] != 0) {
            return null;
        }
        int len = this.available();
        byte[] retval = new byte[len - 1];
        System.arraycopy(this.buf, this.pos + 1, retval, 0, len - 1);
        this.pos = this.count;
        return retval;
    }

    BitArray getUnalignedBitString() {
        if (this.pos >= this.count) {
            return null;
        }
        int len = this.available();
        byte[] bits = new byte[len - 1];
        int length = bits.length * 8 - this.buf[this.pos];
        System.arraycopy(this.buf, this.pos + 1, bits, 0, len - 1);
        BitArray bitArray = new BitArray(length, bits);
        this.pos = this.count;
        return bitArray;
    }

    void dump(OutputStream out, int length) throws IOException {
        if (this.count < this.mark + length) {
            throw new IOException("short DER value (encode)");
        }
        out.write(this.buf, this.mark, length);
    }
}

