/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.xmlsig;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.xmlsig.JKSKeyProvider;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml.xmlsig.OfflineResolver;
import com.sun.identity.saml.xmlsig.SignatureProvider;
import com.sun.identity.saml.xmlsig.XMLSignatureException;
import com.sun.identity.shared.encode.Base64;
import com.sun.org.apache.xml.internal.security.Init;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.DSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.RSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.X509CertificateResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.X509IssuerSerialResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.X509SKIResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.X509SubjectNameResolver;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.keys.storage.implementations.KeyStoreResolver;
import com.sun.org.apache.xml.internal.security.signature.XMLSignature;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.utils.Constants;
import com.sun.org.apache.xml.internal.security.utils.IdResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xpath.internal.XPathAPI;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AMSignatureProvider
implements SignatureProvider {
    protected KeyProvider keystore = null;
    private String c14nMethod = null;
    private String transformAlg = null;
    private static final String DEF_ID_ATTRIBUTE = "id";
    private boolean checkCert = true;
    private boolean isJKSKeyStore = false;
    private String wsfVersion = null;
    private String defaultSigAlg = null;

    public AMSignatureProvider() {
        Init.init();
        try {
            String kprovider = SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.keyprovider.class", "com.sun.identity.saml.xmlsig.JKSKeyProvider");
            this.keystore = (KeyProvider)Class.forName(kprovider).newInstance();
            if (this.keystore instanceof JKSKeyProvider) {
                this.isJKSKeyStore = true;
            }
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error("AMSignatureProvider: constructor error");
        }
        this.c14nMethod = SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.c14nMethod", "http://www.w3.org/2001/10/xml-exc-c14n#");
        this.transformAlg = SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.transformAlg", "http://www.w3.org/2001/10/xml-exc-c14n#");
        this.defaultSigAlg = SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.xmlSigAlgorithm");
        try {
            String valCert = SystemConfigurationUtil.getProperty("com.sun.identity.saml.checkcert");
            if (valCert != null) {
                if (valCert.trim().equalsIgnoreCase("off")) {
                    this.checkCert = false;
                } else if (valCert.trim().equalsIgnoreCase("on")) {
                    this.checkCert = true;
                } else {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("SystemConfigurationUtil: com.sun.identity.saml.checkcert has invalid value. Choose default, turn ON checkcert.");
                    }
                    this.checkCert = true;
                }
            }
        }
        catch (Exception e) {
            this.checkCert = true;
        }
    }

    public void initialize(KeyProvider keyProvider) {
        if (keyProvider == null) {
            SAMLUtilsCommon.debug.error("Key Provider is null");
        } else {
            this.keystore = keyProvider;
            if (this.keystore instanceof JKSKeyProvider) {
                this.isJKSKeyStore = true;
            }
        }
    }

    public Element signXML(Document doc, String certAlias) throws XMLSignatureException {
        return this.signXML(doc, certAlias, null);
    }

    public Element signXML(Document doc, String certAlias, String algorithm) throws XMLSignatureException {
        if (doc == null) {
            SAMLUtilsCommon.debug.error("signXML: doc is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (certAlias == null || certAlias.length() == 0) {
            SAMLUtilsCommon.debug.error("signXML: certAlias is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        Element root = null;
        XMLSignature sig = null;
        try {
            Constants.setSignatureSpecNSprefix((String)"");
            if (this.keystore == null) {
                throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullkeystore"));
            }
            PrivateKey privateKey = this.keystore.getPrivateKey(certAlias);
            if (privateKey == null) {
                SAMLUtilsCommon.debug.error("private key is null");
                throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullprivatekey"));
            }
            root = doc.getDocumentElement();
            if (algorithm == null || algorithm.length() == 0) {
                algorithm = this.getKeyAlgorithm(privateKey);
            }
            if (!this.isValidAlgorithm(algorithm)) {
                throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("invalidalgorithm"));
            }
            if (this.c14nMethod == null || this.c14nMethod.length() == 0) {
                sig = new XMLSignature(doc, "", algorithm);
            } else {
                if (!this.isValidCanonicalizationMethod(this.c14nMethod)) {
                    throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("invalidCanonicalizationMethod"));
                }
                sig = new XMLSignature(doc, "", algorithm, this.c14nMethod);
            }
            root.appendChild(sig.getElement());
            sig.getSignedInfo().addResourceResolver(new OfflineResolver());
            Transforms transforms = new Transforms(doc);
            transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            if (this.transformAlg != null && this.transformAlg.length() != 0) {
                if (!this.isValidTransformAlgorithm(this.transformAlg)) {
                    throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("invalidTransformAlgorithm"));
                }
                transforms.addTransform(this.transformAlg);
            }
            sig.addDocument("", transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
            X509Certificate cert = this.keystore.getX509Certificate(certAlias);
            sig.addKeyInfo(cert);
            sig.sign(privateKey);
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error("signXML Exception: ", e);
            throw new XMLSignatureException(e.getMessage());
        }
        return sig.getElement();
    }

    public String signXML(String xmlString, String certAlias) throws XMLSignatureException {
        return this.signXML(xmlString, certAlias, null);
    }

    public String signXML(String xmlString, String certAlias, String algorithm) throws XMLSignatureException {
        if (xmlString == null || xmlString.length() == 0) {
            SAMLUtilsCommon.debug.error("signXML: xmlString is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (certAlias == null || certAlias.length() == 0) {
            SAMLUtilsCommon.debug.error("signXML: certAlias is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        Element el = null;
        try {
            Document doc = com.sun.identity.shared.xml.XMLUtils.toDOMDocument(xmlString, SAMLUtilsCommon.debug);
            el = this.signXML(doc, certAlias, algorithm);
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error("signXML Exception: ", e);
            throw new XMLSignatureException(e.getMessage());
        }
        return com.sun.identity.shared.xml.XMLUtils.print(el);
    }

    public Element signXML(Document doc, String certAlias, String algorithm, String id) throws XMLSignatureException {
        return this.signXML(doc, certAlias, algorithm, DEF_ID_ATTRIBUTE, id, false, null);
    }

    public Element signXML(Document doc, String certAlias, String algorithm, String id, String xpath) throws XMLSignatureException {
        return this.signXML(doc, certAlias, algorithm, DEF_ID_ATTRIBUTE, id, false, xpath);
    }

    public Element signXML(Document doc, String certAlias, String algorithm, String idAttrName, String id, boolean includeCert) throws XMLSignatureException {
        return this.signXML(doc, certAlias, algorithm, idAttrName, id, includeCert, null);
    }

    public String signXML(String xmlString, String certAlias, String algorithm, String idAttrName, String id, boolean includeCert) throws XMLSignatureException {
        if (xmlString == null || xmlString.length() == 0) {
            SAMLUtilsCommon.debug.error("signXML: xmlString is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        Document doc = null;
        try {
            doc = com.sun.identity.shared.xml.XMLUtils.toDOMDocument(xmlString, SAMLUtilsCommon.debug);
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error("signXML Exception: ", e);
            throw new XMLSignatureException(e.getMessage());
        }
        Element el = this.signXML(doc, certAlias, algorithm, idAttrName, id, includeCert, null);
        return com.sun.identity.shared.xml.XMLUtils.print(el);
    }

    public Element signXML(Document doc, String certAlias, String algorithm, String idAttrName, String id, boolean includeCert, String xpath) throws XMLSignatureException {
        if (doc == null) {
            SAMLUtilsCommon.debug.error("signXML: doc is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (certAlias == null || certAlias.length() == 0) {
            SAMLUtilsCommon.debug.error("signXML: certAlias is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        Element root = null;
        XMLSignature sig = null;
        try {
            Constants.setSignatureSpecNSprefix((String)"");
            PrivateKey privateKey = this.keystore.getPrivateKey(certAlias);
            if (privateKey == null) {
                SAMLUtilsCommon.debug.error("private key is null");
                throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullprivatekey"));
            }
            root = (Element)XPathAPI.selectSingleNode(doc, "//*[@" + idAttrName + "=\"" + id + "\"]");
            if (root == null) {
                SAMLUtilsCommon.debug.error("signXML: could not resolv id attribute");
                throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("invalidIDAttribute"));
            }
            if (!id.equals(DEF_ID_ATTRIBUTE)) {
                IdResolver.registerElementById((Element)root, (String)id);
            }
            if (algorithm == null || algorithm.length() == 0) {
                algorithm = this.getKeyAlgorithm(privateKey);
            }
            if (!this.isValidAlgorithm(algorithm)) {
                throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("invalidalgorithm"));
            }
            sig = new XMLSignature(doc, "", algorithm, "http://www.w3.org/2001/10/xml-exc-c14n#");
            if (xpath == null) {
                root.appendChild(sig.getElement());
            } else {
                Node beforeNode = XPathAPI.selectSingleNode(doc, xpath);
                root.insertBefore(sig.getElement(), beforeNode);
            }
            sig.getSignedInfo().addResourceResolver(new OfflineResolver());
            if (!idAttrName.equals(DEF_ID_ATTRIBUTE)) {
                IdResolver.registerElementById((Element)root, (String)id);
            }
            Transforms transforms = new Transforms(doc);
            transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
            String ref = "#" + id;
            sig.addDocument(ref, transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
            if (includeCert) {
                X509Certificate cert = this.keystore.getX509Certificate(certAlias);
                sig.addKeyInfo(cert);
            }
            sig.sign(privateKey);
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error("signXML Exception: ", e);
            throw new XMLSignatureException(e.getMessage());
        }
        return sig.getElement();
    }

    public String signXML(String xmlString, String certAlias, String algorithm, String id) throws XMLSignatureException {
        if (xmlString == null || xmlString.length() == 0) {
            SAMLUtilsCommon.debug.error("signXML: xmlString is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (certAlias == null || certAlias.length() == 0) {
            SAMLUtilsCommon.debug.error("signXML: certAlias is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        Element el = null;
        try {
            Document doc = com.sun.identity.shared.xml.XMLUtils.toDOMDocument(xmlString, SAMLUtilsCommon.debug);
            el = this.signXML(doc, certAlias, algorithm, id);
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error("signXML Exception: ", e);
            throw new XMLSignatureException(e.getMessage());
        }
        return com.sun.identity.shared.xml.XMLUtils.print(el);
    }

    public Element signXML(Document doc, String certAlias, String algorithm, List ids) throws XMLSignatureException {
        return this.signXML(doc, certAlias, algorithm, null, ids);
    }

    public Element signXML(Document doc, String certAlias, String algorithm, String transformAlag, List ids) throws XMLSignatureException {
        if (doc == null) {
            SAMLUtilsCommon.debug.error("signXML: doc is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (certAlias == null || certAlias.length() == 0) {
            SAMLUtilsCommon.debug.error("signXML: certAlias is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        Element root = doc.getDocumentElement();
        XMLSignature signature = null;
        try {
            Constants.setSignatureSpecNSprefix((String)"");
            PrivateKey privateKey = this.keystore.getPrivateKey(certAlias);
            if (privateKey == null) {
                SAMLUtilsCommon.debug.error("private key is null");
                throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullprivatekey"));
            }
            if (algorithm == null || algorithm.length() == 0) {
                algorithm = this.getKeyAlgorithm(privateKey);
            }
            if (!this.isValidAlgorithm(algorithm)) {
                throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("invalidalgorithm"));
            }
            signature = new XMLSignature(doc, "", algorithm, "http://www.w3.org/2001/10/xml-exc-c14n#");
            root.appendChild(signature.getElement());
            int size = ids.size();
            for (int i = 0; i < size; ++i) {
                Transforms transforms = new Transforms(doc);
                if (transformAlag != null) {
                    transforms.addTransform(transformAlag);
                }
                transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                String id = (String)ids.get(i);
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("id = " + id);
                }
                signature.addDocument("#" + id, transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
            }
            X509Certificate cert = this.keystore.getX509Certificate(certAlias);
            signature.addKeyInfo(cert);
            signature.sign(privateKey);
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error("signXML Exception: ", e);
            throw new XMLSignatureException(e.getMessage());
        }
        return signature.getElement();
    }

    public String signXML(String xmlString, String certAlias, String algorithm, List ids) throws XMLSignatureException {
        if (xmlString == null || xmlString.length() == 0) {
            SAMLUtilsCommon.debug.error("signXML: xmlString is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (certAlias == null || certAlias.length() == 0) {
            SAMLUtilsCommon.debug.error("signXML: certAlias is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        Element el = null;
        try {
            Document doc = com.sun.identity.shared.xml.XMLUtils.toDOMDocument(xmlString, SAMLUtilsCommon.debug);
            el = this.signXML(doc, certAlias, algorithm, ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XMLSignatureException(e.getMessage());
        }
        return com.sun.identity.shared.xml.XMLUtils.print(el);
    }

    public Element signWithWSSSAMLTokenProfile(Document doc, Certificate cert, String assertionID, String algorithm, List ids) throws XMLSignatureException {
        return this.signWithWSSSAMLTokenProfile(doc, cert, assertionID, algorithm, ids, "1.0");
    }

    public Element signWithWSSSAMLTokenProfile(Document doc, Certificate cert, String assertionID, String algorithm, List ids, String wsfVersion) throws XMLSignatureException {
        if (doc == null) {
            SAMLUtilsCommon.debug.error("signXML: doc is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (cert == null) {
            SAMLUtilsCommon.debug.error("signWithWSSSAMLTokenProfile: Certificate is null");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (assertionID == null) {
            SAMLUtilsCommon.debug.error("signWithWSSSAMLTokenProfile: AssertionID is null");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        this.wsfVersion = wsfVersion;
        String wsseNS = "http://schemas.xmlsoap.org/ws/2003/06/secext";
        String wsuNS = "http://schemas.xmlsoap.org/ws/2003/06/utility";
        if (wsfVersion != null && wsfVersion.equals("1.1")) {
            wsseNS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
            wsuNS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
        }
        Element root = (Element)doc.getDocumentElement().getElementsByTagNameNS(wsseNS, "Security").item(0);
        XMLSignature signature = null;
        try {
            String certAlias;
            PrivateKey privateKey;
            Constants.setSignatureSpecNSprefix((String)"ds");
            Element wsucontext = XMLUtils.createDSctx((Document)doc, (String)"wsu", (String)wsuNS);
            NodeList wsuNodes = XPathAPI.selectNodeList(doc, "//*[@wsu:Id]", wsucontext);
            if (wsuNodes != null && wsuNodes.getLength() != 0) {
                for (int i = 0; i < wsuNodes.getLength(); ++i) {
                    Element elem = (Element)wsuNodes.item(i);
                    String id = elem.getAttributeNS(wsuNS, "Id");
                    if (id == null || id.length() == 0) continue;
                    IdResolver.registerElementById((Element)elem, (String)id);
                }
            }
            if ((privateKey = this.keystore.getPrivateKey(certAlias = this.keystore.getCertificateAlias(cert))) == null) {
                SAMLUtilsCommon.debug.error("private key is null");
                throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullprivatekey"));
            }
            if (algorithm == null || algorithm.length() == 0) {
                algorithm = this.getKeyAlgorithm(privateKey);
            }
            if (!this.isValidAlgorithm(algorithm)) {
                throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("invalidalgorithm"));
            }
            signature = new XMLSignature(doc, "", algorithm, "http://www.w3.org/2001/10/xml-exc-c14n#");
            root.appendChild(signature.getElement());
            int size = ids.size();
            for (int i = 0; i < size; ++i) {
                Transforms transforms = new Transforms(doc);
                transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                String id = (String)ids.get(i);
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("id = " + id);
                }
                signature.addDocument("#" + id, transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
            }
            KeyInfo keyInfo = signature.getKeyInfo();
            Element securityTokenRef = doc.createElementNS(wsseNS, "SecurityTokenReference");
            keyInfo.addUnknownElement(securityTokenRef);
            securityTokenRef.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", wsseNS);
            securityTokenRef.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:sec", "urn:liberty:sec:2003-08");
            securityTokenRef.setAttributeNS(null, "Usage", "sec:MessageAuthentication");
            Element reference = doc.createElementNS(wsseNS, "Reference");
            reference.setAttributeNS(null, "URI", "#" + assertionID);
            securityTokenRef.appendChild(reference);
            signature.sign(privateKey);
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error("signWithWSSX509TokenProfile Exception: ", e);
            throw new XMLSignatureException(e.getMessage());
        }
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("SAML Signed doc = " + com.sun.identity.shared.xml.XMLUtils.print(doc.getDocumentElement()));
        }
        return signature.getElement();
    }

    public Element signWithWSSX509TokenProfile(Document doc, Certificate cert, String algorithm, List ids) throws XMLSignatureException {
        return this.signWithWSSX509TokenProfile(doc, cert, algorithm, ids, "1.0");
    }

    public Element signWithWSSX509TokenProfile(Document doc, Certificate cert, String algorithm, List ids, String wsfVersion) throws XMLSignatureException {
        if (doc == null) {
            SAMLUtilsCommon.debug.error("signXML: doc is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("Soap Envlope: " + com.sun.identity.shared.xml.XMLUtils.print(doc.getDocumentElement()));
        }
        this.wsfVersion = wsfVersion;
        String wsseNS = "http://schemas.xmlsoap.org/ws/2003/06/secext";
        String wsuNS = "http://schemas.xmlsoap.org/ws/2003/06/utility";
        if (wsfVersion != null && wsfVersion.equals("1.1")) {
            wsseNS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
            wsuNS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
        }
        Element root = (Element)doc.getDocumentElement().getElementsByTagNameNS(wsseNS, "Security").item(0);
        XMLSignature signature = null;
        try {
            String certAlias;
            PrivateKey privateKey;
            Constants.setSignatureSpecNSprefix((String)"ds");
            Element wsucontext = XMLUtils.createDSctx((Document)doc, (String)"wsu", (String)wsuNS);
            NodeList wsuNodes = XPathAPI.selectNodeList(doc, "//*[@wsu:Id]", wsucontext);
            if (wsuNodes != null && wsuNodes.getLength() != 0) {
                for (int i = 0; i < wsuNodes.getLength(); ++i) {
                    Element elem = (Element)wsuNodes.item(i);
                    String id = elem.getAttributeNS(wsuNS, "Id");
                    if (id == null || id.length() == 0) continue;
                    IdResolver.registerElementById((Element)elem, (String)id);
                }
            }
            if ((privateKey = this.keystore.getPrivateKey(certAlias = this.keystore.getCertificateAlias(cert))) == null) {
                SAMLUtilsCommon.debug.error("private key is null");
                throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullprivatekey"));
            }
            if (algorithm == null || algorithm.length() == 0) {
                algorithm = this.getKeyAlgorithm(privateKey);
            }
            if (!this.isValidAlgorithm(algorithm)) {
                throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("invalidalgorithm"));
            }
            signature = new XMLSignature(doc, "", algorithm, "http://www.w3.org/2001/10/xml-exc-c14n#");
            root.appendChild(signature.getElement());
            int size = ids.size();
            for (int i = 0; i < size; ++i) {
                Transforms transforms = new Transforms(doc);
                transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                String id = (String)ids.get(i);
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("id = " + id);
                }
                signature.addDocument("#" + id, transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
            }
            KeyInfo keyInfo = signature.getKeyInfo();
            Element securityTokenRef = doc.createElementNS(wsseNS, "SecurityTokenReference");
            keyInfo.addUnknownElement(securityTokenRef);
            securityTokenRef.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", wsseNS);
            securityTokenRef.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:sec", "urn:liberty:sec:2003-08");
            securityTokenRef.setAttributeNS(null, "Usage", "sec:MessageAuthentication");
            Element bsf = (Element)root.getElementsByTagNameNS(wsseNS, "BinarySecurityToken").item(0);
            String certId = bsf.getAttributeNS(wsuNS, "Id");
            Element reference = doc.createElementNS(wsseNS, "Reference");
            securityTokenRef.appendChild(reference);
            reference.setAttributeNS(null, "URI", "#" + certId);
            signature.sign(privateKey);
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error("signWithWSSX509TokenProfile Exception: ", e);
            throw new XMLSignatureException(e.getMessage());
        }
        return signature.getElement();
    }

    public boolean verifyXMLSignature(Document doc, String certAlias) throws XMLSignatureException {
        return this.verifyXMLSignature("1.0", certAlias, doc);
    }

    public boolean verifyXMLSignature(String wsfVersion, String certAlias, Document doc) throws XMLSignatureException {
        if (doc == null) {
            SAMLUtilsCommon.debug.error("verifyXMLSignature: document is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        try {
            Element wsucontext;
            NodeList wsuNodes;
            this.wsfVersion = wsfVersion;
            String wsuNS = "http://schemas.xmlsoap.org/ws/2003/06/utility";
            String wsseNS = "http://schemas.xmlsoap.org/ws/2003/06/secext";
            if (wsfVersion != null && wsfVersion.equals("1.1")) {
                wsuNS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
                wsseNS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
            }
            if ((wsuNodes = XPathAPI.selectNodeList(doc, "//*[@wsu:Id]", wsucontext = XMLUtils.createDSctx((Document)doc, (String)"wsu", (String)wsuNS))) != null && wsuNodes.getLength() != 0) {
                for (int i = 0; i < wsuNodes.getLength(); ++i) {
                    Element elem = (Element)wsuNodes.item(i);
                    String id = elem.getAttributeNS(wsuNS, "Id");
                    if (id == null || id.length() == 0) continue;
                    IdResolver.registerElementById((Element)elem, (String)id);
                }
            }
            String[] attrs = new String[]{"AssertionID", "RequestID", "ResponseID"};
            for (int j = 0; j < attrs.length; ++j) {
                NodeList aList = XPathAPI.selectNodeList(doc, "//*[@" + attrs[j] + "]");
                if (aList == null || aList.getLength() == 0) continue;
                int len = aList.getLength();
                for (int i = 0; i < len; ++i) {
                    Element elem = (Element)aList.item(i);
                    String id = elem.getAttribute(attrs[j]);
                    if (id == null || id.length() == 0) continue;
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("found " + attrs[j] + "=" + id + " elment=" + com.sun.identity.shared.xml.XMLUtils.print(elem));
                    }
                    IdResolver.registerElementById((Element)elem, (String)id);
                }
            }
            Element nscontext = XMLUtils.createDSctx((Document)doc, (String)"ds", (String)"http://www.w3.org/2000/09/xmldsig#");
            NodeList sigElements = XPathAPI.selectNodeList(doc, "//ds:Signature", nscontext);
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("verifyXMLSignature: sigElements size = " + sigElements.getLength());
            }
            X509Certificate newcert = this.keystore.getX509Certificate(certAlias);
            PublicKey key = this.keystore.getPublicKey(certAlias);
            Element sigElement = null;
            for (int i = 0; i < sigElements.getLength(); ++i) {
                sigElement = (Element)sigElements.item(i);
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Sig(" + i + ") = " + com.sun.identity.shared.xml.XMLUtils.print(sigElement));
                }
                XMLSignature signature = new XMLSignature(sigElement, "");
                signature.addResourceResolver(new OfflineResolver());
                KeyInfo ki = signature.getKeyInfo();
                PublicKey pk = this.getX509PublicKey(doc, ki);
                if (pk != null) {
                    if (signature.checkSignatureValue(pk)) {
                        if (!SAMLUtilsCommon.debug.messageEnabled()) continue;
                        SAMLUtilsCommon.debug.message("verifyXMLSignature: Signature " + i + " verified");
                        continue;
                    }
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("verifyXMLSignature: Signature Verfication failed");
                    }
                    return false;
                }
                if (certAlias == null || certAlias.equals("")) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("verifyXMLSignature:Certificate Alias is null");
                    }
                    return false;
                }
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Could not find a KeyInfo, try to use certAlias");
                }
                if (newcert != null) {
                    if (signature.checkSignatureValue(newcert)) {
                        if (!SAMLUtilsCommon.debug.messageEnabled()) continue;
                        SAMLUtilsCommon.debug.message("verifyXMLSignature: Signature " + i + " verified");
                        continue;
                    }
                    return false;
                }
                if (key != null) {
                    if (signature.checkSignatureValue(key)) {
                        if (!SAMLUtilsCommon.debug.messageEnabled()) continue;
                        SAMLUtilsCommon.debug.message("verifyXMLSignature: Signature " + i + " verified");
                        continue;
                    }
                    return false;
                }
                SAMLUtilsCommon.debug.error("Could not find public key based on certAlias to verify signature");
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            SAMLUtilsCommon.debug.error("verifyXMLSignature Exception: ", ex);
            throw new XMLSignatureException(ex.getMessage());
        }
    }

    public boolean verifyXMLSignature(Document doc) throws XMLSignatureException {
        if (doc == null) {
            SAMLUtilsCommon.debug.error("verifyXMLSignature: document is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        return this.verifyXMLSignature(doc, (String)null);
    }

    public boolean verifyXMLSignature(Element element) throws XMLSignatureException {
        if (element == null) {
            SAMLUtilsCommon.debug.error("signXML: element is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        return this.verifyXMLSignature(com.sun.identity.shared.xml.XMLUtils.print(element));
    }

    public boolean verifyXMLSignature(Element element, String certAlias) throws XMLSignatureException {
        return this.verifyXMLSignature(element, DEF_ID_ATTRIBUTE, certAlias);
    }

    public boolean verifyXMLSignature(Element element, String idAttrName, String certAlias) throws XMLSignatureException {
        if (element == null) {
            SAMLUtilsCommon.debug.error("signXML: element is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        Document doc = null;
        try {
            doc = com.sun.identity.shared.xml.XMLUtils.newDocument();
            doc.appendChild(doc.importNode(element, true));
        }
        catch (Exception ex) {
            SAMLUtilsCommon.debug.error("verifyXMLSignature Exception: ", ex);
            throw new XMLSignatureException(ex.getMessage());
        }
        return this.verifyXMLSignature(doc, idAttrName, certAlias);
    }

    public boolean verifyXMLSignature(Document doc, Certificate cert) throws XMLSignatureException {
        if (doc == null) {
            SAMLUtilsCommon.debug.error("verifyXMLSignature: document is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        String certAlias = this.keystore.getCertificateAlias(cert);
        return this.verifyXMLSignature(doc, certAlias);
    }

    public boolean verifyXMLSignature(String xmlString) throws XMLSignatureException {
        return this.verifyXMLSignature(xmlString, null);
    }

    public boolean verifyXMLSignature(String xmlString, String certAlias) throws XMLSignatureException {
        return this.verifyXMLSignature(xmlString, DEF_ID_ATTRIBUTE, certAlias);
    }

    public boolean verifyXMLSignature(String xmlString, String idAttrName, String certAlias) throws XMLSignatureException {
        if (xmlString == null || xmlString.length() == 0) {
            SAMLUtilsCommon.debug.error("signXML: xmlString is null.");
            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        Document doc = com.sun.identity.shared.xml.XMLUtils.toDOMDocument(xmlString, SAMLUtilsCommon.debug);
        try {
            return this.verifyXMLSignature(doc, idAttrName, certAlias);
        }
        catch (Exception ex) {
            SAMLUtilsCommon.debug.error("verifyXMLSignature Exception: ", ex);
            throw new XMLSignatureException(ex.getMessage());
        }
    }

    public boolean verifyXMLSignature(Document doc, String idAttrName, String certAlias) throws XMLSignatureException {
        try {
            X509Certificate newcert;
            Element nscontext = XMLUtils.createDSctx((Document)doc, (String)"ds", (String)"http://www.w3.org/2000/09/xmldsig#");
            Element sigElement = (Element)XPathAPI.selectSingleNode(doc, "//ds:Signature[1]", nscontext);
            XMLSignature signature = new XMLSignature(sigElement, "");
            signature.addResourceResolver(new OfflineResolver());
            String idValue = doc.getDocumentElement().getAttribute(idAttrName);
            Element root = (Element)XPathAPI.selectSingleNode(doc, "//*[@" + idAttrName + "=\"" + idValue + "\"]");
            if (root == null) {
                SAMLUtilsCommon.debug.error("verifyXML: could not resolv id attribute");
                throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("invalidIDAttribute"));
            }
            String[] attrs = new String[]{"AssertionID", "RequestID", "ResponseID"};
            for (int j = 0; j < attrs.length; ++j) {
                NodeList aList = XPathAPI.selectNodeList(doc, "//*[@" + attrs[j] + "]");
                if (aList == null || aList.getLength() == 0) continue;
                int len = aList.getLength();
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("found " + attrs[j] + "=" + len);
                }
                for (int i = 0; i < len; ++i) {
                    Element elem = (Element)aList.item(i);
                    String id = elem.getAttribute(attrs[j]);
                    if (id == null || id.length() == 0) continue;
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("found " + attrs[j] + "=" + id + " elment=" + com.sun.identity.shared.xml.XMLUtils.print(elem));
                    }
                    IdResolver.registerElementById((Element)elem, (String)id);
                }
            }
            KeyInfo ki = signature.getKeyInfo();
            PublicKey pk = this.getX509PublicKey(doc, ki);
            if (pk != null) {
                return signature.checkSignatureValue(pk);
            }
            if (certAlias == null || certAlias.length() == 0) {
                return false;
            }
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Could not find a KeyInfo, try to use certAlias");
            }
            if ((newcert = this.keystore.getX509Certificate(certAlias)) != null) {
                return signature.checkSignatureValue(newcert);
            }
            PublicKey key = this.keystore.getPublicKey(certAlias);
            if (key != null) {
                return signature.checkSignatureValue(key);
            }
            SAMLUtilsCommon.debug.error("Could not find public key based on certAlias to verify signature");
            return false;
        }
        catch (Exception ex) {
            SAMLUtilsCommon.debug.error("verifyXMLSignature Exception: ", ex);
            throw new XMLSignatureException(ex.getMessage());
        }
    }

    public KeyProvider getKeyProvider() {
        return this.keystore;
    }

    protected PublicKey getX509PublicKey(Document doc, KeyInfo keyinfo) {
        PublicKey pk = null;
        try {
            if (keyinfo != null) {
                if (this.isJKSKeyStore) {
                    StorageResolver storageResolver = new StorageResolver(new KeyStoreResolver(((JKSKeyProvider)this.keystore).getKeyStore()));
                    keyinfo.addStorageResolver(storageResolver);
                    keyinfo.registerInternalKeyResolver(new X509IssuerSerialResolver());
                    keyinfo.registerInternalKeyResolver(new X509CertificateResolver());
                    keyinfo.registerInternalKeyResolver(new X509SKIResolver());
                    keyinfo.registerInternalKeyResolver(new X509SubjectNameResolver());
                }
                if (keyinfo.containsX509Data()) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Found X509Data element in the KeyInfo");
                    }
                    X509Certificate certificate = keyinfo.getX509Certificate();
                    if (this.checkCert) {
                        if (this.keystore.getCertificateAlias(certificate) == null) {
                            SAMLUtilsCommon.debug.error("verifyXMLSignature: certificate is not trusted.");
                            throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("untrustedCertificate"));
                        }
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("verifyXMLSignature: certificate is trused.");
                        }
                    } else if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Skip checking whether the cert in the cert db.");
                    }
                    pk = this.getPublicKey(certificate);
                } else {
                    pk = this.getWSSTokenProfilePublicKey(doc);
                }
            }
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error("getX509Certificate(KeyInfo) Exception: ", e);
        }
        return pk;
    }

    private PublicKey getWSSTokenProfilePublicKey(Document doc) {
        PublicKey pubKey = null;
        try {
            SAMLUtilsCommon.debug.message("getWSSTTokenProfilePublicKey: entering");
            String wsseNS = "http://schemas.xmlsoap.org/ws/2003/06/secext";
            String wsuNS = "http://schemas.xmlsoap.org/ws/2003/06/utility";
            if (this.wsfVersion != null && this.wsfVersion.equals("1.1")) {
                wsseNS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
                wsuNS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
            }
            Element securityElement = (Element)doc.getDocumentElement().getElementsByTagNameNS(wsseNS, "Security").item(0);
            Element nscontext = XMLUtils.createDSctx((Document)doc, (String)"ds", (String)"http://www.w3.org/2000/09/xmldsig#");
            Element sigElement = (Element)XPathAPI.selectSingleNode(securityElement, "ds:Signature[1]", nscontext);
            Element keyinfo = (Element)sigElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo").item(0);
            Element str = (Element)keyinfo.getElementsByTagNameNS(wsseNS, "SecurityTokenReference").item(0);
            Element reference = (Element)keyinfo.getElementsByTagNameNS(wsseNS, "Reference").item(0);
            if (reference != null) {
                String id = reference.getAttribute("URI");
                id = id.substring(1);
                nscontext = XMLUtils.createDSctx((Document)doc, (String)"wsu", (String)wsuNS);
                Node n = XPathAPI.selectSingleNode(doc, "//*[@wsu:Id=\"" + id + "\"]", nscontext);
                if (n != null) {
                    SAMLUtilsCommon.debug.message("X509 Token");
                    String format = ((Element)n).getAttribute("ValueType");
                    NodeList children = n.getChildNodes();
                    n = children.item(0);
                    String certString = n.getNodeValue().trim();
                    pubKey = this.getPublicKey(this.getCertificate(certString, format));
                } else {
                    SAMLUtilsCommon.debug.message("SAML Token");
                    reference = (Element)XPathAPI.selectSingleNode(doc, "//*[@AssertionID=\"" + id + "\"]");
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("SAML Assertion = " + com.sun.identity.shared.xml.XMLUtils.print(reference));
                    }
                    if ((reference = (Element)reference.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo").item(0)) == null) {
                        SAMLUtilsCommon.debug.message("getWSSTokenProfilePublicKey: no KeyInfo found!");
                        throw new Exception(SAMLUtilsCommon.bundle.getString("nullKeyInfo"));
                    }
                    Element x509Data = (Element)reference.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Data").item(0);
                    if (x509Data != null) {
                        reference = (Element)x509Data.getChildNodes().item(0);
                        String certString = x509Data.getChildNodes().item(0).getChildNodes().item(0).getNodeValue();
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("certString = " + certString);
                        }
                        return this.getPublicKey(this.getCertificate(certString, null));
                    }
                    pubKey = this.getPublicKeybyDSARSAkeyValue(doc, reference);
                }
            } else {
                SAMLUtilsCommon.debug.error("getWSSTokenProfilePublicKey: unknow Security Token Reference");
            }
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error("getWSSTokenProfilePublicKey Exception: ", e);
        }
        return pubKey;
    }

    protected PublicKey getPublicKeybyDSARSAkeyValue(Document doc, Element reference) throws XMLSignatureException {
        PublicKey pubKey = null;
        Element dsaKey = (Element)reference.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DSAKeyValue").item(0);
        if (dsaKey != null) {
            NodeList nodes = dsaKey.getChildNodes();
            int nodeCount = nodes.getLength();
            if (nodeCount > 0) {
                BigInteger p = null;
                BigInteger q = null;
                BigInteger g = null;
                BigInteger y = null;
                for (int i = 0; i < nodeCount; ++i) {
                    Node currentNode = nodes.item(i);
                    if (currentNode.getNodeType() != 1) continue;
                    String tagName = currentNode.getLocalName();
                    Node sub = currentNode.getChildNodes().item(0);
                    String value = sub.getNodeValue();
                    BigInteger v = new BigInteger(Base64.decode(SAMLUtilsCommon.removeNewLineChars(value)));
                    if (tagName.equals("P")) {
                        p = v;
                        continue;
                    }
                    if (tagName.equals("Q")) {
                        q = v;
                        continue;
                    }
                    if (tagName.equals("G")) {
                        g = v;
                        continue;
                    }
                    if (tagName.equals("Y")) {
                        y = v;
                        continue;
                    }
                    throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("errorObtainPK"));
                }
                DSAKeyValue dsaKeyValue = new DSAKeyValue(doc, p, q, g, y);
                try {
                    pubKey = dsaKeyValue.getPublicKey();
                }
                catch (Exception e) {
                    throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("errorObtainPK"));
                }
            }
        } else {
            Element rsaKey = (Element)reference.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "RSAKeyValue").item(0);
            if (rsaKey != null) {
                NodeList nodes = rsaKey.getChildNodes();
                int nodeCount = nodes.getLength();
                BigInteger m = null;
                BigInteger e = null;
                if (nodeCount > 0) {
                    for (int i = 0; i < nodeCount; ++i) {
                        Node currentNode = nodes.item(i);
                        if (currentNode.getNodeType() != 1) continue;
                        String tagName = currentNode.getLocalName();
                        Node sub = currentNode.getChildNodes().item(0);
                        String value = sub.getNodeValue();
                        BigInteger v = new BigInteger(Base64.decode(SAMLUtilsCommon.removeNewLineChars(value)));
                        if (tagName.equals("Exponent")) {
                            e = v;
                            continue;
                        }
                        if (tagName.equals("Modulus")) {
                            m = v;
                            continue;
                        }
                        throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("errorObtainPK"));
                    }
                }
                RSAKeyValue rsaKeyValue = new RSAKeyValue(doc, m, e);
                try {
                    pubKey = rsaKeyValue.getPublicKey();
                }
                catch (Exception ex) {
                    throw new XMLSignatureException(SAMLUtilsCommon.bundle.getString("errorObtainPK"));
                }
            }
        }
        return pubKey;
    }

    protected X509Certificate getCertificate(String certString, String format) {
        X509Certificate cert = null;
        try {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("getCertificate(Assertion) : " + certString);
            }
            StringBuffer xml = new StringBuffer(100);
            xml.append("-----BEGIN CERTIFICATE-----\n");
            xml.append(certString);
            xml.append("\n-----END CERTIFICATE-----");
            byte[] barr = null;
            barr = xml.toString().getBytes();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(barr);
            if (format != null && format.equals("wsse:PKCS7")) {
                Collection<? extends Certificate> c = cf.generateCertificates(bais);
                Iterator<? extends Certificate> i = c.iterator();
                while (i.hasNext()) {
                    cert = (X509Certificate)i.next();
                }
            } else {
                while (bais.available() > 0) {
                    cert = (X509Certificate)cf.generateCertificate(bais);
                }
            }
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error("getCertificate Exception: ", e);
        }
        return cert;
    }

    protected PublicKey getPublicKey(X509Certificate cert) {
        PublicKey pk = null;
        if (cert != null) {
            pk = cert.getPublicKey();
        }
        return pk;
    }

    protected boolean isValidAlgorithm(String algorithm) {
        return algorithm.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1") || algorithm.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1") || algorithm.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1") || algorithm.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1") || algorithm.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-md5") || algorithm.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160") || algorithm.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256") || algorithm.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384") || algorithm.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512") || algorithm.equals("http://www.w3.org/2001/04/xmldsig-more#hmac-md5") || algorithm.equals("http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160") || algorithm.equals("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256") || algorithm.equals("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384") || algorithm.equals("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512");
    }

    private boolean isValidCanonicalizationMethod(String algorithm) {
        return algorithm.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || algorithm.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments") || algorithm.equals("http://www.w3.org/2001/10/xml-exc-c14n#") || algorithm.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
    }

    private boolean isValidTransformAlgorithm(String algorithm) {
        return algorithm.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || algorithm.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments") || algorithm.equals("http://www.w3.org/2001/10/xml-exc-c14n#") || algorithm.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments") || algorithm.equals("http://www.w3.org/TR/1999/REC-xslt-19991116") || algorithm.equals("http://www.w3.org/2000/09/xmldsig#base64") || algorithm.equals("http://www.w3.org/TR/1999/REC-xpath-19991116") || algorithm.equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature") || algorithm.equals("http://www.w3.org/TR/2001/WD-xptr-20010108") || algorithm.equals("http://www.w3.org/2002/04/xmldsig-filter2") || algorithm.equals("http://www.w3.org/2002/06/xmldsig-filter2") || algorithm.equals("http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/#xpathFilter");
    }

    private String getKeyAlgorithm(PrivateKey pk) {
        if (this.defaultSigAlg != null && !this.defaultSigAlg.equals("")) {
            return this.defaultSigAlg;
        }
        if (pk.getAlgorithm().equalsIgnoreCase("DSA")) {
            return "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        }
        return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    }

    public Element signWithSAMLToken(Document doc, Certificate cert, String assertionID, String algorithm, List ids) throws XMLSignatureException {
        return null;
    }

    public Element signWithUserNameToken(Document doc, Certificate cert, String algorithm, List ids) throws XMLSignatureException {
        return null;
    }

    public Element signWithBinarySecurityToken(Document doc, Certificate cert, String algorithm, List ids) throws XMLSignatureException {
        return null;
    }

    public boolean verifyWSSSignature(Document document, String certAlias) throws XMLSignatureException {
        return false;
    }

    protected String getAlgorithmURI(String algorithm) {
        if (algorithm == null) {
            return null;
        }
        if (algorithm.equals("RSA")) {
            return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        }
        if (algorithm.equals("DSA")) {
            return "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        }
        return null;
    }
}

