/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.IDPEntry;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IDPEntryImpl
implements IDPEntry {
    private static final String PROVIDERID = "ProviderID";
    private static final String NAME = "Name";
    static final String LOC = "Loc";
    private String providerID;
    private String name;
    private String locationURI;
    private boolean isMutable = false;

    public IDPEntryImpl() {
        this.isMutable = true;
    }

    public IDPEntryImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
    }

    public IDPEntryImpl(String xmlString) throws SAML2Exception {
        Document xmlDocument = XMLUtils.toDOMDocument(xmlString, SAML2SDKUtils.debug);
        if (xmlDocument == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(xmlDocument.getDocumentElement());
    }

    public String getProviderID() {
        return this.providerID;
    }

    public void setProviderID(String uri) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.providerID = uri;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.name = name;
    }

    public String getLoc() {
        return this.locationURI;
    }

    public void setLoc(String locationURI) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.locationURI = locationURI;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        this.validate(this.providerID);
        StringBuffer xmlString = new StringBuffer(100);
        xmlString.append("<");
        if (includeNSPrefix) {
            xmlString.append("samlp:");
        }
        xmlString.append("IDPEntry");
        if (declareNS) {
            xmlString.append(" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"");
        }
        xmlString.append(" ").append(PROVIDERID).append("=").append("\"").append(this.providerID).append("\"");
        if (this.name != null && this.name.length() > 0) {
            xmlString.append(" ").append(NAME).append("=").append("\"").append(this.name).append("\"");
        }
        if (this.locationURI != null && this.locationURI.length() > 0) {
            xmlString.append(" ").append(LOC).append("=").append("\"").append(this.locationURI).append("\"");
        }
        xmlString.append(">").append("\n").append("</samlp:").append("IDPEntry").append(">");
        return xmlString.toString();
    }

    public void makeImmutable() {
        if (this.isMutable) {
            this.isMutable = false;
        }
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    private void parseElement(Element element) throws SAML2Exception {
        this.providerID = element.getAttribute(PROVIDERID);
        this.validate(this.providerID);
        this.name = element.getAttribute(NAME);
        this.locationURI = element.getAttribute(LOC);
    }

    void validate(String providerID) throws SAML2Exception {
        if (providerID == null || providerID.length() == 0) {
            SAML2SDKUtils.debug.message("ProviderID is required");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("providerIDMissing"));
        }
    }
}

