/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SMSUtils {
    protected static final String SERVICE = "Service";
    protected static final String NAME = "name";
    protected static final String VERSION = "version";
    protected static final String SCHEMA = "Schema";
    protected static final String SUB_SCHEMA = "SubSchema";
    protected static final String SUB_CONFIG = "SubConfiguration";
    protected static final String GLOBAL_SCHEMA = "Global";
    protected static final String GLOBAL_CONFIG = "GlobalConfiguration";
    protected static final String ORG_SCHEMA = "Organization";
    protected static final String ORG_ATTRIBUTE_SCHEMA = "OrganizationAttributeSchema";
    protected static final String ORG_ATTRIBUTE_VALUE_PAIR = "OrganizationAttributeValuePair";
    protected static final String ORG_CONFIG = "OrganizationConfiguration";
    protected static final String DYNAMIC_SCHEMA = "Dynamic";
    protected static final String USER_SCHEMA = "User";
    protected static final String POLICY_SCHEMA = "Policy";
    protected static final String GROUP_SCHEMA = "Group";
    protected static final String DOMAIN_SCHEMA = "Domain";
    protected static final String GENERIC_SCHEMA = "Generic";
    protected static final String CONFIGURATION = "Configuration";
    protected static final String INSTANCE = "Instance";
    protected static final String GROUP = "group";
    protected static final String URI = "uri";
    protected static final String SERVICE_ID = "id";
    protected static final String PRIORITY = "priority";
    protected static final String COSPRIORITY = "cospriority";
    protected static final String DEFAULT = "default";
    protected static final String RESOURCE_BUNDLE_URL = "i18nJarURL";
    protected static final String PROPERTIES_FILENAME = "i18nFileName";
    protected static final String SERVICE_HIERARCHY = "serviceHierarchy";
    protected static final String PROPERTIES_VIEW_BEAN_URL = "propertiesViewBeanURL";
    protected static final String I18N_KEY = "i18nKey";
    protected static final String REVISION_NUMBER = "revisionNumber";
    protected static final String STATUS_ATTRIBUTE = "statusAttribute";
    protected static final String VALIDATE = "validate";
    protected static final String INHERITANCE = "inheritance";
    protected static final String ISSEARCHABLE = "isSearchable";
    protected static final String PLUGIN_INTERFACE = "PluginInterface";
    protected static final String PLUGIN_INTERFACE_CLASS = "interface";
    protected static final String PLUGIN_SCHEMA = "PluginSchema";
    protected static final String PLUGIN_SCHEMA_INT_NAME = "interfaceName";
    protected static final String PLUGIN_SCHEMA_CLASS_NAME = "className";
    protected static final String PLUGIN_SCHEMA_JAR_URL = "jarURL";
    protected static final String PLUGIN_SCHEMA_ORG_NAME = "organizationName";
    protected static final String PLUGIN_CONFIG = "PluginConfiguration";
    protected static final String PLUGIN_CONFIG_SCHEMA_NAME = "pluginSchemaName";
    protected static final String PLUGIN_CONFIG_INT_NAME = "interfaceName";
    protected static final String PLUGIN_CONFIG_ORG_NAME = "organizationName";
    protected static final String SCHEMA_ATTRIBUTE = "AttributeSchema";
    protected static final String ATTRIBUTE_VALUE_PAIR = "AttributeValuePair";
    protected static final String ATTRIBUTE = "Attribute";
    protected static final String ATTRIBUTE_TYPE = "type";
    protected static final String ATTRIBUTE_UITYPE = "uitype";
    protected static final String ATTRIBUTE_SYNTAX = "syntax";
    protected static final String ATTRIBUTE_DEFAULT = "default";
    protected static final String ATTRIBUTE_RANGE_START = "rangeStart";
    protected static final String ATTRIBUTE_RANGE_END = "rangeEnd";
    protected static final String ATTRIBUTE_MIN_VALUE = "minValue";
    protected static final String ATTRIBUTE_MAX_VALUE = "maxValue";
    protected static final String ATTRIBUTE_VALIDATOR = "validator";
    protected static final String ATTRIBUTE_OPTIONAL = "IsOptional";
    protected static final String ATTRIBUTE_SERVICE_ID = "IsServiceIdentifier";
    protected static final String ATTRIBUTE_RESOURCE_NAME = "IsResourceNameAllowed";
    protected static final String ATTRIBUTE_STATUS_ATTR = "IsStatusAttribute";
    protected static final String HAS_SERVICE_URLS = "HasServiceURLs";
    protected static final String ATTRIBUTE_ANY = "any";
    protected static final String ATTRIBUTE_VIEW_BEAN_URL = "propertiesViewBeanURL";
    protected static final String ATTRIBUTE_VALUE = "Value";
    protected static final String ATTRIBUTE_DEFAULT_ELEMENT = "DefaultValues";
    protected static final String ATTRIBUTE_DEFAULT_CLASS = "DefaultValuesClassName";
    protected static final String CLASS_NAME = "className";
    protected static final String ATTRIBUTE_CHOICE_CLASS = "ChoiceValuesClassName";
    protected static final String ATTRIBUTE_CHOICE_VALUES_ELEMENT = "ChoiceValues";
    protected static final String ATTRIBUTE_CHOICE_VALUE_ELEMENT = "ChoiceValue";
    protected static final String ATTRIBUTE_COS_QUALIFIER = "cosQualifier";
    protected static final String ATTRIBUTE_BOOLEAN_VALUES_ELEMENT = "BooleanValues";
    protected static final String ATTRIBUTE_TRUE_BOOLEAN_ELEMENT = "BooleanTrueValue";
    protected static final String ATTRIBUTE_FALSE_BOOLEAN_ELEMENT = "BooleanFalseValue";
    protected static int counter = 0;

    static int getInstanceID() {
        return counter++;
    }

    public static String getUniqueID() {
        int id = counter++;
        StringBuffer sb = new StringBuffer(8);
        return sb.append(id).toString();
    }

    public static Map copyAttributes(Map attributes) {
        HashMap answer;
        if (attributes == null) {
            return new HashMap();
        }
        HashMap hashMap = answer = attributes instanceof CaseInsensitiveHashMap ? new CaseInsensitiveHashMap() : new HashMap();
        if (attributes.size() == 0) {
            return answer;
        }
        Iterator items = attributes.keySet().iterator();
        while (items.hasNext()) {
            String attrName = (String)items.next();
            Object o = attributes.get(attrName);
            if (o != null && o instanceof Set) {
                Set set = (Set)o;
                if (set.isEmpty()) {
                    if (set == Collections.EMPTY_SET) {
                        answer.put(attrName, Collections.EMPTY_SET);
                        continue;
                    }
                    answer.put(attrName, new HashSet());
                    continue;
                }
                answer.put(attrName, new HashSet(set));
                continue;
            }
            answer.put(attrName, o);
        }
        return answer;
    }

    static Map getAttrsFromEntry(SMSEntry entry) {
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("SMSUtils: obtains attrs from entry: " + entry.getDN());
        }
        HashMap answer = new HashMap();
        String[] attrValues = entry.getAttributeValues("sunKeyValue");
        String[] searchableAttrValues = entry.getAttributeValues("sunxmlKeyValue");
        if (attrValues == null && searchableAttrValues == null) {
            return answer;
        }
        for (int i = 0; attrValues != null && i < attrValues.length; ++i) {
            HashSet<String> values;
            String sattrvalue = attrValues[i];
            int index = sattrvalue.indexOf(61);
            if (index == -1) {
                SMSEntry.debug.error("SMSUtils: Invalid attribute entry: " + sattrvalue + "\nIn SMSEntry: " + entry);
                continue;
            }
            String attrName = sattrvalue.substring(0, index);
            String attrValue = null;
            if (sattrvalue.length() > index + 1) {
                attrValue = sattrvalue.substring(index + 1);
            }
            if ((values = (HashSet<String>)answer.get(attrName)) == null) {
                values = new HashSet<String>();
                answer.put(attrName, values);
            }
            if (attrValue == null || attrValue.length() == 0) continue;
            values.add(attrValue);
        }
        for (int j = 0; searchableAttrValues != null && j < searchableAttrValues.length; ++j) {
            HashSet<String> srchValues;
            String searchAttrvalue = searchableAttrValues[j];
            int indx = searchAttrvalue.indexOf(61);
            if (indx == -1) {
                SMSEntry.debug.error("SMSUtils: Invalid searchable attribute entry: " + searchAttrvalue + "\nIn SMSEntry: " + entry);
                continue;
            }
            String srchAttrName = searchAttrvalue.substring(0, indx);
            String srchAttrValue = null;
            if (searchAttrvalue.length() > indx + 1) {
                srchAttrValue = searchAttrvalue.substring(indx + 1);
            }
            if ((srchValues = (HashSet<String>)answer.get(srchAttrName)) == null) {
                srchValues = new HashSet<String>();
                answer.put(srchAttrName, srchValues);
            }
            if (srchAttrValue == null || srchAttrValue.length() == 0) continue;
            srchValues.add(srchAttrValue);
        }
        return answer;
    }

    static void setAttributeValuePairs(SMSEntry e, Map attrs, Set searchAttrNames) throws SMSException {
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("SMSUtils: setting attrs to entry: " + e.getDN());
        }
        if (attrs != null) {
            HashSet<String> values = new HashSet<String>();
            HashSet<String> srchValues = new HashSet<String>();
            Iterator attrNames = attrs.keySet().iterator();
            while (attrNames.hasNext()) {
                boolean bSearch;
                String attrName = (String)attrNames.next();
                Object o = attrs.get(attrName);
                boolean bl = bSearch = !searchAttrNames.isEmpty() && searchAttrNames.contains(attrName.toLowerCase());
                if (o == null) continue;
                if (o instanceof String) {
                    if (bSearch) {
                        srchValues.add(attrName + "=" + (String)o);
                        continue;
                    }
                    values.add(attrName + "=" + (String)o);
                    continue;
                }
                if (!(o instanceof Set)) continue;
                Set set = (Set)o;
                if (set.isEmpty()) {
                    if (bSearch) {
                        srchValues.add(attrName + "=");
                        continue;
                    }
                    values.add(attrName + "=");
                    continue;
                }
                Iterator i = set.iterator();
                while (i.hasNext()) {
                    String item = (String)i.next();
                    if (bSearch) {
                        srchValues.add(attrName + "=" + item);
                        continue;
                    }
                    values.add(attrName + "=" + item);
                }
            }
            if (!values.isEmpty()) {
                e.setAttribute("sunKeyValue", values.toArray(new String[values.size()]));
            }
            if (!srchValues.isEmpty()) {
                e.setAttribute("sunxmlKeyValue", srchValues.toArray(new String[srchValues.size()]));
            }
        }
    }

    static void addAttribute(SMSEntry e, String attrName, Set values, Set searchableAttrNames) throws SMSException {
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("SMSUtils: adding attributes to entry: " + e.getDN());
        }
        if (attrName == null || values == null) {
            return;
        }
        if (!searchableAttrNames.isEmpty() && searchableAttrNames.contains(attrName.toLowerCase())) {
            Iterator vals = values.iterator();
            while (vals.hasNext()) {
                e.addAttribute("sunxmlKeyValue", attrName + "=" + (String)vals.next());
            }
        } else {
            Iterator vals = values.iterator();
            while (vals.hasNext()) {
                e.addAttribute("sunKeyValue", attrName + "=" + (String)vals.next());
            }
        }
    }

    static void removeAttribute(SMSEntry e, String attrName) throws SMSException {
        String[] attrValues = e.getAttributeValues("sunKeyValue");
        String[] searchableAttrValues = e.getAttributeValues("sunxmlKeyValue");
        if (attrValues == null && searchableAttrValues == null) {
            return;
        }
        if (attrValues != null) {
            String matchString = attrName + "=";
            for (int i = 0; i < attrValues.length; ++i) {
                if (!attrValues[i].startsWith(matchString)) continue;
                e.removeAttribute("sunKeyValue", attrValues[i]);
            }
        }
        if (searchableAttrValues != null) {
            String matchStr = attrName + "=";
            for (int j = 0; j < searchableAttrValues.length; ++j) {
                if (!searchableAttrValues[j].startsWith(matchStr)) continue;
                e.removeAttribute("sunxmlKeyValue", searchableAttrValues[j]);
            }
        }
    }

    static void removeAttributeValues(SMSEntry e, String attrName, Set values, Set searchableAttrNames) throws SMSException {
        if (attrName == null || values == null || values.isEmpty()) {
            return;
        }
        if (!searchableAttrNames.isEmpty() && searchableAttrNames.contains(attrName.toLowerCase())) {
            Iterator items = values.iterator();
            while (items.hasNext()) {
                String value = (String)items.next();
                e.removeAttribute("sunxmlKeyValue", attrName + "=" + value);
            }
        } else {
            Iterator items = values.iterator();
            while (items.hasNext()) {
                String value = (String)items.next();
                e.removeAttribute("sunKeyValue", attrName + "=" + value);
            }
        }
    }

    static void replaceAttributeValue(SMSEntry entry, String attrName, String oldValue, String newValue, Set searchableAttrNames) throws SMSException {
        if (!searchableAttrNames.isEmpty() && searchableAttrNames.contains(attrName.toLowerCase())) {
            entry.removeAttribute("sunxmlKeyValue", attrName + "=" + oldValue);
            entry.addAttribute("sunxmlKeyValue", attrName + "=" + newValue);
        } else {
            entry.removeAttribute("sunKeyValue", attrName + "=" + oldValue);
            entry.addAttribute("sunKeyValue", attrName + "=" + newValue);
        }
    }

    static void replaceAttributeValues(SMSEntry entry, String attrName, Set oldValues, Set newValues, Set searchableAttrNames) throws SMSException {
        SMSUtils.removeAttributeValues(entry, attrName, oldValues, searchableAttrNames);
        if (newValues == null || newValues.isEmpty()) {
            return;
        }
        if (!searchableAttrNames.isEmpty() && searchableAttrNames.contains(attrName.toLowerCase())) {
            Iterator items = newValues.iterator();
            while (items.hasNext()) {
                String value = (String)items.next();
                entry.addAttribute("sunxmlKeyValue", attrName + "=" + value);
            }
        } else {
            Iterator items = newValues.iterator();
            while (items.hasNext()) {
                String value = (String)items.next();
                entry.addAttribute("sunKeyValue", attrName + "=" + value);
            }
        }
    }

    static String toAttributeValuePairXML(Map map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            buff.append("<").append(ATTRIBUTE_VALUE_PAIR).append(">\n");
            buff.append("    <").append(ATTRIBUTE).append(" ").append(NAME).append("=\"").append(e.getKey()).append("\"/>\n");
            Set values = (Set)e.getValue();
            Iterator j = values.iterator();
            while (j.hasNext()) {
                buff.append("    <").append(ATTRIBUTE_VALUE).append(">").append(SMSSchema.escapeSpecialCharacters((String)j.next())).append("</").append(ATTRIBUTE_VALUE).append(">\n");
            }
            buff.append("</").append(ATTRIBUTE_VALUE_PAIR).append(">\n");
        }
        return buff.toString();
    }
}

