/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceConfigImpl;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceConfigManagerImpl;
import com.sun.identity.sm.ServiceSchemaImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class ServiceConfig {
    private SSOToken token;
    private ServiceConfigImpl sc;
    private ServiceSchemaImpl ss;
    private ServiceConfigManager scm;

    private ServiceConfig() {
    }

    protected ServiceConfig(ServiceConfigManager scm, ServiceConfigImpl sc) throws SMSException, SSOException {
        this.scm = scm;
        this.token = scm.getSSOToken();
        this.sc = sc;
        this.ss = sc.getServiceSchemaImpl();
    }

    public String getServiceName() {
        return this.scm.getName();
    }

    public String getVersion() {
        return this.scm.getVersion();
    }

    public String getComponentName() {
        return this.sc.getComponentName();
    }

    public String getSchemaID() {
        return this.sc.getSchemaID();
    }

    public int getPriority() {
        return this.sc.getPriority();
    }

    public void setPriority(int priority) throws SSOException, SMSException {
        StringBuffer sb = new StringBuffer(8);
        String[] priorities = new String[]{sb.append(priority).toString()};
        SMSEntry e = this.sc.getSMSEntry();
        e.setAttribute("sunsmspriority", priorities);
        this.saveSMSEntry(e);
    }

    public String getLabeledUri() {
        return this.sc.getLabeledUri();
    }

    public void setLabeledUri(String luri) throws SSOException, SMSException {
        StringBuffer sb = new StringBuffer(8);
        String[] lUris = new String[]{sb.append(luri).toString()};
        SMSEntry e = this.sc.getSMSEntry();
        e.setAttribute("labeledURI", lUris);
        this.saveSMSEntry(e);
    }

    public Set getSubConfigNames() throws SMSException {
        try {
            return this.sc.getSubConfigNames(this.token);
        }
        catch (SSOException s) {
            SMSEntry.debug.error("ServiceConfig: Unable to get subConfig Names", s);
            return Collections.EMPTY_SET;
        }
    }

    public Set getSubConfigNames(String pattern) throws SMSException {
        try {
            return this.sc.getSubConfigNames(this.token, pattern);
        }
        catch (SSOException s) {
            SMSEntry.debug.error("ServiceConfigManager: Unable to get subConfig Names for filter: " + pattern, s);
            return Collections.EMPTY_SET;
        }
    }

    public Set getSubConfigNames(String pattern, String schemaName) throws SMSException {
        try {
            return this.sc.getSubConfigNames(pattern, schemaName);
        }
        catch (SSOException s) {
            SMSEntry.debug.error("ServiceConfigManager: Unable to get subConfig Names for filters: " + pattern + "AND" + schemaName, s);
            return Collections.EMPTY_SET;
        }
    }

    public Set getExportedSubConfigNames(String serviceId) throws SMSException {
        return null;
    }

    public ServiceConfig getSubConfig(String subConfigName) throws SSOException, SMSException {
        ServiceConfigImpl sci = this.sc.getSubConfig(this.token, subConfigName);
        return sci == null ? null : new ServiceConfig(this.scm, sci);
    }

    public void addSubConfig(String subConfigName, String subConfigId, int priority, Map attrs) throws SMSException, SSOException {
        if (this.sc.isNewEntry()) {
            this.scm.createOrganizationConfig(this.sc.getOrganizationName(), null);
            this.checkAndCreateComponents(this.sc.getDN());
        }
        ServiceSchemaImpl nss = null;
        nss = subConfigId != null ? this.ss.getSubSchema(subConfigId) : this.ss.getSubSchema(subConfigName);
        if (nss == null) {
            Object[] args = new String[]{subConfigName};
            throw new SMSException("amSDK", "sms-invalid-add-sub-config", args);
        }
        if (!nss.supportsMultipleConfigurations() && !this.getSubConfigNames().isEmpty()) {
            Object[] args = new String[]{subConfigName};
            throw new SMSException("amSDK", "sms-invalid-add-sub-config", args);
        }
        StringBuffer sb = new StringBuffer(8);
        sb.append(priority);
        CreateServiceConfig.createSubConfigEntry(this.token, "ou=" + subConfigName + "," + this.sc.getDN(), nss, subConfigId, sb.toString(), attrs, this.sc.getOrganizationName());
    }

    public void removeSubConfig(String subConfigName) throws SMSException, SSOException {
        subConfigName = SMSSchema.unescapeName(subConfigName);
        String sdn = "ou=" + subConfigName + "," + this.sc.getDN();
        ServiceConfigManagerImpl scmImpl = ServiceConfigManagerImpl.getInstance(this.token, this.getServiceName(), this.getVersion());
        ServiceConfigImpl sConfigImpl = this.sc.getSubConfig(this.token, subConfigName);
        if (sConfigImpl != null) {
            ServiceConfigImpl.deleteInstance(this.token, scmImpl, null, sdn, "/", sConfigImpl.getGroupName(), this.getComponentName() + "/" + SMSSchema.escapeSpecialCharacters(subConfigName), false, this.ss);
        }
        CachedSMSEntry cEntry = CachedSMSEntry.getInstance(this.token, sdn, null);
        SMSEntry entry = cEntry.getClonedSMSEntry();
        entry.delete(this.token);
        cEntry.refresh(entry);
        CachedSubEntries cse = CachedSubEntries.getInstance(this.token, this.sc.getDN());
        cse.remove(subConfigName);
    }

    public void importSubConfig(String subConfigName, String exportedSubConfigName) throws SMSException, SSOException {
    }

    public Map getAttributes() {
        return this.sc.getAttributes();
    }

    public Map getAttributesWithoutDefaults() {
        return this.sc.getAttributesWithoutDefaults();
    }

    public Map getAttributesForRead() {
        return this.sc.getAttributesForRead();
    }

    public Map getAttributesWithoutDefaultsForRead() {
        return this.sc.getAttributesWithoutDefaultsForRead();
    }

    public void setAttributes(Map attrs) throws SMSException, SSOException {
        Map oldAttrs = this.sc.getAttributesWithoutDefaults();
        Iterator it = oldAttrs.keySet().iterator();
        Map newAttrs = SMSUtils.copyAttributes(attrs);
        while (it.hasNext()) {
            String s = (String)it.next();
            if (newAttrs.containsKey(s)) continue;
            newAttrs.put(s, oldAttrs.get(s));
        }
        this.ss.validateAttributes(this.token, newAttrs, true, this.sc.getOrganizationName());
        SMSEntry e = this.sc.getSMSEntry();
        SMSUtils.setAttributeValuePairs(e, newAttrs, this.ss.getSearchableAttributeNames());
        this.saveSMSEntry(e);
    }

    public void addAttribute(String attrName, Set values) throws SMSException, SSOException {
        Map attributes = this.getAttributes();
        HashSet newVals = values;
        Set oldVals = (Set)attributes.get(attrName);
        if (oldVals != null) {
            newVals = new HashSet();
            newVals.addAll(values);
            newVals.addAll(oldVals);
        }
        this.ss.validateAttrValues(this.token, attrName, newVals, true, this.sc.getOrganizationName());
        SMSEntry e = this.sc.getSMSEntry();
        SMSUtils.addAttribute(e, attrName, values, this.ss.getSearchableAttributeNames());
        this.saveSMSEntry(e);
    }

    public void removeAttribute(String attrName) throws SMSException, SSOException {
        SMSEntry e = this.sc.getSMSEntry();
        SMSUtils.removeAttribute(e, attrName);
        this.saveSMSEntry(e);
    }

    public void removeAttributes(Set attrNames) throws SMSException, SSOException {
        SMSEntry e = this.sc.getSMSEntry();
        if (attrNames != null && !attrNames.isEmpty()) {
            Iterator items = attrNames.iterator();
            while (items.hasNext()) {
                SMSUtils.removeAttribute(e, (String)items.next());
            }
            this.saveSMSEntry(e);
        }
    }

    public void removeAttributeValues(String attrName, Set values) throws SMSException, SSOException {
        SMSEntry e = this.sc.getSMSEntry();
        SMSUtils.removeAttributeValues(e, attrName, values, this.ss.getSearchableAttributeNames());
        this.saveSMSEntry(e);
    }

    public void replaceAttributeValue(String attrName, String oldValue, String newValue) throws SMSException, SSOException {
        Map attributes = this.getAttributes();
        HashSet<String> newVals = new HashSet<String>();
        Set oldVals = (Set)attributes.get(attrName);
        if (oldVals != null) {
            newVals.addAll(oldVals);
            newVals.remove(oldValue);
        }
        newVals.add(newValue);
        this.ss.validateAttrValues(this.token, attrName, newVals, true, this.sc.getOrganizationName());
        SMSEntry e = this.sc.getSMSEntry();
        SMSUtils.replaceAttributeValue(e, attrName, oldValue, newValue, this.ss.getSearchableAttributeNames());
        this.saveSMSEntry(e);
    }

    public void replaceAttributeValues(String attrName, Set oldValues, Set newValues) throws SMSException, SSOException {
        Map attributes = this.getAttributes();
        HashSet newVals = new HashSet();
        Set oldVals = (Set)attributes.get(attrName);
        if (oldVals != null) {
            newVals.addAll(oldVals);
            newVals.removeAll(oldValues);
        }
        newVals.addAll(newValues);
        this.ss.validateAttrValues(this.token, attrName, newVals, true, this.sc.getOrganizationName());
        SMSEntry e = this.sc.getSMSEntry();
        SMSUtils.replaceAttributeValues(e, attrName, oldValues, newValues, this.ss.getSearchableAttributeNames());
        this.saveSMSEntry(e);
    }

    public String getDN() {
        return this.sc.getDN();
    }

    public String getLastModifiedTime() throws SMSException, SSOException {
        SMSEntry e = this.sc.getSMSEntry();
        String[] vals = e.getAttributeValues("modifytimestamp", true);
        String mTS = null;
        if (vals != null) {
            mTS = vals[0];
        }
        return mTS;
    }

    public Set getExportedOrganizationNames() {
        return null;
    }

    public void setExportedOrganizationNames(Set names) throws SMSException, SSOException {
    }

    public void addExportedOrganizationNames(Set names) throws SMSException, SSOException {
    }

    public void removeSharedOrganizationNames(Set names) throws SMSException, SSOException {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Service Component name: " + this.getComponentName());
        sb.append("\n\tAttributes: " + this.getAttributes()).append("\n");
        try {
            Iterator subConfigNames = this.getSubConfigNames().iterator();
            while (subConfigNames.hasNext()) {
                ServiceConfig sc = this.getSubConfig((String)subConfigNames.next());
                sb.append(sc);
            }
        }
        catch (Exception e) {
            sb.append(e.getMessage());
        }
        return sb.toString();
    }

    void saveSMSEntry(SMSEntry e) throws SMSException, SSOException {
        if (e.isNewEntry()) {
            CreateServiceConfig.checkBaseNodesForOrg(this.token, DNMapper.orgNameToDN(this.sc.getOrganizationName()), this.getServiceName(), this.getVersion());
            String parentDN = new DN(e.getDN()).getParent().toString();
            this.checkAndCreateComponents(parentDN);
            e.addAttribute("objectclass", "top");
            e.addAttribute("objectclass", "sunServiceComponent");
        }
        e.save(this.token);
        this.sc.refresh(e);
    }

    public void checkAndCreateGroup(String dn, String groupName) throws SMSException, SSOException {
        CachedSMSEntry entry = CachedSMSEntry.getInstance(this.token, dn, null);
        if (entry.isNewEntry()) {
            String pDN = new DN(dn).getParent().toString();
            CachedSMSEntry pEntry = CachedSMSEntry.getInstance(this.token, pDN, null);
            if (pEntry.isNewEntry()) {
                this.checkAndCreateComponents(pDN);
            }
            SMSEntry e = entry.getClonedSMSEntry();
            e.addAttribute("objectclass", "top");
            e.addAttribute("objectclass", "sunServiceComponent");
            e.addAttribute("sunserviceID", groupName);
            e.save(this.token);
            entry.refresh(e);
        }
    }

    void checkAndCreateComponents(String dn) throws SMSException, SSOException {
        CachedSMSEntry entry = CachedSMSEntry.getInstance(this.token, dn, null);
        if (entry.isNewEntry()) {
            String pDN = new DN(dn).getParent().toString();
            CachedSMSEntry pEntry = CachedSMSEntry.getInstance(this.token, pDN, null);
            if (pEntry.isNewEntry()) {
                this.checkAndCreateComponents(pDN);
            }
            SMSEntry e = entry.getClonedSMSEntry();
            e.addAttribute("objectclass", "top");
            e.addAttribute("objectclass", "sunServiceComponent");
            e.save(this.token);
            entry.refresh(e);
        }
    }

    public String toXML(String NodeTag) throws SMSException, SSOException {
        return this.sc.toXML(NodeTag);
    }

    public String toXML(String NodeTag, String orgName) throws SMSException, SSOException {
        return this.sc.toXML(NodeTag, orgName);
    }
}

