/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ServiceInstanceImpl {
    private String name;
    private String group;
    private String uri;
    private CachedSMSEntry smsEntry;
    private Map attributes;
    private static Map serviceInstances = new HashMap();
    private static Map userPrincipals = new HashMap();
    private static final String serviceInsMutex = "ServiceInstanceMutex";
    private static Debug debug = SMSEntry.debug;

    private ServiceInstanceImpl(String name, CachedSMSEntry entry) {
        this.name = name;
        this.smsEntry = entry;
        this.smsEntry.addServiceListener(this);
        this.update();
    }

    String getName() {
        return this.name;
    }

    String getGroup() {
        return this.group;
    }

    String getURI() {
        return this.uri;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("\nService Instance: ").append(this.name).append("\n\tGroup: ").append(this.getGroup()).append("\n\tURI: ").append(this.getURI()).append("\n\tAttributes: ").append(this.attributes);
        return sb.toString();
    }

    Map getAttributes() {
        return SMSUtils.copyAttributes(this.attributes);
    }

    SMSEntry getSMSEntry() {
        return this.smsEntry.getClonedSMSEntry();
    }

    void refresh(SMSEntry newEntry) throws SMSException {
        this.smsEntry.refresh(newEntry);
    }

    void updateupdateAndNotifyListeners() {
        this.update();
    }

    void update() {
        this.attributes = SMSUtils.getAttrsFromEntry(this.smsEntry.getSMSEntry());
        this.group = "default";
        String[] groups = this.smsEntry.getSMSEntry().getAttributeValues("sunserviceID");
        if (groups != null) {
            this.group = groups[0];
        }
        this.uri = null;
        String[] uris = this.smsEntry.getSMSEntry().getAttributeValues("labeledURI");
        if (uris != null) {
            this.uri = uris[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServiceInstanceImpl getInstance(SSOToken token, String serviceName, String version, String iName) throws SMSException, SSOException {
        String cName;
        ServiceInstanceImpl answer;
        if (debug.messageEnabled()) {
            debug.message("ServiceInstanceImpl::getInstance: called: " + serviceName + "(" + version + ")" + " Instance: " + iName);
        }
        if ((answer = ServiceInstanceImpl.getFromCache(cName = ServiceInstanceImpl.getCacheName(serviceName, version, iName), serviceName, version, iName, token)) != null) {
            if (!SMSEntry.cacheSMSEntries) {
                answer.update();
            }
            return answer;
        }
        String string = serviceInsMutex;
        synchronized (serviceInsMutex) {
            answer = ServiceInstanceImpl.getFromCache(cName, serviceName, version, iName, token);
            if (answer == null) {
                CachedSMSEntry entry = ServiceInstanceImpl.checkAndUpdatePermission(cName, serviceName, version, iName, token);
                answer = new ServiceInstanceImpl(iName, entry);
                HashMap<String, ServiceInstanceImpl> sudoServiceInstances = new HashMap<String, ServiceInstanceImpl>(serviceInstances);
                sudoServiceInstances.put(cName, answer);
                serviceInstances = sudoServiceInstances;
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (debug.messageEnabled()) {
                debug.message("ServiceInstanceImpl::getInstance: success: " + serviceName + "(" + version + ")" + " Instance: " + iName);
            }
            return answer;
        }
    }

    static void clearCache() {
        serviceInstances = new HashMap();
    }

    static String getCacheName(String sName, String version, String ins) {
        StringBuffer sb = new StringBuffer(100);
        sb.append(sName).append(version).append(ins);
        return sb.toString().toLowerCase();
    }

    static ServiceInstanceImpl getFromCache(String cacheName, String sName, String version, String iName, SSOToken t) throws SMSException, SSOException {
        Set principals;
        ServiceInstanceImpl answer = (ServiceInstanceImpl)serviceInstances.get(cacheName);
        if (answer != null && !answer.smsEntry.isValid()) {
            answer = null;
        }
        if (answer != null && !(principals = (Set)userPrincipals.get(cacheName)).contains(((Object)t.getTokenID()).toString())) {
            ServiceInstanceImpl.checkAndUpdatePermission(cacheName, sName, version, iName, t);
        }
        return answer;
    }

    static synchronized CachedSMSEntry checkAndUpdatePermission(String cacheName, String serviceName, String version, String iName, SSOToken t) throws SMSException, SSOException {
        String dn = "ou=" + iName + "," + "ou=Instances," + ServiceManager.getServiceNameDN(serviceName, version);
        CachedSMSEntry entry = CachedSMSEntry.getInstance(t, dn, null);
        if (entry.isNewEntry()) {
            Object[] args = new String[]{iName};
            throw new SMSException("amSDK", "sms-no-such-instance", args);
        }
        HashSet<String> sudoPrincipals = (HashSet<String>)userPrincipals.get(cacheName);
        sudoPrincipals = sudoPrincipals == null ? new HashSet<String>() : new HashSet(sudoPrincipals);
        sudoPrincipals.add(((Object)t.getTokenID()).toString());
        HashMap<String, HashSet<String>> sudoUserPrincipals = new HashMap<String, HashSet<String>>(userPrincipals);
        sudoUserPrincipals.put(cacheName, sudoPrincipals);
        userPrincipals = sudoUserPrincipals;
        return entry;
    }

    public String toXML() {
        StringBuffer buff = new StringBuffer();
        buff.append("<").append("Instance").append(" ").append("name").append("=\"").append(this.name).append("\"").append(" ").append("group").append("=\"").append(this.group).append("\"");
        if (this.uri != null && this.uri.length() > 0) {
            buff.append(" ").append("uri").append("=\"").append(this.uri).append("\"");
        }
        buff.append(">");
        buff.append(SMSUtils.toAttributeValuePairXML(this.attributes));
        buff.append("</").append("Instance").append(">\n");
        return buff.toString();
    }
}

