/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc;

import com.metamatrix.common.util.exception.SQLExceptionUnroller;
import com.metamatrix.connector.jdbc.extension.ResultsTranslator;
import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.connector.jdbc.extension.SQLTranslator;
import com.metamatrix.connector.jdbc.extension.TranslatedCommand;
import com.metamatrix.connector.jdbc.util.FunctionReplacementVisitor;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.pool.ConnectorIdentity;
import com.metamatrix.data.visitor.framework.LanguageObjectVisitor;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;

public abstract class JDBCBaseExecution {
    protected Connection connection;
    protected SQLTranslator sqlTranslator;
    protected ResultsTranslator resultsTranslator;
    protected ConnectorIdentity id;
    protected ConnectorLogger logger;
    protected ExecutionContext context;
    protected boolean trimString;
    protected ICommand command;
    protected Statement statement;

    protected JDBCBaseExecution(Connection connection, SQLTranslator sqlTranslator, ResultsTranslator resultsTranslator, ConnectorLogger logger, Properties props, ExecutionContext context) {
        this.connection = connection;
        this.sqlTranslator = sqlTranslator;
        this.resultsTranslator = resultsTranslator;
        this.logger = logger;
        this.context = context;
        String propStr = props.getProperty("TrimStrings");
        if (propStr != null) {
            this.trimString = Boolean.valueOf(propStr);
        }
    }

    protected TranslatedCommand translateCommand(ICommand command) throws ConnectorException {
        this.command = this.sqlTranslator.modifyCommand(command, this.context);
        Map modifiers = this.sqlTranslator.getFunctionModifiers();
        FunctionReplacementVisitor functionVisitor = new FunctionReplacementVisitor(modifiers);
        command.acceptVisitor((LanguageObjectVisitor)functionVisitor);
        SQLConversionVisitor visitor = this.sqlTranslator.getTranslationVisitor();
        visitor.setFunctionModifiers(modifiers);
        TranslatedCommand translatedCommand = new TranslatedCommand(visitor);
        translatedCommand.translateCommand(command);
        if (translatedCommand.getSql() != null) {
            this.logger.logDetail("Source-specific command: " + translatedCommand.getSql());
        }
        return translatedCommand;
    }

    public synchronized void close() throws ConnectorException {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
        }
        catch (SQLException e) {
            this.logger.logError(e.getMessage());
            throw new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)e));
        }
    }

    public synchronized void cancel() throws ConnectorException {
        try {
            if (this.statement != null) {
                this.statement.cancel();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected synchronized Statement getStatement() throws SQLException {
        if (this.statement != null) {
            this.statement.close();
            this.statement = null;
        }
        this.statement = this.connection.createStatement();
        return this.statement;
    }

    protected synchronized CallableStatement getCallableStatement(String sql) throws SQLException {
        if (this.statement != null) {
            this.statement.close();
            this.statement = null;
        }
        this.statement = this.connection.prepareCall(sql);
        return (CallableStatement)this.statement;
    }

    protected synchronized PreparedStatement getPreparedStatement(String sql) throws SQLException {
        if (this.statement != null) {
            this.statement.close();
            this.statement = null;
        }
        this.statement = this.connection.prepareStatement(sql);
        return (PreparedStatement)this.statement;
    }

    public Connection getConnection() {
        return this.connection;
    }
}

