/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc;

import com.metamatrix.connector.jdbc.ConnectionListener;
import com.metamatrix.connector.jdbc.DefaultConnectionListener;
import com.metamatrix.connector.jdbc.JDBCSourceConnectionFactory;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.pool.ConnectorIdentity;
import com.metamatrix.data.pool.SingleIdentity;
import com.metamatrix.data.pool.SourceConnection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.Properties;

public class JDBCSingleIdentityConnectionFactory
extends JDBCSourceConnectionFactory {
    private Driver driver;
    private String url;
    private int transIsoLevel;
    private Properties userProps;
    protected ConnectionListener connectionListener = new DefaultConnectionListener();
    private ConnectorLogger logger;
    private String deregisterType;

    public void initialize(ConnectorEnvironment env) throws ConnectorException {
        super.initialize(env);
        this.verifyConnectionProperties(env.getProperties());
        this.logger = env.getLogger();
        this.testConnection();
    }

    public boolean isSingleIdentity() {
        return true;
    }

    protected void verifyConnectionProperties(Properties connectionProps) throws ConnectorException {
        String driverClassName = connectionProps.getProperty("Driver");
        this.driver = this.createDriver(driverClassName);
        this.url = connectionProps.getProperty("URL");
        this.validateURL(this.driver, this.url);
        String username = connectionProps.getProperty("User");
        String password = connectionProps.getProperty("Password");
        this.deregisterType = connectionProps.getProperty("deregisterDriver", "deregisterByClassName");
        this.userProps = new Properties();
        if (username != null && username.trim().length() > 0) {
            this.userProps.setProperty("user", username.trim());
        }
        if (password != null && password.trim().length() > 0) {
            this.userProps.setProperty("password", password.trim());
        }
        this.transIsoLevel = this.interpretTransactionIsolationLevel(connectionProps.getProperty("TransactionIsolationLevel"));
    }

    private void testConnection() throws ConnectorException {
        SourceConnection connection = this.createConnection(this.createIdentity(null));
        connection.closeSource();
    }

    public ConnectorIdentity createIdentity(SecurityContext context) throws ConnectorException {
        return new SingleIdentity(context);
    }

    public SourceConnection createConnection(ConnectorIdentity id) throws ConnectorException {
        return this.createJDBCConnection(this.driver, this.url, this.transIsoLevel, this.userProps);
    }

    protected int getTransactionIsolation() {
        return this.transIsoLevel;
    }

    protected ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public void shutdown() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        Driver tempdriver = null;
        while (drivers.hasMoreElements()) {
            tempdriver = drivers.nextElement();
            if (tempdriver.getClass().getClassLoader() != this.getClass().getClassLoader()) continue;
            if (this.deregisterType.equals("deregisterByClassName")) {
                if (!tempdriver.getClass().getName().equals(this.driver.getClass().getName())) continue;
                this.deregisterDriver(tempdriver);
                continue;
            }
            this.deregisterDriver(tempdriver);
        }
    }

    private void deregisterDriver(Driver driver) {
        try {
            DriverManager.deregisterDriver(driver);
        }
        catch (Throwable e) {
            this.logger.logError(e.getMessage());
        }
    }
}

