/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.extension.impl;

import com.metamatrix.common.types.MMJDBCSQLTypeInfo;
import com.metamatrix.common.util.exception.SQLExceptionUnroller;
import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.connector.jdbc.extension.ResultsTranslator;
import com.metamatrix.connector.jdbc.extension.TranslatedCommand;
import com.metamatrix.connector.jdbc.extension.ValueRetriever;
import com.metamatrix.connector.jdbc.extension.ValueTranslator;
import com.metamatrix.connector.jdbc.extension.impl.BasicValueRetriever;
import com.metamatrix.connector.jdbc.extension.impl.BlobValueTranslator;
import com.metamatrix.connector.jdbc.extension.impl.ClobToStringValueTranslator;
import com.metamatrix.connector.jdbc.extension.impl.ClobValueTranslator;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.IParameter;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public class BasicResultsTranslator
implements ResultsTranslator {
    private static final TimeZone LOCAL_TIME_ZONE = TimeZone.getDefault();
    private List valueTranslators = new ArrayList();
    private ValueRetriever valueRetriever = new BasicValueRetriever();
    private TimeZone dbmsTimeZone = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Clob;

    public void initialize(ConnectorEnvironment env) throws ConnectorException {
        ValueTranslator valueTranslator = new BlobValueTranslator();
        valueTranslator.initialize(env);
        this.valueTranslators.add(valueTranslator);
        valueTranslator = new ClobValueTranslator();
        valueTranslator.initialize(env);
        this.valueTranslators.add(valueTranslator);
        valueTranslator = new ClobToStringValueTranslator();
        valueTranslator.initialize(env);
        this.valueTranslators.add(valueTranslator);
        String timeZone = env.getProperties().getProperty("DatabaseTimeZone");
        if (timeZone != null && timeZone.trim().length() > 0) {
            this.dbmsTimeZone = TimeZone.getTimeZone(timeZone);
            if (LOCAL_TIME_ZONE.equals(timeZone)) {
                this.dbmsTimeZone = null;
            }
        }
    }

    public ResultSet executeStoredProcedure(CallableStatement statement, TranslatedCommand command) throws SQLException {
        IParameter param;
        List params = command.getPreparedValues();
        int index = 1;
        boolean hasResultSet = false;
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            param = (IParameter)iter.next();
            if (param.getDirection() == 3) {
                this.registerSpecificTypeOfOutParameter(statement, param, index++);
                continue;
            }
            if (param.getDirection() != 4) continue;
            hasResultSet = true;
        }
        iter = params.iterator();
        while (iter.hasNext()) {
            param = (IParameter)iter.next();
            if (param.getDirection() == 2) {
                this.registerSpecificTypeOfOutParameter(statement, param, index);
            } else if (param.getDirection() == 1) {
                this.registerSpecificTypeOfOutParameter(statement, param, index++);
            }
            Object value = param.getValue();
            if (param.getDirection() != 0 && param.getDirection() != 2) continue;
            if (value == null) {
                try {
                    statement.setNull(index++, MMJDBCSQLTypeInfo.getSQLTypeFromClass((String)param.getType().getName()));
                    continue;
                }
                catch (SQLException e) {
                    SQLException e2 = SQLExceptionUnroller.unRollException((SQLException)e);
                    throw e2;
                }
            }
            try {
                statement.setObject(index++, value);
            }
            catch (SQLException e) {
                SQLException e2 = SQLExceptionUnroller.unRollException((SQLException)e);
                throw e2;
            }
        }
        if (hasResultSet) {
            return statement.executeQuery();
        }
        statement.execute();
        return statement.getResultSet();
    }

    public List getValueTranslators() {
        return this.valueTranslators;
    }

    public ValueRetriever getValueRetriever() {
        return this.valueRetriever;
    }

    protected void registerSpecificTypeOfOutParameter(CallableStatement statement, IParameter param, int index) throws SQLException {
        Class runtimeType = param.getType();
        int typeToSet = 12;
        if (runtimeType == null) {
            typeToSet = 0;
        } else if (runtimeType.equals(class$java$lang$String == null ? (class$java$lang$String = BasicResultsTranslator.class$("java.lang.String")) : class$java$lang$String)) {
            typeToSet = 12;
        } else if (runtimeType.equals(class$java$lang$Character == null ? (class$java$lang$Character = BasicResultsTranslator.class$("java.lang.Character")) : class$java$lang$Character)) {
            typeToSet = 1;
        } else if (runtimeType.equals(class$java$sql$Date == null ? (class$java$sql$Date = BasicResultsTranslator.class$("java.sql.Date")) : class$java$sql$Date)) {
            typeToSet = 91;
        } else if (runtimeType.equals(class$java$lang$Double == null ? (class$java$lang$Double = BasicResultsTranslator.class$("java.lang.Double")) : class$java$lang$Double)) {
            typeToSet = 8;
        } else if (runtimeType.equals(class$java$lang$Float == null ? (class$java$lang$Float = BasicResultsTranslator.class$("java.lang.Float")) : class$java$lang$Float)) {
            typeToSet = 6;
        } else if (runtimeType.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = BasicResultsTranslator.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            typeToSet = 4;
        } else if (runtimeType.equals(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = BasicResultsTranslator.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            typeToSet = 93;
        } else if (runtimeType.equals(class$java$sql$Time == null ? (class$java$sql$Time = BasicResultsTranslator.class$("java.sql.Time")) : class$java$sql$Time)) {
            typeToSet = 92;
        } else if (runtimeType.equals(class$java$math$BigInteger == null ? (class$java$math$BigInteger = BasicResultsTranslator.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            typeToSet = -5;
        } else if (runtimeType.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = BasicResultsTranslator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            typeToSet = 2;
        } else {
            throw new UnsupportedOperationException(JDBCPlugin.Util.getString("JDBCTranslator.Unable_to_set_appropriate_output_parameter_type_of_class({0})", (Object)runtimeType.getName()));
        }
        try {
            statement.registerOutParameter(index, typeToSet);
        }
        catch (SQLException e) {
            SQLException e2 = SQLExceptionUnroller.unRollException((SQLException)e);
            throw e2;
        }
    }

    public int executeStatementForLargeObjects(Connection conn, PreparedStatement stmt, TranslatedCommand command) throws SQLException {
        List params = command.getPreparedValues();
        if (params.get(0) instanceof ICompareCriteria) {
            for (int i = 0; i < params.size(); ++i) {
                ICompareCriteria param;
                Object right;
                if ((class$java$sql$Blob == null ? BasicResultsTranslator.class$("java.sql.Blob") : class$java$sql$Blob).isAssignableFrom((right = ((ILiteral)(param = (ICompareCriteria)params.get(i)).getRightExpression()).getValue()).getClass())) {
                    this.setBlob(i + 1, right, conn, stmt);
                    continue;
                }
                if (!(class$java$sql$Clob == null ? BasicResultsTranslator.class$("java.sql.Clob") : class$java$sql$Clob).isAssignableFrom(right.getClass())) continue;
                this.setClob(i + 1, right, conn, stmt);
            }
        } else {
            for (int i = 0; i < params.size(); ++i) {
                ILiteral param;
                Class<?> paramClass;
                if ((class$java$sql$Blob == null ? BasicResultsTranslator.class$("java.sql.Blob") : class$java$sql$Blob).isAssignableFrom(paramClass = (param = (ILiteral)params.get(i)).getValue().getClass())) {
                    this.setBlob(i + 1, param.getValue(), conn, stmt);
                    continue;
                }
                if (!(class$java$sql$Clob == null ? BasicResultsTranslator.class$("java.sql.Clob") : class$java$sql$Clob).isAssignableFrom(paramClass)) continue;
                this.setClob(i + 1, param.getValue(), conn, stmt);
            }
        }
        return stmt.executeUpdate();
    }

    public int executeStatementForBulkInsert(Connection conn, Statement stmt, TranslatedCommand command) throws SQLException {
        List rows = command.getPreparedValues();
        Iterator rowIter = rows.iterator();
        while (rowIter.hasNext()) {
            String values = (String)rowIter.next();
            stmt.addBatch(command.getSql() + values);
        }
        int[] results = stmt.executeBatch();
        int updateCount = 0;
        for (int i = 0; i < results.length; ++i) {
            updateCount += results[i];
        }
        return updateCount;
    }

    private void setClob(int index, Object value, Connection con, PreparedStatement statement) throws SQLException {
        try {
            statement.setClob(index, (Clob)value);
        }
        catch (SQLException ex) {
            Object[] params = new Object[]{ex.getMessage()};
            throw new SQLException(JDBCPlugin.Util.getString("JDBCTranslator._Unable_to_get_Clob_and_set_parameter._{0}", params));
        }
    }

    private void setBlob(int index, Object value, Connection con, PreparedStatement statement) throws SQLException {
        try {
            statement.setBlob(index, (Blob)value);
        }
        catch (SQLException ex) {
            Object[] params = new Object[]{ex.getMessage()};
            throw new SQLException(JDBCPlugin.Util.getString("JDBCTranslator._Unable_to_get_Blob_and_set_parameter._{0}", params));
        }
    }

    public TimeZone getDatabaseTimezone() {
        return this.dbmsTimeZone;
    }

    public Batch modifyBatch(Batch batch, ExecutionContext context, ICommand command) {
        return batch;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

