/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.extension.impl;

import com.metamatrix.connector.jdbc.extension.ValueRetriever;
import com.metamatrix.data.api.TypeFacility;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class BasicValueRetriever
implements ValueRetriever {
    private static final Map TYPE_CODE_MAP = new HashMap(20);
    private static final int INTEGER_CODE = 0;
    private static final int LONG_CODE = 1;
    private static final int DOUBLE_CODE = 2;
    private static final int BIGDECIMAL_CODE = 3;
    private static final int SHORT_CODE = 4;
    private static final int FLOAT_CODE = 5;

    public Object retrieveValue(ResultSet results, int columnIndex, Class expectedType) throws SQLException {
        Integer code = (Integer)TYPE_CODE_MAP.get(expectedType);
        if (code != null) {
            switch (code) {
                case 0: {
                    int value = results.getInt(columnIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return new Integer(value);
                }
                case 1: {
                    long value = results.getLong(columnIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return new Long(value);
                }
                case 2: {
                    double value = results.getDouble(columnIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return new Double(value);
                }
                case 3: {
                    return results.getBigDecimal(columnIndex);
                }
                case 4: {
                    short value = results.getShort(columnIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return new Short(value);
                }
                case 5: {
                    float value = results.getFloat(columnIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return new Float(value);
                }
            }
        }
        return results.getObject(columnIndex);
    }

    static {
        TYPE_CODE_MAP.put(TypeFacility.RUNTIME_TYPES.INTEGER, new Integer(0));
        TYPE_CODE_MAP.put(TypeFacility.RUNTIME_TYPES.LONG, new Integer(1));
        TYPE_CODE_MAP.put(TypeFacility.RUNTIME_TYPES.DOUBLE, new Integer(2));
        TYPE_CODE_MAP.put(TypeFacility.RUNTIME_TYPES.BIG_DECIMAL, new Integer(3));
        TYPE_CODE_MAP.put(TypeFacility.RUNTIME_TYPES.SHORT, new Integer(4));
        TYPE_CODE_MAP.put(TypeFacility.RUNTIME_TYPES.FLOAT, new Integer(5));
    }
}

