/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.oracle;

import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.data.api.TypeFacility;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.IOrderBy;
import com.metamatrix.data.language.IOrderByItem;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.IUnion;
import com.metamatrix.data.metadata.runtime.Element;
import com.metamatrix.data.metadata.runtime.MetadataID;
import java.sql.Time;
import java.util.Iterator;
import java.util.List;

public class OracleSQLConversionVisitor
extends SQLConversionVisitor {
    private final int MAX_SELECT_ALIAS_LENGTH = 30;
    private final int MAX_TABLE_ALIAS_LENGTH = 30;
    private static final String DATE_TYPE = "DATE";

    protected boolean useAsInGroupAlias() {
        return false;
    }

    protected String translateLiteralTime(Time timeValue) {
        return "{ts'1970-01-01 " + this.formatDateValue(timeValue) + "'}";
    }

    public void visit(ICompareCriteria obj) {
        IExpression leftExpression = obj.getLeftExpression();
        this.append((ILanguageObject)leftExpression);
        this.buffer.append(" ");
        int op = obj.getOperator();
        switch (op) {
            case 0: {
                this.buffer.append("=");
                break;
            }
            case 5: {
                this.buffer.append(">=");
                break;
            }
            case 4: {
                this.buffer.append(">");
                break;
            }
            case 3: {
                this.buffer.append("<=");
                break;
            }
            case 2: {
                this.buffer.append("<");
                break;
            }
            case 1: {
                this.buffer.append("<>");
            }
        }
        this.buffer.append(" ");
        IExpression rightExpression = obj.getRightExpression();
        if (leftExpression instanceof IElement && rightExpression instanceof ILiteral && ((ILiteral)rightExpression).getType().equals(TypeFacility.RUNTIME_TYPES.TIMESTAMP)) {
            this.translateStringToTimestampConversion(leftExpression, rightExpression);
        } else {
            this.append((ILanguageObject)rightExpression);
        }
    }

    protected void translateStringToTimestampConversion(IExpression leftExpression, IExpression rightExpression) {
        String nativeType = DATE_TYPE;
        try {
            IElement element = (IElement)leftExpression;
            MetadataID metadataID = element.getMetadataID();
            Element elem = (Element)this.metadata.getObject(metadataID);
            nativeType = elem.getNativeType();
        }
        catch (ConnectorException e) {
            // empty catch block
        }
        ILiteral timestamp = (ILiteral)rightExpression;
        if (nativeType != null && nativeType.equalsIgnoreCase(DATE_TYPE)) {
            this.buffer.append("to_date('");
            String tsValue = this.formatDateValue(timestamp.getValue());
            int decimalIndex = tsValue.lastIndexOf(".");
            if (decimalIndex >= 0) {
                this.buffer.append(tsValue.substring(0, decimalIndex));
            } else {
                this.buffer.append(tsValue);
            }
            this.buffer.append("','YYYY-MM-DD HH24:MI:SS')");
        } else {
            this.buffer.append("to_timestamp('");
            this.buffer.append(this.formatDateValue(timestamp.getValue()));
            this.buffer.append("','YYYY-MM-DD HH24:MI:SS.FF')");
        }
    }

    public void visit(IUnion obj) {
        this.appendQuery((IQuery)obj);
        Iterator queryIter = obj.getUnionQueries().iterator();
        Iterator allIter = obj.getUnionAllFlags().iterator();
        while (queryIter.hasNext()) {
            this.buffer.append(" ");
            this.buffer.append("UNION");
            Boolean allFlag = (Boolean)allIter.next();
            if (allFlag.equals(Boolean.TRUE)) {
                this.buffer.append(" ");
                this.buffer.append("ALL");
            }
            this.buffer.append(" ");
            IQuery query = (IQuery)queryIter.next();
            if (query instanceof IUnion) {
                this.buffer.append("(");
                this.append((ILanguageObject)query);
                this.buffer.append(")");
                continue;
            }
            this.appendQuery(query);
        }
        IOrderBy orderBy = obj.getUnionOrderBy();
        if (orderBy != null) {
            this.buffer.append(" ");
            this.appendUnionOrderBy(orderBy);
        }
    }

    protected void appendUnionOrderBy(IOrderBy obj) {
        this.buffer.append("ORDER").append(" ").append("BY").append(" ");
        List items = obj.getItems();
        Iterator iter = items.iterator();
        IOrderByItem item = (IOrderByItem)iter.next();
        this.appendUnionOrderByItem(item);
        while (iter.hasNext()) {
            this.buffer.append(",");
            this.buffer.append(" ");
            this.appendUnionOrderByItem((IOrderByItem)iter.next());
        }
    }

    protected void appendUnionOrderByItem(IOrderByItem obj) {
        IElement element;
        String itemName = obj.getName();
        if (obj.getElement() != null && (element = obj.getElement()).getMetadataID() != null) {
            itemName = this.getName(element.getMetadataID());
        }
        this.buffer.append(this.getShortName(itemName));
        if (!obj.getDirection()) {
            this.buffer.append(" ").append("DESC");
        }
    }

    private String getShortName(String name) {
        int lastDot = name.lastIndexOf(".");
        if (lastDot >= 0) {
            return name.substring(lastDot + 1);
        }
        return name;
    }

    protected int getMaxSelectAliasLength() {
        return 30;
    }

    protected int getMaxTableAliasLength() {
        return 30;
    }
}

