/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.oracle;

import com.metamatrix.common.util.TimestampWithTimezone;
import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.connector.jdbc.extension.ValueTranslator;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;

public class StringToTimestampWithTimeZoneTransform
implements ValueTranslator {
    private static final int NANO_DIGITS = 9;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public Class getSourceType() {
        return class$java$lang$String == null ? (class$java$lang$String = StringToTimestampWithTimeZoneTransform.class$("java.lang.String")) : class$java$lang$String;
    }

    public Class getTargetType() {
        return class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = StringToTimestampWithTimeZoneTransform.class$("java.sql.Timestamp")) : class$java$sql$Timestamp;
    }

    public void initialize(ConnectorEnvironment env) {
    }

    public Object translate(Object value, ExecutionContext context) throws ConnectorException {
        if (value == null) {
            return value;
        }
        String inStr = (String)value;
        try {
            Timestamp ts = Timestamp.valueOf(inStr);
            return ts;
        }
        catch (IllegalArgumentException e) {
            return this.parseTimestampWithTimezone(inStr);
        }
    }

    private TimestampWithTimezone parseTimestampWithTimezone(String inStr) throws ConnectorException {
        int lastSpace = inStr.lastIndexOf(32);
        if (lastSpace >= 0) {
            String tzOffset = inStr.substring(lastSpace + 1);
            String partialSeconds = null;
            int decimalIndex = inStr.lastIndexOf(".", lastSpace);
            if (decimalIndex >= 0) {
                partialSeconds = inStr.substring(decimalIndex + 1, lastSpace);
            } else {
                decimalIndex = lastSpace;
            }
            Timestamp readts = Timestamp.valueOf(inStr.substring(0, decimalIndex));
            TimeZone tz = this.parseTimezoneOffset(tzOffset);
            int nanos = this.parseNanos(partialSeconds.trim());
            readts.setNanos(nanos);
            TimestampWithTimezone tstz = new TimestampWithTimezone((Date)readts, tz);
            return tstz;
        }
        throw new ConnectorException(JDBCPlugin.Util.getString("StringToTimestampWithTimeZoneTransform", (Object)inStr));
    }

    private TimeZone parseTimezoneOffset(String tzOffset) {
        return TimeZone.getTimeZone("GMT" + tzOffset);
    }

    private int parseNanos(String partialSeconds) {
        int digits = partialSeconds.length();
        int rawValue = Integer.parseInt(partialSeconds);
        return (int)((double)rawValue * Math.pow(10.0, 9 - digits));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

