/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Descriptor {
    public static final String VOID_ = "V";
    public static final String BYTE_ = "B";
    public static final String CHAR_ = "C";
    public static final String DOUBLE_ = "D";
    public static final String FLOAT_ = "F";
    public static final String INT_ = "I";
    public static final String LONG_ = "J";
    public static final String SHORT_ = "S";
    public static final String BOOLEAN_ = "Z";
    public static final String OBJECT = "Ljava/lang/Object;";
    public static final String STRING = "Ljava/lang/String;";
    public static final String STRING_BUFFER = "Ljava/lang/StringBuffer;";
    public static final String STRING_BUILDER = "Ljava/lang/StringBuilder;";
    public static final String CLASS = "Ljava/lang/Class;";
    public static final String THROWABLE = "Ljava/lang/Throwable;";
    public static final String RUNTIME_EXCEPTION = "Ljava/lang/RuntimeException;";
    public static final String ERROR = "Ljava/lang/Error;";
    public static final String CLONEABLE = "Ljava/lang/Cloneable;";
    public static final String SERIALIZABLE = "Ljava/io/Serializable;";
    public static final String BOOLEAN = "Ljava/lang/Boolean;";
    public static final String BYTE = "Ljava/lang/Byte;";
    public static final String CHARACTER = "Ljava/lang/Character;";
    public static final String SHORT = "Ljava/lang/Short;";
    public static final String INTEGER = "Ljava/lang/Integer;";
    public static final String LONG = "Ljava/lang/Long;";
    public static final String FLOAT = "Ljava/lang/Float;";
    public static final String DOUBLE = "Ljava/lang/Double;";
    private static final Map classNameToDescriptor = new HashMap();
    private static final Map descriptorToClassName = new HashMap();

    static {
        descriptorToClassName.put(VOID_, "void");
        descriptorToClassName.put(BYTE_, "byte");
        descriptorToClassName.put(CHAR_, "char");
        descriptorToClassName.put(DOUBLE_, "double");
        descriptorToClassName.put(FLOAT_, "float");
        descriptorToClassName.put(INT_, "int");
        descriptorToClassName.put(LONG_, "long");
        descriptorToClassName.put(SHORT_, "short");
        descriptorToClassName.put(BOOLEAN_, "boolean");
        descriptorToClassName.put(OBJECT, "java.lang.Object");
        descriptorToClassName.put(STRING, "java.lang.String");
        descriptorToClassName.put(STRING_BUFFER, "java.lang.StringBuffer");
        descriptorToClassName.put(STRING_BUILDER, "java.lang.StringBuilder");
        descriptorToClassName.put(CLASS, "java.lang.Class");
        descriptorToClassName.put(THROWABLE, "java.lang.Throwable");
        descriptorToClassName.put(RUNTIME_EXCEPTION, "java.lang.RuntimeException");
        descriptorToClassName.put(ERROR, "java.lang.Error");
        descriptorToClassName.put(CLONEABLE, "java.lang.Cloneable");
        descriptorToClassName.put(SERIALIZABLE, "java.io.Serializable");
        descriptorToClassName.put(BOOLEAN, "java.lang.Boolean");
        descriptorToClassName.put(BYTE, "java.lang.Byte");
        descriptorToClassName.put(CHARACTER, "java.lang.Character");
        descriptorToClassName.put(SHORT, "java.lang.Short");
        descriptorToClassName.put(INTEGER, "java.lang.Integer");
        descriptorToClassName.put(LONG, "java.lang.Long");
        descriptorToClassName.put(FLOAT, "java.lang.Float");
        descriptorToClassName.put(DOUBLE, "java.lang.Double");
        Iterator iterator = descriptorToClassName.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            classNameToDescriptor.put(entry.getValue(), entry.getKey());
        }
    }

    public static boolean areInSamePackage(String string, String string2) {
        String string3 = Descriptor.getPackageName(string);
        String string4 = Descriptor.getPackageName(string2);
        return string3 == null ? string4 == null : string3.equals(string4);
    }

    public static String fromClassName(String string) {
        String string2 = (String)classNameToDescriptor.get(string);
        if (string2 != null) {
            return string2;
        }
        if (string.startsWith("[")) {
            return string.replace('.', '/');
        }
        return String.valueOf('L') + string.replace('.', '/') + ';';
    }

    public static String fromInternalForm(String string) {
        if (string.charAt(0) == '[') {
            return string;
        }
        return String.valueOf('L') + string + ';';
    }

    public static String getComponentDescriptor(String string) {
        if (string.charAt(0) != '[') {
            throw new RuntimeException("Cannot determine component descriptor from non-array descriptor \"" + string + "\"");
        }
        return string.substring(1);
    }

    public static String getPackageName(String string) {
        if (string.charAt(0) != 'L') {
            throw new RuntimeException("Attempt to get package name of non-class descriptor \"" + string + "\"");
        }
        int n = string.lastIndexOf(47);
        return n == -1 ? null : string.substring(1, n).replace('/', '.');
    }

    public static boolean hasSize1(String string) {
        if (string.length() == 1) {
            return "BCFISZ".indexOf(string) != -1;
        }
        return Descriptor.isReference(string);
    }

    public static boolean hasSize2(String string) {
        return string.equals(LONG_) || string.equals(DOUBLE_);
    }

    public static boolean isArrayReference(String string) {
        return string.charAt(0) == '[';
    }

    public static boolean isClassOrInterfaceReference(String string) {
        return string.charAt(0) == 'L';
    }

    public static boolean isPrimitive(String string) {
        return string.length() == 1 && "VBCDFIJSZ".indexOf(string.charAt(0)) != -1;
    }

    public static boolean isPrimitiveNumeric(String string) {
        return string.length() == 1 && "BDFIJSC".indexOf(string.charAt(0)) != -1;
    }

    public static boolean isReference(String string) {
        return string.length() > 1;
    }

    public static short size(String string) {
        if (string.equals(VOID_)) {
            return 0;
        }
        if (Descriptor.hasSize1(string)) {
            return 1;
        }
        if (Descriptor.hasSize2(string)) {
            return 2;
        }
        throw new RuntimeException("No size defined for type \"" + Descriptor.toString(string) + "\"");
    }

    public static String toClassName(String string) {
        String string2 = (String)descriptorToClassName.get(string);
        if (string2 != null) {
            return string2;
        }
        char c = string.charAt(0);
        if (c == 'L' && string.endsWith(";")) {
            return string.substring(1, string.length() - 1).replace('/', '.');
        }
        if (c == '[') {
            return string.replace('/', '.');
        }
        throw new RuntimeException("(Invalid field descriptor \"" + string + "\")");
    }

    public static String toInternalForm(String string) {
        if (string.charAt(0) != 'L') {
            throw new RuntimeException("Attempt to convert non-class descriptor \"" + string + "\" into internal form");
        }
        return string.substring(1, string.length() - 1);
    }

    public static String toString(String string) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (string.charAt(0) == '(') {
            ++n;
            stringBuffer.append("(");
            while (n < string.length() && string.charAt(n) != ')') {
                if (n != 1) {
                    stringBuffer.append(", ");
                }
                n = Descriptor.toString(string, n, stringBuffer);
            }
            if (n >= string.length()) {
                throw new RuntimeException("Invalid descriptor \"" + string + "\"");
            }
            stringBuffer.append(") => ");
            ++n;
        }
        Descriptor.toString(string, n, stringBuffer);
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static int toString(String var0, int var1_1, StringBuffer var2_2) {
        var3_3 = 0;
        while (var1_1 < var0.length() && var0.charAt(var1_1) == '[') {
            ++var3_3;
            ++var1_1;
        }
        if (var1_1 >= var0.length()) {
            throw new RuntimeException("Invalid descriptor \"" + var0 + "\"");
        }
        switch (var0.charAt(var1_1)) {
            case 'L': {
                var4_4 = var0.indexOf(59, var1_1);
                if (var4_4 == -1) {
                    throw new RuntimeException("Invalid descriptor \"" + var0 + "\"");
                }
                var2_2.append(var0.substring(var1_1 + 1, var4_4).replace('/', '.'));
                var1_1 = var4_4;
                ** GOTO lbl59
            }
            case 'V': {
                var2_2.append("void");
                ** GOTO lbl59
            }
            case 'B': {
                var2_2.append("byte");
                ** GOTO lbl59
            }
            case 'C': {
                var2_2.append("char");
                ** GOTO lbl59
            }
            case 'D': {
                var2_2.append("double");
                ** GOTO lbl59
            }
            case 'F': {
                var2_2.append("float");
                ** GOTO lbl59
            }
            case 'I': {
                var2_2.append("int");
                ** GOTO lbl59
            }
            case 'J': {
                var2_2.append("long");
                ** GOTO lbl59
            }
            case 'S': {
                var2_2.append("short");
                ** GOTO lbl59
            }
            case 'Z': {
                var2_2.append("boolean");
                if (true) ** GOTO lbl59
            }
            default: {
                throw new RuntimeException("Invalid descriptor \"" + var0 + "\"");
            }
        }
        do {
            var2_2.append("[]");
            --var3_3;
lbl59:
            // 11 sources

        } while (var3_3 > 0);
        return var1_1 + 1;
    }
}

