/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AstUtil;
import org.aspectj.ajdt.internal.compiler.lookup.AjLookupEnvironment;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseResolvedMember;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseShadow;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseSourceType;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseTypeMunger;
import org.aspectj.ajdt.internal.compiler.lookup.HelperInterfaceBinding;
import org.aspectj.ajdt.internal.core.builder.AjBuildManager;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SyntheticFieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.BoundedReferenceType;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.MemberKind;
import org.aspectj.weaver.NameMangler;
import org.aspectj.weaver.NewFieldTypeMunger;
import org.aspectj.weaver.NewMethodTypeMunger;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.TypeFactory;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.TypeVariableDeclaringElement;
import org.aspectj.weaver.TypeVariableReference;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.UnresolvedTypeVariableReferenceType;
import org.aspectj.weaver.WildcardedUnresolvedType;
import org.aspectj.weaver.World;

public class EclipseFactory {
    public static boolean DEBUG = false;
    public static int debug_mungerCount = -1;
    private final AjBuildManager buildManager;
    private final LookupEnvironment lookupEnvironment;
    private final boolean xSerializableAspects;
    private final World world;
    public Collection finishedTypeMungers = null;
    private final Map typexToBinding = new HashMap();
    private final Map rawTypeXToBinding = new HashMap();
    private static Map typeVariableBindingsInProgress = new HashMap();
    private final Map typeVariablesForThisMember = new HashMap();
    private Map typeVariablesForAliasRecovery;
    private ReferenceBinding baseTypeForParameterizedType;
    private int indexOfTypeParameterBeingConverted;
    private ReferenceBinding currentType = null;
    private final Map typeVariableToTypeBinding = new HashMap();

    public static EclipseFactory fromLookupEnvironment(LookupEnvironment env) {
        AjLookupEnvironment aenv = (AjLookupEnvironment)env;
        return aenv.factory;
    }

    public static EclipseFactory fromScopeLookupEnvironment(Scope scope) {
        return EclipseFactory.fromLookupEnvironment(AstUtil.getCompilationUnitScope((Scope)scope).environment);
    }

    public EclipseFactory(LookupEnvironment lookupEnvironment, AjBuildManager buildManager) {
        this.lookupEnvironment = lookupEnvironment;
        this.buildManager = buildManager;
        this.world = buildManager.getWorld();
        this.xSerializableAspects = buildManager.buildConfig.isXserializableAspects();
    }

    public EclipseFactory(LookupEnvironment lookupEnvironment, World world, boolean xSer) {
        this.lookupEnvironment = lookupEnvironment;
        this.world = world;
        this.xSerializableAspects = xSer;
        this.buildManager = null;
    }

    public World getWorld() {
        return this.world;
    }

    public void showMessage(IMessage.Kind kind, String message, ISourceLocation loc1, ISourceLocation loc2) {
        this.getWorld().showMessage(kind, message, loc1, loc2);
    }

    public ResolvedType fromEclipse(ReferenceBinding binding) {
        if (binding == null) {
            return ResolvedType.MISSING;
        }
        ResolvedType ret = this.getWorld().resolve(this.fromBinding(binding));
        return ret;
    }

    public ResolvedType fromTypeBindingToRTX(TypeBinding tb) {
        if (tb == null) {
            return ResolvedType.MISSING;
        }
        ResolvedType ret = this.getWorld().resolve(this.fromBinding(tb));
        return ret;
    }

    public ResolvedType[] fromEclipse(ReferenceBinding[] bindings) {
        if (bindings == null) {
            return ResolvedType.NONE;
        }
        int len = bindings.length;
        ResolvedType[] ret = new ResolvedType[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.fromEclipse(bindings[i]);
        }
        return ret;
    }

    public static String getName(TypeBinding binding) {
        if (binding instanceof TypeVariableBinding) {
            TypeVariableBinding tvb = (TypeVariableBinding)binding;
            if (tvb.firstBound != null) {
                return EclipseFactory.getName(tvb.firstBound);
            }
            return EclipseFactory.getName(tvb.superclass);
        }
        if (binding instanceof ReferenceBinding) {
            return new String(CharOperation.concatWith(((ReferenceBinding)binding).compoundName, '.'));
        }
        String packageName = new String(binding.qualifiedPackageName());
        String className = new String(binding.qualifiedSourceName()).replace('.', '$');
        if (packageName.length() > 0) {
            className = packageName + "." + className;
        }
        return new String(className);
    }

    public UnresolvedType fromBinding(TypeBinding binding) {
        if (binding instanceof HelperInterfaceBinding) {
            return ((HelperInterfaceBinding)binding).getTypeX();
        }
        if (binding == null || binding.qualifiedSourceName() == null) {
            return ResolvedType.MISSING;
        }
        if (binding instanceof TypeVariableBinding) {
            TypeVariableBinding tb = (TypeVariableBinding)binding;
            UnresolvedTypeVariableReferenceType utvrt = (UnresolvedTypeVariableReferenceType)this.fromTypeVariableBinding(tb);
            return utvrt;
        }
        if (binding instanceof ArrayBinding) {
            ArrayBinding aBinding = (ArrayBinding)binding;
            UnresolvedType componentType = this.fromBinding(aBinding.leafComponentType);
            return UnresolvedType.makeArray(componentType, aBinding.dimensions);
        }
        if (binding instanceof WildcardBinding) {
            WildcardBinding eWB = (WildcardBinding)binding;
            UnresolvedType theBound = null;
            theBound = eWB.bound instanceof TypeVariableBinding ? this.fromTypeVariableBinding((TypeVariableBinding)eWB.bound) : this.fromBinding(eWB.bound);
            WildcardedUnresolvedType theType = (WildcardedUnresolvedType)TypeFactory.createTypeFromSignature(CharOperation.charToString(eWB.genericTypeSignature()));
            return theType;
        }
        if (binding instanceof ParameterizedTypeBinding) {
            if (binding instanceof RawTypeBinding) {
                return UnresolvedType.forRawTypeName(EclipseFactory.getName(binding));
            }
            ParameterizedTypeBinding ptb = (ParameterizedTypeBinding)binding;
            UnresolvedType[] arguments = null;
            if (ptb.arguments != null) {
                arguments = new UnresolvedType[ptb.arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    arguments[i] = this.fromBinding(ptb.arguments[i]);
                }
            }
            String baseTypeSignature = null;
            ResolvedType baseType = this.getWorld().resolve(UnresolvedType.forName(EclipseFactory.getName(binding)), true);
            baseTypeSignature = !baseType.isMissing() ? baseType.getErasureSignature() : UnresolvedType.forName(EclipseFactory.getName(binding)).getSignature();
            if (arguments == null) {
                arguments = new UnresolvedType[]{};
            }
            return TypeFactory.createUnresolvedParameterizedType(baseTypeSignature, arguments);
        }
        if (binding.isGenericType() && !binding.isParameterizedType() && !binding.isRawType()) {
            TypeVariableBinding[] tvbs = binding.typeVariables();
            TypeVariable[] tVars = new TypeVariable[tvbs.length];
            for (int i = 0; i < tvbs.length; ++i) {
                TypeVariableBinding eclipseV = tvbs[i];
                tVars[i] = ((TypeVariableReference)((Object)this.fromTypeVariableBinding(eclipseV))).getTypeVariable();
            }
            if (!(binding instanceof SourceTypeBinding)) {
                throw new RuntimeException("Cant get the generic sig for " + binding.debugName());
            }
            return UnresolvedType.forGenericType(EclipseFactory.getName(binding), tVars, CharOperation.charToString(((SourceTypeBinding)binding).genericSignature()));
        }
        if (binding instanceof LocalTypeBinding) {
            LocalTypeBinding ltb = (LocalTypeBinding)binding;
            if (ltb.constantPoolName() != null && ltb.constantPoolName().length > 0) {
                return UnresolvedType.forSignature(new String(binding.signature()));
            }
            return UnresolvedType.forSignature(new String(ltb.enclosingType.signature()));
        }
        UnresolvedType ut = UnresolvedType.forSignature(new String(binding.signature()));
        return ut;
    }

    private UnresolvedType fromTypeVariableBinding(TypeVariableBinding aTypeVariableBinding) {
        String aliasname;
        if (typeVariableBindingsInProgress.containsKey(aTypeVariableBinding)) {
            return (UnresolvedType)typeVariableBindingsInProgress.get(aTypeVariableBinding);
        }
        if (this.typeVariablesForAliasRecovery != null && (aliasname = (String)this.typeVariablesForAliasRecovery.get(aTypeVariableBinding)) != null) {
            UnresolvedTypeVariableReferenceType ret = new UnresolvedTypeVariableReferenceType();
            ret.setTypeVariable(new TypeVariable(aliasname));
            return ret;
        }
        if (this.typeVariablesForThisMember.containsKey(new String(aTypeVariableBinding.sourceName))) {
            return (UnresolvedType)this.typeVariablesForThisMember.get(new String(aTypeVariableBinding.sourceName));
        }
        String name = CharOperation.charToString(aTypeVariableBinding.sourceName());
        UnresolvedTypeVariableReferenceType ret = new UnresolvedTypeVariableReferenceType();
        typeVariableBindingsInProgress.put(aTypeVariableBinding, ret);
        TypeVariable tv = new TypeVariable(name);
        ret.setTypeVariable(tv);
        UnresolvedType superclassType = this.fromBinding(aTypeVariableBinding.superclass());
        UnresolvedType[] superinterfaces = new UnresolvedType[aTypeVariableBinding.superInterfaces.length];
        for (int i = 0; i < superinterfaces.length; ++i) {
            superinterfaces[i] = this.fromBinding(aTypeVariableBinding.superInterfaces[i]);
        }
        tv.setUpperBound(superclassType);
        tv.setAdditionalInterfaceBounds(superinterfaces);
        tv.setRank(aTypeVariableBinding.rank);
        if (aTypeVariableBinding.declaringElement instanceof MethodBinding) {
            tv.setDeclaringElementKind(1);
        } else {
            tv.setDeclaringElementKind(2);
        }
        if (aTypeVariableBinding.declaringElement instanceof MethodBinding) {
            this.typeVariablesForThisMember.put(new String(aTypeVariableBinding.sourceName), ret);
        }
        typeVariableBindingsInProgress.remove(aTypeVariableBinding);
        return ret;
    }

    public UnresolvedType[] fromBindings(TypeBinding[] bindings) {
        if (bindings == null) {
            return UnresolvedType.NONE;
        }
        int len = bindings.length;
        UnresolvedType[] ret = new UnresolvedType[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.fromBinding(bindings[i]);
        }
        return ret;
    }

    public static ASTNode astForLocation(IHasPosition location) {
        return new EmptyStatement(location.getStart(), location.getEnd());
    }

    public Collection getDeclareParents() {
        return this.getWorld().getDeclareParents();
    }

    public Collection getDeclareAnnotationOnTypes() {
        return this.getWorld().getDeclareAnnotationOnTypes();
    }

    public Collection getDeclareAnnotationOnFields() {
        return this.getWorld().getDeclareAnnotationOnFields();
    }

    public Collection getDeclareAnnotationOnMethods() {
        return this.getWorld().getDeclareAnnotationOnMethods();
    }

    public boolean areTypeMungersFinished() {
        return this.finishedTypeMungers != null;
    }

    public void finishTypeMungers() {
        ArrayList<EclipseTypeMunger> ret = new ArrayList<EclipseTypeMunger>();
        List<ConcreteTypeMunger> baseTypeMungers = this.getWorld().getCrosscuttingMembersSet().getTypeMungers();
        debug_mungerCount = baseTypeMungers.size();
        Iterator i = baseTypeMungers.iterator();
        while (i.hasNext()) {
            ConcreteTypeMunger munger = (ConcreteTypeMunger)i.next();
            EclipseTypeMunger etm = this.makeEclipseTypeMunger(munger);
            if (etm == null) continue;
            ret.add(etm);
        }
        this.finishedTypeMungers = ret;
    }

    public EclipseTypeMunger makeEclipseTypeMunger(ConcreteTypeMunger concrete) {
        if (concrete.getMunger() != null && EclipseTypeMunger.supportsKind(concrete.getMunger().getKind())) {
            EclipseTypeMunger ret;
            AbstractMethodDeclaration method = null;
            if (concrete instanceof EclipseTypeMunger) {
                method = ((EclipseTypeMunger)concrete).getSourceMethod();
            }
            if ((ret = new EclipseTypeMunger(this, concrete.getMunger(), concrete.getAspectType(), method)).getSourceLocation() == null) {
                ret.setSourceLocation(concrete.getSourceLocation());
            }
            return ret;
        }
        return null;
    }

    public Collection getTypeMungers() {
        return this.finishedTypeMungers;
    }

    public ResolvedMember makeResolvedMember(MethodBinding binding) {
        return this.makeResolvedMember(binding, (TypeBinding)binding.declaringClass);
    }

    public ResolvedMember makeResolvedMember(MethodBinding binding, Shadow.Kind shadowKind) {
        MemberKind memberKind;
        MemberKind memberKind2 = memberKind = binding.isConstructor() ? Member.CONSTRUCTOR : Member.METHOD;
        if (shadowKind == Shadow.AdviceExecution) {
            memberKind = Member.ADVICE;
        }
        return this.makeResolvedMember(binding, binding.declaringClass, memberKind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolvedMember makeResolvedMemberForITD(MethodBinding binding, TypeBinding declaringType, Map recoveryAliases) {
        ResolvedMember result = null;
        try {
            this.typeVariablesForAliasRecovery = recoveryAliases;
            result = this.makeResolvedMember(binding, declaringType);
        }
        finally {
            this.typeVariablesForAliasRecovery = null;
        }
        return result;
    }

    public ResolvedMember makeResolvedMember(MethodBinding binding, TypeBinding declaringType) {
        return this.makeResolvedMember(binding, declaringType, binding.isConstructor() ? Member.CONSTRUCTOR : Member.METHOD);
    }

    public ResolvedMember makeResolvedMember(MethodBinding binding, TypeBinding declaringType, MemberKind memberKind) {
        ResolvedType realDeclaringType;
        UnresolvedType[] ajTypeRefs = null;
        this.typeVariablesForThisMember.clear();
        if (binding.typeVariables != null) {
            ajTypeRefs = new UnresolvedType[binding.typeVariables.length];
            for (int i = 0; i < binding.typeVariables.length; ++i) {
                ajTypeRefs[i] = this.fromBinding(binding.typeVariables[i]);
                this.typeVariablesForThisMember.put(new String(binding.typeVariables[i].sourceName), ajTypeRefs[i]);
            }
        }
        if ((realDeclaringType = this.world.resolve(this.fromBinding(declaringType))).isRawType()) {
            realDeclaringType = realDeclaringType.getGenericType();
        }
        EclipseResolvedMember ret = new EclipseResolvedMember(binding, memberKind, realDeclaringType, binding.modifiers, this.fromBinding(binding.returnType), new String(binding.selector), this.fromBindings(binding.parameters), this.fromBindings(binding.thrownExceptions), this);
        if (binding.isVarargs()) {
            ret.setVarargsMethod();
        }
        if (ajTypeRefs != null) {
            TypeVariable[] tVars = new TypeVariable[ajTypeRefs.length];
            for (int i = 0; i < ajTypeRefs.length; ++i) {
                tVars[i] = ((TypeVariableReference)((Object)ajTypeRefs[i])).getTypeVariable();
            }
            ret.setTypeVariables(tVars);
        }
        this.typeVariablesForThisMember.clear();
        ret.resolve(this.world);
        return ret;
    }

    public ResolvedMember makeResolvedMember(FieldBinding binding) {
        return this.makeResolvedMember(binding, (TypeBinding)binding.declaringClass);
    }

    public ResolvedMember makeResolvedMember(FieldBinding binding, TypeBinding receiverType) {
        ResolvedType realDeclaringType = this.world.resolve(this.fromBinding(receiverType));
        if (realDeclaringType.isRawType()) {
            realDeclaringType = realDeclaringType.getGenericType();
        }
        EclipseResolvedMember ret = new EclipseResolvedMember(binding, Member.FIELD, realDeclaringType, binding.modifiers, this.world.resolve(this.fromBinding(binding.type)), new String(binding.name), UnresolvedType.NONE);
        return ret;
    }

    public TypeBinding makeTypeBinding(UnresolvedType typeX) {
        TypeBinding ret = null;
        if (!typeX.isTypeVariableReference() && !this.isParameterizedWithTypeVariables(typeX)) {
            ret = typeX.isRawType() ? (TypeBinding)this.rawTypeXToBinding.get(typeX) : (TypeBinding)this.typexToBinding.get(typeX);
        }
        if (ret == null) {
            ret = this.makeTypeBinding1(typeX);
            if (!(typeX instanceof BoundedReferenceType) && !(typeX instanceof UnresolvedTypeVariableReferenceType)) {
                if (typeX.isRawType()) {
                    this.rawTypeXToBinding.put(typeX, ret);
                } else {
                    this.typexToBinding.put(typeX, ret);
                }
            }
        }
        if (ret == null) {
            System.out.println("can't find: " + typeX);
        }
        return ret;
    }

    private boolean isParameterizedWithTypeVariables(UnresolvedType typeX) {
        if (!typeX.isParameterizedType()) {
            return false;
        }
        UnresolvedType[] typeArguments = typeX.getTypeParameters();
        if (typeArguments != null) {
            for (int i = 0; i < typeArguments.length; ++i) {
                if (!typeArguments[i].isTypeVariableReference()) continue;
                return true;
            }
        }
        return false;
    }

    private TypeBinding makeTypeBinding1(UnresolvedType typeX) {
        if (typeX.isPrimitiveType()) {
            if (typeX == ResolvedType.BOOLEAN) {
                return TypeBinding.BOOLEAN;
            }
            if (typeX == ResolvedType.BYTE) {
                return TypeBinding.BYTE;
            }
            if (typeX == ResolvedType.CHAR) {
                return TypeBinding.CHAR;
            }
            if (typeX == ResolvedType.DOUBLE) {
                return TypeBinding.DOUBLE;
            }
            if (typeX == ResolvedType.FLOAT) {
                return TypeBinding.FLOAT;
            }
            if (typeX == ResolvedType.INT) {
                return TypeBinding.INT;
            }
            if (typeX == ResolvedType.LONG) {
                return TypeBinding.LONG;
            }
            if (typeX == ResolvedType.SHORT) {
                return TypeBinding.SHORT;
            }
            if (typeX == ResolvedType.VOID) {
                return TypeBinding.VOID;
            }
            throw new RuntimeException("weird primitive type " + typeX);
        }
        if (typeX.isArray()) {
            int dim = 0;
            while (typeX.isArray()) {
                ++dim;
                typeX = typeX.getComponentType();
            }
            return this.lookupEnvironment.createArrayType(this.makeTypeBinding(typeX), dim);
        }
        if (typeX.isParameterizedType()) {
            UnresolvedType[] typeParameters = typeX.getTypeParameters();
            ReferenceBinding baseTypeBinding = this.lookupBinding(typeX.getBaseName());
            TypeBinding[] argumentBindings = new TypeBinding[typeParameters.length];
            this.baseTypeForParameterizedType = baseTypeBinding;
            for (int i = 0; i < argumentBindings.length; ++i) {
                this.indexOfTypeParameterBeingConverted = i;
                argumentBindings[i] = this.makeTypeBinding(typeParameters[i]);
            }
            this.indexOfTypeParameterBeingConverted = 0;
            this.baseTypeForParameterizedType = null;
            ParameterizedTypeBinding ptb = this.lookupEnvironment.createParameterizedType(baseTypeBinding, argumentBindings, baseTypeBinding.enclosingType());
            return ptb;
        }
        if (typeX.isTypeVariableReference()) {
            return this.makeTypeVariableBindingFromAJTypeVariable(((TypeVariableReference)((Object)typeX)).getTypeVariable());
        }
        if (typeX.isRawType()) {
            ReferenceBinding baseTypeBinding = this.lookupBinding(typeX.getBaseName());
            RawTypeBinding rtb = this.lookupEnvironment.createRawType(baseTypeBinding, baseTypeBinding.enclosingType());
            return rtb;
        }
        if (typeX.isGenericWildcard()) {
            if (typeX instanceof WildcardedUnresolvedType) {
                WildcardedUnresolvedType wut = (WildcardedUnresolvedType)typeX;
                int boundkind = 0;
                TypeBinding bound = null;
                if (wut.isExtends()) {
                    boundkind = 1;
                    bound = this.makeTypeBinding(wut.getUpperBound());
                } else if (wut.isSuper()) {
                    boundkind = 2;
                    bound = this.makeTypeBinding(wut.getLowerBound());
                }
                TypeBinding[] otherBounds = null;
                WildcardBinding wb = this.lookupEnvironment.createWildcard(this.baseTypeForParameterizedType, this.indexOfTypeParameterBeingConverted, bound, otherBounds, boundkind);
                return wb;
            }
            if (typeX instanceof BoundedReferenceType) {
                BoundedReferenceType brt = (BoundedReferenceType)typeX;
                int boundkind = 0;
                TypeBinding bound = null;
                if (brt.isExtends()) {
                    boundkind = 1;
                    bound = this.makeTypeBinding(brt.getUpperBound());
                } else if (brt.isSuper()) {
                    boundkind = 2;
                    bound = this.makeTypeBinding(brt.getLowerBound());
                }
                TypeBinding[] otherBounds = null;
                if (brt.getAdditionalBounds() != null && brt.getAdditionalBounds().length != 0) {
                    otherBounds = this.makeTypeBindings(brt.getAdditionalBounds());
                }
                WildcardBinding wb = this.lookupEnvironment.createWildcard(this.baseTypeForParameterizedType, this.indexOfTypeParameterBeingConverted, bound, otherBounds, boundkind);
                return wb;
            }
            throw new BCException("This type " + typeX + " (class " + typeX.getClass().getName() + ") should not be claiming to be a wildcard!");
        }
        return this.lookupBinding(typeX.getName());
    }

    private ReferenceBinding lookupBinding(String sname) {
        char[][] name = CharOperation.splitOn('.', sname.toCharArray());
        ReferenceBinding rb = this.lookupEnvironment.getType(name);
        return rb;
    }

    public TypeBinding[] makeTypeBindings(UnresolvedType[] types) {
        int len = types.length;
        TypeBinding[] ret = new TypeBinding[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.makeTypeBinding(types[i]);
        }
        return ret;
    }

    private ReferenceBinding[] makeReferenceBindings(UnresolvedType[] types) {
        int len = types.length;
        ReferenceBinding[] ret = new ReferenceBinding[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = (ReferenceBinding)this.makeTypeBinding(types[i]);
        }
        return ret;
    }

    public FieldBinding makeFieldBinding(NewFieldTypeMunger nftm) {
        return this.internalMakeFieldBinding(nftm.getSignature(), nftm.getTypeVariableAliases());
    }

    public FieldBinding makeFieldBinding(ResolvedMember member, List aliases) {
        return this.internalMakeFieldBinding(member, aliases);
    }

    public FieldBinding makeFieldBinding(ResolvedMember member) {
        return this.internalMakeFieldBinding(member, null);
    }

    public SyntheticFieldBinding createSyntheticFieldBinding(SourceTypeBinding owningType, ResolvedMember member) {
        SyntheticFieldBinding sfb = new SyntheticFieldBinding(member.getName().toCharArray(), this.makeTypeBinding(member.getReturnType()), member.getModifiers() | 0x1000, owningType, Constant.NotAConstant, -1);
        owningType.addSyntheticField(sfb);
        return sfb;
    }

    public FieldBinding internalMakeFieldBinding(ResolvedMember member, List aliases) {
        this.typeVariableToTypeBinding.clear();
        ReferenceBinding declaringType = (ReferenceBinding)this.makeTypeBinding(member.getDeclaringType());
        if (aliases != null && aliases.size() > 0 && declaringType.typeVariables() != null && declaringType.typeVariables().length != 0) {
            int i = 0;
            Iterator iter = aliases.iterator();
            while (iter.hasNext()) {
                String element = (String)iter.next();
                this.typeVariableToTypeBinding.put(element, declaringType.typeVariables()[i++]);
            }
        }
        this.currentType = declaringType;
        FieldBinding fb = null;
        fb = member.getName().startsWith("ajc$") ? new SyntheticFieldBinding(member.getName().toCharArray(), this.makeTypeBinding(member.getReturnType()), member.getModifiers() | 0x1000, this.currentType, Constant.NotAConstant, -1) : new FieldBinding(member.getName().toCharArray(), this.makeTypeBinding(member.getReturnType()), member.getModifiers(), this.currentType, Constant.NotAConstant);
        this.typeVariableToTypeBinding.clear();
        this.currentType = null;
        if (member.getName().startsWith("ajc$")) {
            fb.modifiers |= 0x1000;
        }
        return fb;
    }

    public MethodBinding makeMethodBinding(NewMethodTypeMunger nmtm) {
        return this.internalMakeMethodBinding(nmtm.getSignature(), nmtm.getTypeVariableAliases());
    }

    public MethodBinding makeMethodBinding(ResolvedMember member, List aliases) {
        return this.internalMakeMethodBinding(member, aliases);
    }

    public MethodBinding makeMethodBinding(ResolvedMember member, List aliases, UnresolvedType aliasTargetType) {
        return this.internalMakeMethodBinding(member, aliases, aliasTargetType);
    }

    public MethodBinding makeMethodBinding(ResolvedMember member) {
        return this.internalMakeMethodBinding(member, null);
    }

    public MethodBinding internalMakeMethodBinding(ResolvedMember member, List aliases) {
        return this.internalMakeMethodBinding(member, aliases, member.getDeclaringType());
    }

    public MethodBinding internalMakeMethodBinding(ResolvedMember member, List aliases, UnresolvedType aliasTargetType) {
        this.typeVariableToTypeBinding.clear();
        TypeVariableBinding[] tvbs = null;
        if (member.getTypeVariables() != null) {
            tvbs = member.getTypeVariables().length == 0 ? Binding.NO_TYPE_VARIABLES : this.makeTypeVariableBindingsFromAJTypeVariables(member.getTypeVariables());
        }
        ReferenceBinding declaringType = (ReferenceBinding)this.makeTypeBinding(member.getDeclaringType());
        if (aliases != null && aliases.size() != 0 && declaringType.typeVariables() != null && declaringType.typeVariables().length != 0) {
            int i = 0;
            ReferenceBinding aliasTarget = (ReferenceBinding)this.makeTypeBinding(aliasTargetType);
            if (aliasTarget.isRawType()) {
                aliasTarget = ((RawTypeBinding)aliasTarget).genericType();
            }
            Iterator iter = aliases.iterator();
            while (iter.hasNext()) {
                String element = (String)iter.next();
                this.typeVariableToTypeBinding.put(element, aliasTarget.typeVariables()[i++]);
            }
        }
        this.currentType = declaringType;
        MethodBinding mb = new MethodBinding(member.getModifiers(), member.getName().toCharArray(), this.makeTypeBinding(member.getReturnType()), this.makeTypeBindings(member.getParameterTypes()), this.makeReferenceBindings(member.getExceptions()), declaringType);
        if (tvbs != null) {
            mb.typeVariables = tvbs;
        }
        this.typeVariableToTypeBinding.clear();
        this.currentType = null;
        if (NameMangler.isSyntheticMethod(member.getName(), true)) {
            mb.modifiers |= 0x1000;
        }
        return mb;
    }

    private TypeVariableBinding[] makeTypeVariableBindingsFromAJTypeVariables(TypeVariable[] typeVariables) {
        int len = typeVariables.length;
        TypeVariableBinding[] ret = new TypeVariableBinding[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.makeTypeVariableBindingFromAJTypeVariable(typeVariables[i]);
        }
        return ret;
    }

    private TypeVariableBinding makeTypeVariableBindingFromAJTypeVariable(TypeVariable tv) {
        TypeVariableBinding tvb;
        TypeVariableBinding tvBinding = (TypeVariableBinding)this.typeVariableToTypeBinding.get(tv.getName());
        if (this.currentType != null && (tvb = this.currentType.getTypeVariable(tv.getName().toCharArray())) != null) {
            return tvb;
        }
        if (tvBinding == null) {
            Binding declaringElement = null;
            tvBinding = new TypeVariableBinding(tv.getName().toCharArray(), declaringElement, tv.getRank());
            this.typeVariableToTypeBinding.put(tv.getName(), tvBinding);
            tvBinding.superclass = (ReferenceBinding)this.makeTypeBinding(tv.getUpperBound());
            tvBinding.firstBound = this.makeTypeBinding(tv.getFirstBound());
            if (tv.getAdditionalInterfaceBounds() == null) {
                tvBinding.superInterfaces = Binding.NO_SUPERINTERFACES;
            } else {
                TypeBinding[] tbs = this.makeTypeBindings(tv.getAdditionalInterfaceBounds());
                ReferenceBinding[] rbs = new ReferenceBinding[tbs.length];
                for (int i = 0; i < tbs.length; ++i) {
                    rbs[i] = (ReferenceBinding)tbs[i];
                }
                tvBinding.superInterfaces = rbs;
            }
        }
        return tvBinding;
    }

    public MethodBinding makeMethodBindingForCall(Member member) {
        return new MethodBinding(member.getModifiers() & 0xFFFFFDFF, member.getName().toCharArray(), this.makeTypeBinding(member.getReturnType()), this.makeTypeBindings(member.getParameterTypes()), new ReferenceBinding[0], (ReferenceBinding)this.makeTypeBinding(member.getDeclaringType()));
    }

    public void finishedCompilationUnit(CompilationUnitDeclaration unit) {
        if (this.buildManager != null && this.buildManager.doGenerateModel()) {
            AjBuildManager.getAsmHierarchyBuilder().buildStructureForCompilationUnit(unit, this.buildManager.getStructureModel(), this.buildManager.buildConfig);
        }
    }

    public void addTypeBinding(TypeBinding binding) {
        this.typexToBinding.put(this.fromBinding(binding), binding);
    }

    public void addTypeBindingAndStoreInWorld(TypeBinding binding) {
        UnresolvedType ut = this.fromBinding(binding);
        this.typexToBinding.put(ut, binding);
        this.world.lookupOrCreateName(ut);
    }

    public Shadow makeShadow(ASTNode location, ReferenceContext context) {
        return EclipseShadow.makeShadow(this, location, context);
    }

    public Shadow makeShadow(ReferenceContext context) {
        return EclipseShadow.makeShadow(this, (ASTNode)((Object)context), context);
    }

    public void addSourceTypeBinding(SourceTypeBinding binding, CompilationUnitDeclaration unit) {
        LocalTypeBinding ltb;
        TypeDeclaration decl = binding.scope.referenceContext;
        UnresolvedType simpleTx = null;
        simpleTx = binding.isGenericType() ? UnresolvedType.forRawTypeName(EclipseFactory.getName(binding)) : (binding.isLocalType() ? ((ltb = (LocalTypeBinding)binding).constantPoolName() != null && ltb.constantPoolName().length > 0 ? UnresolvedType.forSignature(new String(binding.signature())) : UnresolvedType.forName(EclipseFactory.getName(binding))) : UnresolvedType.forName(EclipseFactory.getName(binding)));
        ReferenceType name = this.getWorld().lookupOrCreateName(simpleTx);
        if (!binding.isRawType() && !binding.isGenericType() && name.getTypekind() == UnresolvedType.TypeKind.RAW) {
            name.demoteToSimpleType();
        }
        EclipseSourceType t = new EclipseSourceType(name, this, binding, decl, unit);
        if (binding.isGenericType()) {
            UnresolvedType complexTx = this.fromBinding(binding);
            ResolvedType cName = this.world.resolve(complexTx, true);
            ReferenceType complexName = null;
            if (!cName.isMissing()) {
                complexName = (ReferenceType)cName;
                if ((complexName = (ReferenceType)complexName.getGenericType()) == null) {
                    complexName = new ReferenceType(complexTx, this.world);
                }
            } else {
                complexName = new ReferenceType(complexTx, this.world);
            }
            name.setGenericType(complexName);
            complexName.setDelegate(t);
        }
        name.setDelegate(t);
        if (decl instanceof AspectDeclaration) {
            ((AspectDeclaration)decl).typeX = name;
            ((AspectDeclaration)decl).concreteName = t;
        }
        ReferenceBinding[] memberTypes = binding.memberTypes;
        int length = memberTypes.length;
        for (int i = 0; i < length; ++i) {
            this.addSourceTypeBinding((SourceTypeBinding)memberTypes[i], unit);
        }
    }

    public boolean isXSerializableAspects() {
        return this.xSerializableAspects;
    }

    public ResolvedMember fromBinding(MethodBinding binding) {
        return new ResolvedMemberImpl(Member.METHOD, this.fromBinding(binding.declaringClass), binding.modifiers, this.fromBinding(binding.returnType), CharOperation.charToString(binding.selector), this.fromBindings(binding.parameters));
    }

    public TypeVariableDeclaringElement fromBinding(Binding declaringElement) {
        if (declaringElement instanceof TypeBinding) {
            return this.fromBinding((TypeBinding)declaringElement);
        }
        return this.fromBinding((MethodBinding)declaringElement);
    }

    public void cleanup() {
        this.typexToBinding.clear();
        this.rawTypeXToBinding.clear();
        this.finishedTypeMungers = null;
    }

    public void minicleanup() {
        this.typexToBinding.clear();
        this.rawTypeXToBinding.clear();
    }
}

