/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.assertion.AssertArgument;
import org.milyn.classpath.Filter;

public class Scanner {
    private static Log logger = LogFactory.getLog(Scanner.class);
    private Filter filter;

    public Scanner(Filter filter) {
        AssertArgument.isNotNull(filter, "filter");
        this.filter = filter;
    }

    public void scanClasspath(ClassLoader classLoader) throws IOException {
        if (!(classLoader instanceof URLClassLoader)) {
            logger.warn((Object)("Not scanning classpath for ClassLoader '" + classLoader.getClass().getName() + "'.  ClassLoader must implement '" + URLClassLoader.class.getName() + "'."));
            return;
        }
        URL[] urls = ((URLClassLoader)classLoader).getURLs();
        HashSet<String> alreadyScanned = new HashSet<String>();
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            File file;
            URL url = uRLArray[n2];
            String urlPath = url.getFile();
            if ((urlPath = URLDecoder.decode(urlPath, "UTF-8")).startsWith("file:")) {
                urlPath = urlPath.substring(5);
            }
            if (urlPath.indexOf(33) > 0) {
                urlPath = urlPath.substring(0, urlPath.indexOf(33));
            }
            if (alreadyScanned.contains((file = new File(urlPath)).getAbsolutePath())) {
                logger.debug((Object)("Ignoring classpath URL '" + file.getAbsolutePath() + "'.  Already scanned this URL."));
            } else {
                if (file.isDirectory()) {
                    this.handleDirectory(file, null);
                } else {
                    this.handleArchive(file);
                }
                alreadyScanned.add(file.getAbsolutePath());
            }
            ++n2;
        }
    }

    private void handleArchive(File file) throws IOException {
        if (this.filter.isIgnorable(file.getName())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignoring archive: " + file));
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Scanning archive: " + file.getAbsolutePath()));
        }
        ZipFile zip = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            this.filter.filter(name);
        }
    }

    private void handleDirectory(File file, String path) {
        if (path != null && this.filter.isIgnorable(path)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignoring directory (and subdirectories): " + path));
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Scanning directory: " + file.getAbsolutePath()));
        }
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            String newPath;
            File child = fileArray[n2];
            String string = newPath = path == null ? child.getName() : String.valueOf(path) + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath);
            } else {
                this.filter.filter(newPath);
            }
            ++n2;
        }
    }
}

