/*
 * Decompiled with CFR 0.152.
 */
package it.javalinux.wise.core.client.handler;

import it.javalinux.wise.core.utils.SmooksCache;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Map;
import java.util.Set;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.milyn.Smooks;
import org.milyn.container.ExecutionContext;
import org.milyn.javabean.BeanAccessor;
import org.milyn.resource.URIResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksHandler
implements SOAPHandler<SOAPMessageContext> {
    private String smooksResource;
    private Map beansMap;
    private boolean outBoundHandlingEnabled = true;
    private boolean inBoundHandlingEnabled = true;

    public SmooksHandler(String resource, Map beans) {
        this.smooksResource = resource;
        this.beansMap = beans;
    }

    public Set getHeaders() {
        return null;
    }

    public void close(MessageContext arg0) {
    }

    public boolean handleFault(SOAPMessageContext arg0) {
        return false;
    }

    public boolean handleMessage(SOAPMessageContext smc) {
        SOAPMessage message = smc.getMessage();
        Boolean outboundProperty = (Boolean)smc.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outboundProperty.booleanValue() && !this.isOutBoundHandlingEnabled()) {
            return false;
        }
        if (!outboundProperty.booleanValue() && !this.isInBoundHandlingEnabled()) {
            return false;
        }
        if (this.smooksResource != null) {
            try {
                smc.setMessage(this.applySmooksTransformation(message));
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SOAPMessage applySmooksTransformation(SOAPMessage message) throws Exception {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            SOAPMessage message2;
            Smooks smooks = SmooksCache.getInstance().get(this.smooksResource);
            if (smooks == null) {
                smooks = new Smooks();
                smooks.addConfigurations("smooks-resource", new URIResourceLocator().getResource(this.smooksResource));
                SmooksCache.getInstance().put(this.smooksResource, smooks);
            }
            ExecutionContext executionContext = smooks.createExecutionContext();
            StringWriter transResult = new StringWriter();
            BeanAccessor.getBeans((ExecutionContext)executionContext).putAll(this.beansMap);
            outStream = new ByteArrayOutputStream();
            message.writeTo((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            smooks.filter((Source)new StreamSource(inStream), (Result)new StreamResult(transResult), executionContext);
            inStream.close();
            inStream = new ByteArrayInputStream(transResult.toString().getBytes());
            SOAPMessage sOAPMessage = message2 = MessageFactory.newInstance().createMessage(message.getMimeHeaders(), (InputStream)inStream);
            return sOAPMessage;
        }
        finally {
            try {
                inStream.close();
            }
            catch (Exception e) {}
            try {
                outStream.close();
            }
            catch (Exception e) {}
        }
    }

    public boolean isOutBoundHandlingEnabled() {
        return this.outBoundHandlingEnabled;
    }

    public void setOutBoundHandlingEnabled(boolean outBoundHandlingEnabled) {
        this.outBoundHandlingEnabled = outBoundHandlingEnabled;
    }

    public boolean isInBoundHandlingEnabled() {
        return this.inBoundHandlingEnabled;
    }

    public void setInBoundHandlingEnabled(boolean inBoundHandlingEnabled) {
        this.inBoundHandlingEnabled = inBoundHandlingEnabled;
    }
}

