/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.filter.LastVersionMatcher;
import edu.umd.cs.findbugs.gui2.BugTreeModel;
import edu.umd.cs.findbugs.gui2.CompoundMatcher;
import edu.umd.cs.findbugs.gui2.Debug;
import edu.umd.cs.findbugs.gui2.FilterActivity;
import edu.umd.cs.findbugs.gui2.FilterListener;
import edu.umd.cs.findbugs.gui2.FilterMatcher;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.PreferencesFrame;
import edu.umd.cs.findbugs.gui2.Sortables;
import edu.umd.cs.findbugs.gui2.StackedFilterMatcher;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.WillClose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class ProjectSettings
implements Serializable {
    private static final long serialVersionUID = 6505872267795979672L;
    private static ProjectSettings instance;
    private ArrayList<FilterMatcher> filters;
    private CompoundMatcher allMatchers = new CompoundMatcher();
    private int maxSizeOfPreviousComments;

    private ProjectSettings() {
        this.filters = new ArrayList();
    }

    public static ProjectSettings newInstance() {
        instance = new ProjectSettings();
        LastVersionMatcher dbf = LastVersionMatcher.DEAD_BUG_MATCHER;
        MainFrame.getInstance().getProject().getSuppressionFilter().addChild(dbf);
        PreferencesFrame.getInstance().updateFilterPanel();
        return instance;
    }

    public static synchronized ProjectSettings getInstance() {
        if (instance == null) {
            instance = new ProjectSettings();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadInstance(@WillClose InputStream in) {
        try {
            instance = (ProjectSettings)new ObjectInputStream(in).readObject();
            PreferencesFrame.getInstance().updateFilterPanel();
        }
        catch (ClassNotFoundException e) {
            if (MainFrame.DEBUG) {
                System.err.println("Error in deserializing Settings:");
            }
            Debug.println(e);
        }
        catch (IOException e) {
            if (MainFrame.DEBUG) {
                System.err.println("IO error in deserializing Settings:");
            }
            Debug.println(e);
            instance = ProjectSettings.newInstance();
        }
        finally {
            block18: {
                try {
                    in.close();
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block18;
                    throw new AssertionError();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(@WillClose OutputStream out) {
        try {
            new ObjectOutputStream(out).writeObject(this);
        }
        catch (IOException e) {
            if (MainFrame.DEBUG) {
                System.err.println("Error serializing Settings:");
            }
            Debug.println(e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Deprecated
    Filter getSuppressionFilter() {
        Project project = MainFrame.getInstance().getProject();
        if (project == null) {
            throw new NullPointerException("project is null");
        }
        return project.getSuppressionFilter();
    }

    public void addFilter(FilterMatcher filter) {
        this.filters.add(filter);
        this.allMatchers.add(filter);
        if (!(filter instanceof StackedFilterMatcher)) {
            FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
        } else {
            StackedFilterMatcher theSame = (StackedFilterMatcher)filter;
            FilterMatcher[] filtersInStack = theSame.getFilters();
            ArrayList<Sortables> order = MainFrame.getInstance().getSorter().getOrder();
            int sizeToCheck = filtersInStack.length;
            List<Sortables> sortablesToCheck = order.subList(0, sizeToCheck);
            Debug.println("Size to check" + sizeToCheck + " checking list" + sortablesToCheck);
            Debug.println("checking filters");
            ArrayList<String> almostPath = new ArrayList<String>();
            ArrayList<Sortables> almostPathSortables = new ArrayList<Sortables>();
            for (int x = 0; x < sortablesToCheck.size(); ++x) {
                Sortables s = sortablesToCheck.get(x);
                for (FilterMatcher fm : filtersInStack) {
                    if (!s.equals(fm.getFilterBy())) continue;
                    almostPath.add(fm.getValue());
                    almostPathSortables.add(fm.getFilterBy());
                }
            }
            if (almostPath.size() == filtersInStack.length) {
                ArrayList<String> finalPath = new ArrayList<String>();
                for (int x = 0; x < almostPath.size(); ++x) {
                    Sortables s = (Sortables)almostPathSortables.get(x);
                    if (!MainFrame.getInstance().getSorter().getOrderBeforeDivider().contains(s)) continue;
                    finalPath.add((String)almostPath.get(x));
                }
                BugTreeModel model = MainFrame.getInstance().getBugTreeModel();
                try {
                    model.sendEvent(model.removeBranch(finalPath), BugTreeModel.TreeModification.REMOVE);
                }
                catch (BugTreeModel.BranchOperationException e) {
                    throw new IllegalStateException("They added a stacked filter on a branch that doesn't exist... Whaa?");
                }
            } else {
                FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
                throw new IllegalStateException("What huh?  How'd they add a stacked filter matcher bigger than the number of branches in the tree?!");
            }
        }
        PreferencesFrame.getInstance().updateFilterPanel();
        MainFrame.getInstance().updateStatusBar();
    }

    public void addFilters(FilterMatcher[] newFilters) {
        for (FilterMatcher i : newFilters) {
            if (!this.filters.contains(i)) {
                this.filters.add(i);
                this.allMatchers.add(i);
                continue;
            }
            this.filters.get(this.filters.indexOf(i)).setActive(true);
        }
        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
        PreferencesFrame.getInstance().updateFilterPanel();
        MainFrame.getInstance().updateStatusBar();
    }

    public boolean removeFilter(FilterMatcher filter) {
        boolean result = this.filters.remove(filter) && this.allMatchers.remove(filter);
        FilterActivity.notifyListeners(FilterListener.Action.UNFILTERING, null);
        PreferencesFrame.getInstance().updateFilterPanel();
        MainFrame.getInstance().updateStatusBar();
        return result;
    }

    ArrayList<FilterMatcher> getAllFilters() {
        return this.filters;
    }

    public int getMaxSizeOfPreviousComments() {
        return this.maxSizeOfPreviousComments;
    }

    public void setMaxSizeOfPreviousComments(int num) {
        this.maxSizeOfPreviousComments = num;
    }
}

