<?xml version="1.0"?>

<!-- 
	This is used to put add the teiid policy into the login-config.xml on the server during EDS installation
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">
	<xsl:output method="xml" version="1.0" encoding="UTF-8"
		indent="yes"
	/>

	<xsl:template match="/policy">
	<xsl:comment>
        EDS Teiid Security domain
  </xsl:comment>
		<policy>
      
      <xsl:for-each select="/policy/*">
        <xsl:if test="@name!='teiid-security'">
              <xsl:comment>Loaded from orignal file: login-config.xml</xsl:comment>
              <xsl:copy-of select="current()"/>
              <xsl:comment>----</xsl:comment>
        </xsl:if>
      </xsl:for-each>
			
			<xsl:comment>EDS Teiid Security Domain</xsl:comment>

			<!-- teiid's default security domain, replace this with your own if needs to be any other JAAS domain  -->
			<application-policy xmlns="urn:jboss:security-beans:1.0" name="teiid-security">
				<authentication>
					<login-module code="org.jboss.security.auth.spi.UsersRolesLoginModule" flag="required">
						<!-- property files can found under conf/props directory -->
						<module-option name="usersProperties">props/teiid-security-users.properties</module-option>
						<module-option name="rolesProperties">props/teiid-security-roles.properties</module-option>
					</login-module>
				</authentication>
			</application-policy>  
		</policy>

	</xsl:template>

	<xsl:template match="/">

		<xsl:apply-templates />
	</xsl:template>

</xsl:stylesheet>
