package org.jboss.soa.esb.samples.quickstart.swift2xml;

import java.io.IOException;
import java.io.ByteArrayInputStream;
import net.sourceforge.wife.swift.parser.SwiftParser;
import net.sourceforge.wife.swift.writer.SwiftWriter;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.AbstractActionLifecycle;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;

import org.jboss.soa.esb.message.Message;

public class Swift2XMLAction extends AbstractActionLifecycle {

	public Swift2XMLAction(ConfigTree config) throws ConfigurationException {

	}

	public Message process(Message msg) throws ActionProcessingException {
	
		ByteArrayInputStream s = new ByteArrayInputStream((byte[]) msg
				.getBody().get());
		SwiftParser parser = new SwiftParser(s);
		SwiftWriter writer = new SwiftWriter();
		try {
			msg.getBody().add(writer.getInternalXml(parser.message()));
		} catch (IOException ioe) {
			throw new ActionProcessingException(ioe);
		}
		return msg;
	}

}
