@MimeType("text/plain")
public class TextPlainMimeDecoder implements MimeDecoder, Configurable {

    private Charset encodingCharset;
    
    public void setConfiguration(ConfigTree configTree) throws ConfigurationException {
        AssertArgument.isNotNull(configTree, "configTree");
        
        String encoding = configTree.getAttribute("encoding", "UTF-8");
        encodingCharset = Charset.forName(encoding);
    }

    public Object decode(byte[] bytes) throws MimeDecodeException {
        try {
            return new String(bytes, encodingCharset.name());
        } catch (UnsupportedEncodingException e) {
            throw new MimeDecodeException("Unexpected character encoding error.", e);
        }
    }
}
