/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.internal.soa.esb.registry.console;

import java.io.IOException;

import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.juddi.v3.client.config.UDDIClerkManager;
import org.apache.juddi.v3.client.config.UDDIClerkServlet;
import org.apache.juddi.v3.client.config.UDDIClientContainer;
import org.apache.juddi.v3.client.config.WebHelper;
import org.apache.log4j.Logger;

/**
 * Simple servlet to initialise the context attributes.
 * @author kevin
 */
public class InitAttributeServlet extends GenericServlet
{
    /**
     * serial version UID for this class
     */
    private static final long serialVersionUID = -2813854722227002890L;

    /**
     * The logger for this class.
     */
    private static final Logger LOGGER = Logger.getLogger(InitAttributeServlet.class) ;
    
    /**
     * Initialise the servlet configuration.
     * @param config The servlet configuration.
     */
    @Override
    public void init(ServletConfig config)
        throws ServletException
    {
        super.init(config) ;
        final String managerName = config.getInitParameter(UDDIClerkServlet.UDDI_CLIENT_MANAGER_NAME) ;
        if (managerName != null)
        {
            final UDDIClerkManager manager ;
            try
            {
                manager = UDDIClientContainer.getUDDIClerkManager(managerName) ;
            }
            catch (final ConfigurationException ce)
            {
                throw new ServletException("Failed to locate manager: " + managerName, ce) ;
            }
            
            if (manager != null)
            {
                if (LOGGER.isInfoEnabled())
                {
                    LOGGER.info("Initialising jUDDI console context with manager " + managerName) ;
                }
                final ServletContext servletContext = config.getServletContext() ;
                servletContext.setAttribute(WebHelper.JUDDI_CLIENT_MANAGER_INSTANCE, manager) ;
            }
        }
    }
    
    @Override
    public void service(final ServletRequest request, final ServletResponse response)
        throws ServletException, IOException
    {
        throw new ServletException("Servlet is only used for specific context initialisation tasks") ;
    }
}
