/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.configure;

import org.jboss.soa.esb.ConfigurationException;

/**
 * Configuration Property decode exception.
 * 
 * @author <a href="mailto:tom.fennelly@gmail.com">tom.fennelly@gmail.com</a>
 */
public class PropertyDecodeException extends ConfigurationException {

	private static final long serialVersionUID = 1L;

	private Class<? extends Object> configuredClass;
	private String propertyName;

	public PropertyDecodeException(String message, Throwable cause) {
		super(message, cause);
	}

	public Class<? extends Object> getConfiguredClass() {
		return configuredClass;
	}

	public void setConfiguredClass(Class<? extends Object> configuredClass) {
		this.configuredClass = configuredClass;
	}

	public String getPropertyName() {
		return propertyName;
	}

	public void setPropertyName(String propertyName) {
		this.propertyName = propertyName;
	}

	@Override
	public String getMessage() {
		if(propertyName != null && configuredClass != null) {
			return "Exception decoding configuration value for property '" + propertyName + "' on class '" + configuredClass.getName() + "': " + super.getMessage();
		} else {
			return super.getMessage();
		}
	}
}