/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2010
 */
package org.jboss.soa.esb.listeners.gateway.camel;

import org.apache.camel.Exchange;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;

/**
 * ServiceProcessor.
 * 
 * @author dward at jboss.org
 */
public class ServiceProcessor extends JBossESBProcessor {
	
	private final Service service;
	private final boolean async;
	private final long timeout;
	
	public ServiceProcessor(ConfigTree config, Service service, boolean async, long timeout) {
		super(config);
		this.service = service;
		this.async = async;
		this.timeout = timeout;
	}
	
	public void process(Exchange exchange) throws Exception {
		org.apache.camel.Message camelMessageIn = exchange.getIn();
		Message esbMessageIn = getComposer().compose(camelMessageIn);
		ServiceInvoker invoker = new ServiceInvoker(service);
		if (async) {
			invoker.deliverAsync(esbMessageIn);
		}
		else {
			Message esbMessageOut = invoker.deliverSync(esbMessageIn, timeout);
			org.apache.camel.Message camelMessageOut = getComposer().decompose(esbMessageOut, camelMessageIn);
			exchange.setOut(camelMessageOut);
		}
	}

}
