/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.listeners.jca;

import java.util.Map;

import org.jboss.soa.esb.ConfigurationException;


/**
 * Mapper interface for configuring standard ESB properties.
 *
 * @author <a href="kevin.conner@jboss.com">Kevin Conner</a>
 */
public interface ActivationMapper
{
    /**
     * Initialise the destination name in the activation configuration.
     * @param activationConfig The current activation configuration.
     * @param name The destination name.
     * @throws ConfigurationException For invalid configuration.
     */
    public void setDestination(final Map<String, String> activationConfig, final String name)
        throws ConfigurationException ;
    
    /**
     * Initialise the destination name in the activation configuration.
     * @param activationConfig The current activation configuration.
     * @param providerAdapterJNDI The provider adapter JNDI value or null is not specified.
     * @throws ConfigurationException For invalid configuration.
     */
    public void setProviderAdapterJNDI(final Map<String, String> activationConfig, final String providerAdapterJNDI)
        throws ConfigurationException ;
    
    /**
     * Initialise the destination name in the activation configuration.
     * @param activationConfig The current activation configuration.
     * @param queue True if specifying a JMS Queue, false is specifying a JMS Topic.
     * @throws ConfigurationException For invalid configuration.
     */
    public void setDestinationType(final Map<String, String> activationConfig, final boolean queue)
        throws ConfigurationException ;
    
    /**
     * Initialise the destination name in the activation configuration.
     * @param activationConfig The current activation configuration.
     * @param messageSelector The message selector or null if not specified.
     * @throws ConfigurationException For invalid configuration.
     */
    public void setMessageSelector(final Map<String, String> activationConfig, final String messageSelector)
        throws ConfigurationException ;

    /**
     * Initialise the destination name in the activation configuration.
     * @param activationConfig The current activation configuration.
     * @param maxThreads The maximum thread value or null if not specified.
     * @throws ConfigurationException For invalid configuration.
     */
    public void setMaxThreads(final Map<String, String> activationConfig, final Integer maxThreads)
        throws ConfigurationException ;
}
