/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.util;

import java.net.URI;

import org.jboss.internal.soa.esb.util.FtpImpl;
import org.jboss.internal.soa.esb.util.FtpsImpl;
import org.jboss.internal.soa.esb.util.SecureFtpImpl;
import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.jboss.soa.esb.addressing.eprs.FTPSEpr;
import org.jboss.soa.esb.addressing.eprs.SFTPEpr;

public class RemoteFileSystemFactory
{

        // private default constructor
        private RemoteFileSystemFactory()
        {
        }

        /**
         * This method returns a RemoteFileSystem Implementation at runtime.
         * The implementation depends on which protocol is specified in the 
         * URL of the RemoteFileSystem.
         * We currently support "ftp" and "sftp" 
         * Refactoring related to JIRA Tasks: JBESB-127 and JBESB-197 
         * @param p_oEpr
         * @param p_bConnect
         * @return RemoteFileSystem
         * @throws RemoteFileSystemException
         */
        public static RemoteFileSystem getRemoteFileSystem(FTPEpr p_oEpr,
                        boolean p_bConnect) throws RemoteFileSystemException
        {
                URI uri = null;
                try
                {
                        uri = p_oEpr.getURI();
                        final String scheme = uri.getScheme();
                        if (RemoteFileSystem.FTP_PROTOCOL.equals(scheme))
                                return new FtpImpl((FTPEpr) p_oEpr, p_bConnect);
                        else if (RemoteFileSystem.FTPS_PROTOCOL.equals(scheme))
                                return new FtpsImpl((FTPSEpr) p_oEpr, p_bConnect);
                        else if (RemoteFileSystem.SFTP_PROTOCOL.equals(scheme))
                                return new SecureFtpImpl((SFTPEpr) p_oEpr, p_bConnect);
                }
                catch (Exception e)
                {
                        throw new RemoteFileSystemException(e);
                }
                throw new RemoteFileSystemException("Unknown or unsupported protocol");
        }

}
