/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.message.mime;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;

import junit.framework.TestCase;

/**
 * 
 * @author <a href="mailto:tom.fennelly@gmail.com">tom.fennelly@gmail.com</a>
 */
public class MimeDecoderUnitTest extends TestCase {

	public void test_by_type_found() throws ConfigurationException {
		MimeDecoder mimeDecoder = MimeDecoder.Factory.getInstanceByType("text/plain");
		assertTrue(mimeDecoder instanceof TextPlainMimeDecoder);
	}

	public void test_by_type_not_found() {
		try {
			MimeDecoder.Factory.getInstanceByType("some/blah");
			fail("Expected ConfigurationException");
		} catch(ConfigurationException e) {
			assertEquals("Failed to find a MimeDecoder implementation for mime type 'some/blah'.  MimeDecoders must be listed in a 'META-INF/org/jboss/soa/esb/listeners/message/mime/decoders.lst' file on the classpath.", e.getMessage());
		}
	}

	public void test_by_classname() throws ConfigurationException {
		MimeDecoder mimeDecoder = MimeDecoder.Factory.getInstanceByClassName(TextPlainMimeDecoder.class.getName());
		assertTrue(mimeDecoder instanceof TextPlainMimeDecoder);
	}

	public void test_by_configtree_mimetype() throws ConfigurationException {
		ConfigTree config = new ConfigTree("config");
		
		config.setAttribute(MimeDecoder.Factory.MIME_TYPE, "text/plain");
		
		MimeDecoder mimeDecoder = MimeDecoder.Factory.getInstanceByConfigTree(config);
		assertTrue(mimeDecoder instanceof TextPlainMimeDecoder);
	}

	public void test_by_configtree_mimetype_unknown() throws ConfigurationException {
		ConfigTree config = new ConfigTree("config");
		
		config.setAttribute(MimeDecoder.Factory.MIME_TYPE, "some/blah");
		
		try {
			MimeDecoder.Factory.getInstanceByConfigTree(config);
			fail("Expected ConfigurationException");
		} catch(ConfigurationException e) {
			assertEquals("Failed to find a MimeDecoder implementation for mime type 'some/blah'.  MimeDecoders must be listed in a 'META-INF/org/jboss/soa/esb/listeners/message/mime/decoders.lst' file on the classpath.", e.getMessage());
		}
	}

	public void test_by_configtree_classname() throws ConfigurationException {
		ConfigTree config = new ConfigTree("config");
		
		config.setAttribute(MimeDecoder.Factory.MIME_DECODER, TextPlainMimeDecoder.class.getName());
		
		MimeDecoder mimeDecoder = MimeDecoder.Factory.getInstanceByConfigTree(config);
		assertTrue(mimeDecoder instanceof TextPlainMimeDecoder);
	}

	public void test_by_configtree_classname_unknown() throws ConfigurationException {
		ConfigTree config = new ConfigTree("config");
		
		config.setAttribute(MimeDecoder.Factory.MIME_DECODER, "com.XXX");
		
		try {
			MimeDecoder.Factory.getInstanceByConfigTree(config);
			fail("Expected ConfigurationException");
		} catch(ConfigurationException e) {
			assertEquals("MimeDecoder class 'com.XXX' is not available on the classpath.", e.getMessage());
		}
	}
}
