/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2010
 */
package org.jboss.internal.soa.esb.services.rules;

import org.apache.log4j.Logger;
import org.drools.agent.AgentEventListener;

/**
 * An AgentEventListener that uses log4j.
 * 
 * @author dward at jboss.org
 */
public class LogAgentEventListener extends LogSystemEventListener implements AgentEventListener
{
	
    private static final Logger logger = Logger.getLogger(LogAgentEventListener.class);
    
    private String message_prefix;
    
    public LogAgentEventListener()
    {
    	this(null);
    }
    
    public LogAgentEventListener(String agentName)
    {
    	super();
    	setAgentName(agentName);
    }
    
    @Override
    protected final Logger getLogger()
    {
    	return logger;
    }
    
    @Override
    protected final String getMessagePrefix()
    {
    	return message_prefix;
    }

    public final void setAgentName(String agentName)
    {
        message_prefix = new StringBuilder()
        	.append("Agent [")
        	.append(String.valueOf(agentName))
        	.append("] ")
        	.append(super.getMessagePrefix())
        	.toString();
    }
    
}
