package org.jbosson.plugins.jbossesb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import org.rhq.plugins.jbossas5.deploy.Deployer;
import org.rhq.plugins.jbossas5.deploy.LocalDeployer;
import org.rhq.plugins.jbossas5.deploy.RemoteDeployer;

import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.NoSuchDeploymentException;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.event.EventContext;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.rhq.plugins.jbossas5.util.FileContentDelegate;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceComponent;

/**
 * Component for ESB package deployment.
 *
 * @author Tom Cunningham
 */
public class ESB5DeploymentComponent extends AbstractDeploymentComponent {
	public void deleteResource() throws Exception {
        Configuration pluginConfiguration = getResourceContext().getPluginConfiguration();
        String fullFileName = pluginConfiguration.getSimple("deployment").getStringValue();
        
        ESB5Component jbossASComponent = (ESB5Component) getResourceContext().getParentResourceComponent();
        ProfileServiceConnection profileServiceConnection = jbossASComponent.getConnection();
        DeploymentManager deployMgr = profileServiceConnection.getDeploymentManager();

        String repositoryName = null;
        String [] arr = deployMgr.getRepositoryNames(new String[] {fullFileName});
        for (int i = 0; i<arr.length; i++) {
        	repositoryName = arr[i];
        }
        
        if (repositoryName != null) {
        	DeploymentProgress stop 	= null;
        	try {
        		stop = deployMgr.stop(repositoryName);
	            if (stop != null)
	            	stop.run(); 
	        } catch (Throwable t) {
        		log.error("Could not find deployment to delete.  " + t.getMessage());   
        		return;
	        } finally {
	            jbossASComponent.disconnectFromProfileService();
	        }

	        DeploymentStatus stopStatus = stop.getDeploymentStatus();        	
	        if (stopStatus.isFailed()) {
	        	
	        	if ((stopStatus.getFailure() != null) && (stopStatus.getFailure().getCause() != null) 
	            	&& (stopStatus.getFailure().getCause() instanceof java.lang.NullPointerException)) {	            			
	        		// jon 2.3 case
	        		// If we get a NPE here, it means that the .esb deployment has already been deleted
	                // Return here because otherwise JON will not update and remove the deployment
	                log.error("Failed to stop deployment '" + repositoryName + "'.", stopStatus.getFailure());
	                jbossASComponent.disconnectFromProfileService();

	                return;
	            } else if ((stopStatus.getFailure().getCause() != null) 
	            	&& (stopStatus.getFailure().getCause() instanceof org.jboss.profileservice.spi.NoSuchDeploymentException)) {
	                // jon 2.4 case
	            	// If we get a NPE here, it means that the .esb deployment has already been deleted
	                // Return here because otherwise JON will not update and remove the deployment
	                log.error("Failed to stop deployment '" + repositoryName + "'.", stopStatus.getFailure());
	                jbossASComponent.disconnectFromProfileService();
	    
	                return;
	            }
	            log.error("Failed to stop deployment '" + repositoryName + "'.", stopStatus.getFailure());
	            throw new Exception("Failed to stop deployment '" + repositoryName + "' - cause: "
	            		+ stopStatus.getFailure());
	        }        
            DeploymentProgress remove = deployMgr.remove(repositoryName);        
            if (remove != null) {
                remove.run();
    	        DeploymentStatus status = remove.getDeploymentStatus();
    	        if (status.isFailed()) {
            		log.error("Failed to remove deployment '" + repositoryName + "'.", status.getFailure());
            		throw new Exception("Failed to remove deployment '" + repositoryName + ".    "
            				+ "If the deployment has already been removed through other means and you want to "
            				+ "remove it from JON, uninventory it from the Resources section.   Cause: "
            				+ status.getFailure());
    	        }
            } else {
            	throw new RuntimeException("Did not find Deployment " + fullFileName);        	
            }
        }

        ManagementView mView = profileServiceConnection.getManagementView();
        mView.load();
        
        jbossASComponent.disconnectFromProfileService();
 	}
}
