package org.jboss.soa.esb.quickstart.test;

import junit.framework.Test;

import org.jboss.soa.esb.samples.quickstart.publishAsWebservice.test.SOAPTest;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.ConfigurationException;

public class PublishAsWebserviceInOnlyTest extends AbstractQuickstartTestCase {
	public PublishAsWebserviceInOnlyTest(String name) {
		super(name);
	}

	public void testPublishAsWebservice() throws Exception {
		String MESSAGE_XML = "soap-userpass-message.xml";
		String ERROR_XML = "error-soap-message.xml";
		
		runTest(MESSAGE_XML);
		runTest(ERROR_XML);
	}

	public void runTest(String file) throws Exception {
		String fileLocation = Helpers.getQuickstartLocation("publish_as_webservice_inonly" + File.separator + file);
		String soap = StreamUtils.getResourceAsString(fileLocation, "UTF-8");
        HttpClient client = new HttpClient();
        PostMethod postMethod = new PostMethod(
                        "http://127.0.0.1:8080/Quickstart_publish_as_webservice_inonly/ebws/ESBServiceSample/HelloWorldPubServiceInOnly?wsdl");

        StringRequestEntity requestEntity = new StringRequestEntity(soap);
        postMethod.setRequestEntity(requestEntity);
        try {
                client.executeMethod(postMethod);
                System.out.println("Response from web service (should be empty since this is \"inonly\")");
                System.out.println("[" + postMethod.getResponseBodyAsString() + "]");
        } catch (HttpException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
        } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
        }
	}
	
	public static Test suite() throws Exception {
		return getDeploySetup(PublishAsWebserviceInOnlyTest.class, "QuickstartMessageStoreServer.sar, Quickstart_publish_as_webservice_inonly.esb");
	}

}
