package org.jboss.soa.esb.quickstart.test;

import java.io.InputStream;

import junit.framework.Test;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.jboss.internal.soa.esb.util.StreamUtils;

import org.jboss.soa.esb.samples.quickstart.webservice_proxy_routed.test.SendWSMessage;

public class WebServiceProxyRoutedTest extends AbstractQuickstartTestCase {
	public WebServiceProxyRoutedTest(String name) {
		super(name);
	}

    private static final String HELLO_SOAP_PRE =
        "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:hello=\"http://webservice_proxy_routed/hello\">" +
                "<soapenv:Header/>" +
                "<soapenv:Body>" +
                        "<hello:sayHello>" +
                                "<toWhom>";

    private static final String HELLO_SOAP_POST =
                                "</toWhom>" +
                        "</hello:sayHello>" +
                "</soapenv:Body>" +
        "</soapenv:Envelope>";
	
    private static final String GOODBYE_SOAP_PRE =
        "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:goodbye=\"http://webservice_proxy_routed/goodbye\">" +
                "<soapenv:Header/>" +
                "<soapenv:Body>" +
                        "<goodbye:sayGoodbye>" +
                                "<toWhom>";

    private static final String GOODBYE_SOAP_POST =
                                "</toWhom>" +
                        "</goodbye:sayGoodbye>" +
                "</soapenv:Body>" +
        "</soapenv:Envelope>";
	
	public void testWS() throws Exception {
		clearMessages();
		SendWSMessage ws = new SendWSMessage();
		String url = "http://localhost:8080/Quickstart_webservice_proxy_routed/http/Proxy_Routed/Proxy_CBR";
		String user = "jbossesb";
		String hellostring = "hello";
		
		System.out.println("****  REQUEST  URL: " + url);
        PostMethod method = new PostMethod(url);
        method.setRequestHeader("Content-Type", "text/xml;charset=UTF-8");

        // this line should be used for better performance/interop but is not necessary
        // http://www.w3.org/TR/2000/NOTE-SOAP-20000508/#_Toc478383528
        // http://www.ws-i.org/Profiles/BasicProfile-1.1.html#SOAPAction_HTTP_Header
        method.setRequestHeader("SOAPAction", "\"\"");

        boolean hello = "hello".equals(hellostring);
        String request = (hello ? HELLO_SOAP_PRE : GOODBYE_SOAP_PRE) + user + (hello ? HELLO_SOAP_POST : GOODBYE_SOAP_POST);
        System.out.println("****  REQUEST BODY: " + request);
        method.setRequestEntity( new StringRequestEntity(request) );
		
        HttpClient client = new HttpClient();
        InputStream response = null;
        try
        {
                int code = client.executeMethod(method);
                System.out.println("**** RESPONSE CODE: " + code);

                response = method.getResponseBodyAsStream();
                byte[] bytes = StreamUtils.readStream(response);
                System.out.println("**** RESPONSE BODY: " + new String(bytes, method.getResponseCharSet()));
        }
        finally
        {
                method.releaseConnection();
                if (response != null)
                {
                        response.close();
                }
        }

		
	}

	public static Test suite() throws Exception {
		return getDeploySetup(WebServiceProxyRoutedTest.class, "QuickstartMessageStoreServer.sar, Quickstart_webservice_proxy_routed.esb");
	}	
}
