/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.tests.samples;

import org.jboss.soa.bpel.tests.RiftSawTest;
import org.jboss.soa.bpel.tests.RiftSawTestSetup;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;

import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;

import junit.framework.Test;

/**
 * Test case for running the Quickstart_bpel_secure_service sample.
 */
public class QuickstartBPELSecureServiceTestCase extends RiftSawTest {

	private static final String TEST_NAME = "Quickstart_bpel_secure_service";
    private static final QName SERVICE_NAME = new QName("http://www.jboss.org/bpel/examples/wsdl", "SecureHelloService");
    private static final QName TH_SERVICE_NAME = new QName("http://harness.tests.bpel.soa.jboss.org/", "SecureServiceTestHarnessService");

	public QuickstartBPELSecureServiceTestCase() {
		super(TEST_NAME);
	}
	
	public static Test suite() {
		if (System.getProperty("ws.stack","native").equals("cxf")) {
			return(new RiftSawTestSetup(QuickstartBPELSecureServiceTestCase.class,
						TEST_NAME, "Quickstart_bpel_secure_service-1.jar,Quickstart_bpel_secure_service_testharness.war"));
		} else {
			return(null);
		}
	}

	public void testSendHello() throws Exception {
		if (System.getProperty("ws.stack","native").equals("cxf") == false) {
			return;
		}
		
		String result=sendSOAPMessage("harness_request1.xml",
				"http://127.0.0.1:8080/Quickstart_bpel_secure_service_testharness/SecureServiceTestHarnessWS");

        if (result.contains("<return>true</return>") == false) {
        	fail("Failed to receive successful response from remote test harness");
        }
	}
}
